/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import jxl.Cell;
import jxl.CellFeatures;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.HeaderFooter;
import jxl.NumberCell;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.AutoFilter;
import jxl.biff.AutoFilterInfoRecord;
import jxl.biff.AutoFilterRecord;
import jxl.biff.ConditionalFormat;
import jxl.biff.ConditionalFormatRangeRecord;
import jxl.biff.ConditionalFormatRecord;
import jxl.biff.ContinueRecord;
import jxl.biff.DataValidation;
import jxl.biff.DataValidityListRecord;
import jxl.biff.DataValiditySettingsRecord;
import jxl.biff.FilterModeRecord;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.WorkbookMethods;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.WritableRecordData;
import jxl.biff.drawing.Button;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.ComboBox;
import jxl.biff.drawing.Comment;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.Drawing2;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingDataException;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.NoteRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.TextObjectRecord;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.BlankCell;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.BottomMarginRecord;
import jxl.read.biff.ButtonPropertySetRecord;
import jxl.read.biff.CalcModeRecord;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.CellValue;
import jxl.read.biff.CentreRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DateFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DefaultColumnWidthRecord;
import jxl.read.biff.DefaultRowHeightRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FooterRecord;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.GuttersRecord;
import jxl.read.biff.HeaderRecord;
import jxl.read.biff.HorizontalPageBreaksRecord;
import jxl.read.biff.HyperlinkRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.LeftMarginRecord;
import jxl.read.biff.MarginRecord;
import jxl.read.biff.MergedCellsRecord;
import jxl.read.biff.MulBlankCell;
import jxl.read.biff.MulBlankRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.PLSRecord;
import jxl.read.biff.PaneRecord;
import jxl.read.biff.PasswordRecord;
import jxl.read.biff.PrintGridLinesRecord;
import jxl.read.biff.PrintHeadersRecord;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.RStringRecord;
import jxl.read.biff.Record;
import jxl.read.biff.RightMarginRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SCLRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SaveRecalcRecord;
import jxl.read.biff.SetupRecord;
import jxl.read.biff.SharedFormulaRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.TopMarginRecord;
import jxl.read.biff.VerticalPageBreaksRecord;
import jxl.read.biff.Window2Record;
import jxl.read.biff.WorkbookParser;

final class SheetReader {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$SheetReader == null ? (class$jxl$read$biff$SheetReader = SheetReader.class$("jxl.read.biff.SheetReader")) : class$jxl$read$biff$SheetReader);
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord sheetBof;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private ArrayList outOfBoundsCells;
    private int startPosition;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private ArrayList conditionalFormats;
    private AutoFilter autoFilter;
    private Range[] mergedCells;
    private DataValidation dataValidation;
    private ArrayList charts;
    private ArrayList drawings;
    private DrawingData drawingData;
    private boolean nineteenFour;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private WorkspaceInformationRecord workspaceOptions;
    private int[] rowBreaks;
    private int[] columnBreaks;
    private int maxRowOutlineLevel;
    private int maxColumnOutlineLevel;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private WorkbookParser workbook;
    private SheetImpl sheet;
    static /* synthetic */ Class class$jxl$read$biff$SheetReader;

    SheetReader(File file, SSTRecord sSTRecord, FormattingRecords formattingRecords, BOFRecord bOFRecord, BOFRecord bOFRecord2, boolean bl, WorkbookParser workbookParser, int n, SheetImpl sheetImpl) {
        this.excelFile = file;
        this.sharedStrings = sSTRecord;
        this.formattingRecords = formattingRecords;
        this.sheetBof = bOFRecord;
        this.workbookBof = bOFRecord2;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.conditionalFormats = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.charts = new ArrayList();
        this.drawings = new ArrayList();
        this.outOfBoundsCells = new ArrayList();
        this.nineteenFour = bl;
        this.workbook = workbookParser;
        this.startPosition = n;
        this.sheet = sheetImpl;
        this.settings = new SheetSettings(sheetImpl);
        this.workbookSettings = this.workbook.getSettings();
    }

    private void addCell(Cell cell) {
        if (cell.getRow() < this.numRows && cell.getColumn() < this.numCols) {
            if (this.cells[cell.getRow()][cell.getColumn()] != null) {
                StringBuffer stringBuffer = new StringBuffer();
                CellReferenceHelper.getCellReference(cell.getColumn(), cell.getRow(), stringBuffer);
                logger.warn("Cell " + stringBuffer.toString() + " already contains data");
            }
            this.cells[cell.getRow()][cell.getColumn()] = cell;
        } else {
            this.outOfBoundsCells.add(cell);
        }
    }

    final void read() {
        Object object;
        Object object2;
        Record record = null;
        BaseSharedFormulaRecord baseSharedFormulaRecord = null;
        boolean bl = false;
        boolean bl2 = true;
        this.excelFile.setPos(this.startPosition);
        MsoDrawingRecord msoDrawingRecord = null;
        ObjRecord objRecord = null;
        boolean bl3 = true;
        ConditionalFormat conditionalFormat = null;
        FilterModeRecord filterModeRecord = null;
        AutoFilterInfoRecord autoFilterInfoRecord = null;
        Window2Record window2Record = null;
        PrintGridLinesRecord printGridLinesRecord = null;
        PrintHeadersRecord printHeadersRecord = null;
        HashMap hashMap = new HashMap();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ContinueRecord continueRecord = null;
        while (bl2) {
            Cell cell;
            int n;
            record = this.excelFile.next();
            object2 = record.getType();
            if (object2 == Type.UNKNOWN && record.getCode() == 0) {
                logger.warn("Biff code zero found");
                if (record.getLength() == 10) {
                    logger.warn("Biff code zero found - trying a dimension record.");
                    record.setType(Type.DIMENSION);
                } else {
                    logger.warn("Biff code zero found - Ignoring.");
                }
            }
            if (object2 == Type.DIMENSION) {
                object = null;
                object = this.workbookBof.isBiff8() ? new DimensionRecord(record) : new DimensionRecord(record, DimensionRecord.biff7);
                this.numRows = ((DimensionRecord)object).getNumberOfRows();
                this.numCols = ((DimensionRecord)object).getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
                continue;
            }
            if (object2 == Type.LABELSST) {
                object = new LabelSSTRecord(record, this.sharedStrings, this.formattingRecords, this.sheet);
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.RK || object2 == Type.RK2) {
                object = new RKRecord(record, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(((CellValue)object).getXFIndex())) {
                    DateRecord dateRecord = new DateRecord((NumberCell)object, ((CellValue)object).getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dateRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.HLINK) {
                object = new HyperlinkRecord(record, this.sheet, this.workbookSettings);
                this.hyperlinks.add(object);
                continue;
            }
            if (object2 == Type.MERGEDCELLS) {
                object = new MergedCellsRecord(record, this.sheet);
                if (this.mergedCells == null) {
                    this.mergedCells = ((MergedCellsRecord)object).getRanges();
                    continue;
                }
                Range[] rangeArray = new Range[this.mergedCells.length + ((MergedCellsRecord)object).getRanges().length];
                System.arraycopy(this.mergedCells, 0, rangeArray, 0, this.mergedCells.length);
                System.arraycopy(((MergedCellsRecord)object).getRanges(), 0, rangeArray, this.mergedCells.length, ((MergedCellsRecord)object).getRanges().length);
                this.mergedCells = rangeArray;
                continue;
            }
            if (object2 == Type.MULRK) {
                object = new MulRKRecord(record);
                int n2 = ((MulRKRecord)object).getNumberOfColumns();
                int n3 = 0;
                for (n = 0; n < n2; ++n) {
                    n3 = ((MulRKRecord)object).getXFIndex(n);
                    cell = new NumberValue(((MulRKRecord)object).getRow(), ((MulRKRecord)object).getFirstColumn() + n, RKHelper.getDouble(((MulRKRecord)object).getRKNumber(n)), n3, this.formattingRecords, this.sheet);
                    if (this.formattingRecords.isDate(n3)) {
                        DateRecord dateRecord = new DateRecord((NumberCell)cell, n3, this.formattingRecords, this.nineteenFour, this.sheet);
                        this.addCell(dateRecord);
                        continue;
                    }
                    cell.setNumberFormat(this.formattingRecords.getNumberFormat(n3));
                    this.addCell(cell);
                }
                continue;
            }
            if (object2 == Type.NUMBER) {
                object = new NumberRecord(record, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(((CellValue)object).getXFIndex())) {
                    DateRecord dateRecord = new DateRecord((NumberCell)object, ((CellValue)object).getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dateRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.BOOLERR) {
                object = new BooleanRecord(record, this.formattingRecords, this.sheet);
                if (((BooleanRecord)object).isError()) {
                    ErrorRecord errorRecord = new ErrorRecord(((BooleanRecord)object).getRecord(), this.formattingRecords, this.sheet);
                    this.addCell(errorRecord);
                    continue;
                }
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.PRINTGRIDLINES) {
                printGridLinesRecord = new PrintGridLinesRecord(record);
                this.settings.setPrintGridLines(printGridLinesRecord.getPrintGridLines());
                continue;
            }
            if (object2 == Type.PRINTHEADERS) {
                printHeadersRecord = new PrintHeadersRecord(record);
                this.settings.setPrintHeaders(printHeadersRecord.getPrintHeaders());
                continue;
            }
            if (object2 == Type.WINDOW2) {
                window2Record = null;
                window2Record = this.workbookBof.isBiff8() ? new Window2Record(record) : new Window2Record(record, Window2Record.biff7);
                this.settings.setShowGridLines(window2Record.getShowGridLines());
                this.settings.setDisplayZeroValues(window2Record.getDisplayZeroValues());
                this.settings.setSelected(true);
                this.settings.setPageBreakPreviewMode(window2Record.isPageBreakPreview());
                continue;
            }
            if (object2 == Type.PANE) {
                object = new PaneRecord(record);
                if (window2Record == null || !window2Record.getFrozen()) continue;
                this.settings.setVerticalFreeze(((PaneRecord)object).getRowsVisible());
                this.settings.setHorizontalFreeze(((PaneRecord)object).getColumnsVisible());
                continue;
            }
            if (object2 == Type.CONTINUE) {
                continueRecord = new ContinueRecord(record);
                continue;
            }
            if (object2 == Type.NOTE) {
                if (this.workbookSettings.getDrawingsDisabled()) continue;
                object = new NoteRecord(record);
                Comment comment = (Comment)hashMap.remove(new Integer(((NoteRecord)object).getObjectId()));
                if (comment == null) {
                    logger.warn(" cannot find comment for note id " + ((NoteRecord)object).getObjectId() + "...ignoring");
                    continue;
                }
                comment.setNote((NoteRecord)object);
                this.drawings.add(comment);
                this.addCellComment(comment.getColumn(), comment.getRow(), comment.getText(), comment.getWidth(), comment.getHeight());
                continue;
            }
            if (object2 == Type.ARRAY) continue;
            if (object2 == Type.PROTECT) {
                object = new ProtectRecord(record);
                this.settings.setProtected(((ProtectRecord)object).isProtected());
                continue;
            }
            if (object2 == Type.SHAREDFORMULA) {
                if (baseSharedFormulaRecord == null) {
                    logger.warn("Shared template formula is null - trying most recent formula template");
                    object = (SharedFormulaRecord)this.sharedFormulas.get(this.sharedFormulas.size() - 1);
                    if (object != null) {
                        baseSharedFormulaRecord = ((SharedFormulaRecord)object).getTemplateFormula();
                    }
                }
                object = new SharedFormulaRecord(record, baseSharedFormulaRecord, this.workbook, this.workbook, this.sheet);
                this.sharedFormulas.add(object);
                baseSharedFormulaRecord = null;
                continue;
            }
            if (object2 == Type.FORMULA || object2 == Type.FORMULA2) {
                object = new FormulaRecord(record, this.excelFile, this.formattingRecords, this.workbook, this.workbook, this.sheet, this.workbookSettings);
                if (((FormulaRecord)object).isShared()) {
                    BaseSharedFormulaRecord baseSharedFormulaRecord2 = baseSharedFormulaRecord;
                    baseSharedFormulaRecord = (BaseSharedFormulaRecord)((FormulaRecord)object).getFormula();
                    bl = this.addToSharedFormulas(baseSharedFormulaRecord);
                    if (bl) {
                        baseSharedFormulaRecord = baseSharedFormulaRecord2;
                    }
                    if (bl || baseSharedFormulaRecord2 == null) continue;
                    this.addCell(this.revertSharedFormula(baseSharedFormulaRecord2));
                    continue;
                }
                Cell cell2 = ((FormulaRecord)object).getFormula();
                try {
                    NumberFormulaRecord numberFormulaRecord;
                    if (((FormulaRecord)object).getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((numberFormulaRecord = (NumberFormulaRecord)((FormulaRecord)object).getFormula()).getXFIndex())) {
                        cell2 = new DateFormulaRecord(numberFormulaRecord, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
                    }
                    this.addCell(cell2);
                }
                catch (FormulaException formulaException) {
                    logger.warn(CellReferenceHelper.getCellReference(cell2.getColumn(), cell2.getRow()) + " " + formulaException.getMessage());
                }
                continue;
            }
            if (object2 == Type.LABEL) {
                object = null;
                object = this.workbookBof.isBiff8() ? new LabelRecord(record, this.formattingRecords, this.sheet, this.workbookSettings) : new LabelRecord(record, this.formattingRecords, this.sheet, this.workbookSettings, LabelRecord.biff7);
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.RSTRING) {
                object = null;
                Assert.verify(!this.workbookBof.isBiff8());
                object = new RStringRecord(record, this.formattingRecords, this.sheet, this.workbookSettings, RStringRecord.biff7);
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.NAME) continue;
            if (object2 == Type.PASSWORD) {
                object = new PasswordRecord(record);
                this.settings.setPasswordHash(((PasswordRecord)object).getPasswordHash());
                continue;
            }
            if (object2 == Type.ROW) {
                object = new RowRecord(record);
                if (((RowRecord)object).isDefaultHeight() && ((RowRecord)object).matchesDefaultFontHeight() && !((RowRecord)object).isCollapsed() && !((RowRecord)object).hasDefaultFormat() && ((RowRecord)object).getOutlineLevel() == 0) continue;
                this.rowProperties.add(object);
                continue;
            }
            if (object2 == Type.BLANK) {
                if (this.workbookSettings.getIgnoreBlanks()) continue;
                object = new BlankCell(record, this.formattingRecords, this.sheet);
                this.addCell((Cell)object);
                continue;
            }
            if (object2 == Type.MULBLANK) {
                if (this.workbookSettings.getIgnoreBlanks()) continue;
                object = new MulBlankRecord(record);
                int n4 = ((MulBlankRecord)object).getNumberOfColumns();
                for (int i = 0; i < n4; ++i) {
                    n = ((MulBlankRecord)object).getXFIndex(i);
                    cell = new MulBlankCell(((MulBlankRecord)object).getRow(), ((MulBlankRecord)object).getFirstColumn() + i, n, this.formattingRecords, this.sheet);
                    this.addCell(cell);
                }
                continue;
            }
            if (object2 == Type.SCL) {
                object = new SCLRecord(record);
                this.settings.setZoomFactor(((SCLRecord)object).getZoomFactor());
                continue;
            }
            if (object2 == Type.COLINFO) {
                object = new ColumnInfoRecord(record);
                this.columnInfosArray.add(object);
                continue;
            }
            if (object2 == Type.HEADER) {
                object = null;
                object = this.workbookBof.isBiff8() ? new HeaderRecord(record, this.workbookSettings) : new HeaderRecord(record, this.workbookSettings, HeaderRecord.biff7);
                HeaderFooter headerFooter = new HeaderFooter(((HeaderRecord)object).getHeader());
                this.settings.setHeader(headerFooter);
                continue;
            }
            if (object2 == Type.FOOTER) {
                object = null;
                object = this.workbookBof.isBiff8() ? new FooterRecord(record, this.workbookSettings) : new FooterRecord(record, this.workbookSettings, FooterRecord.biff7);
                HeaderFooter headerFooter = new HeaderFooter(((FooterRecord)object).getFooter());
                this.settings.setFooter(headerFooter);
                continue;
            }
            if (object2 == Type.SETUP) {
                object = new SetupRecord(record);
                if (!((SetupRecord)object).getInitialized()) continue;
                if (((SetupRecord)object).isPortrait()) {
                    this.settings.setOrientation(PageOrientation.PORTRAIT);
                } else {
                    this.settings.setOrientation(PageOrientation.LANDSCAPE);
                }
                this.settings.setPaperSize(PaperSize.getPaperSize(((SetupRecord)object).getPaperSize()));
                this.settings.setHeaderMargin(((SetupRecord)object).getHeaderMargin());
                this.settings.setFooterMargin(((SetupRecord)object).getFooterMargin());
                this.settings.setScaleFactor(((SetupRecord)object).getScaleFactor());
                this.settings.setPageStart(((SetupRecord)object).getPageStart());
                this.settings.setFitWidth(((SetupRecord)object).getFitWidth());
                this.settings.setFitHeight(((SetupRecord)object).getFitHeight());
                this.settings.setHorizontalPrintResolution(((SetupRecord)object).getHorizontalPrintResolution());
                this.settings.setVerticalPrintResolution(((SetupRecord)object).getVerticalPrintResolution());
                this.settings.setCopies(((SetupRecord)object).getCopies());
                if (this.workspaceOptions == null) continue;
                this.settings.setFitToPages(this.workspaceOptions.getFitToPages());
                continue;
            }
            if (object2 == Type.WSBOOL) {
                this.workspaceOptions = new WorkspaceInformationRecord(record);
                continue;
            }
            if (object2 == Type.DEFCOLWIDTH) {
                object = new DefaultColumnWidthRecord(record);
                this.settings.setDefaultColumnWidth(((DefaultColumnWidthRecord)object).getWidth());
                continue;
            }
            if (object2 == Type.DEFAULTROWHEIGHT) {
                object = new DefaultRowHeightRecord(record);
                if (((DefaultRowHeightRecord)object).getHeight() == 0) continue;
                this.settings.setDefaultRowHeight(((DefaultRowHeightRecord)object).getHeight());
                continue;
            }
            if (object2 == Type.CONDFMT) {
                object = new ConditionalFormatRangeRecord(record);
                conditionalFormat = new ConditionalFormat((ConditionalFormatRangeRecord)object);
                this.conditionalFormats.add(conditionalFormat);
                continue;
            }
            if (object2 == Type.CF) {
                object = new ConditionalFormatRecord(record);
                conditionalFormat.addCondition((ConditionalFormatRecord)object);
                continue;
            }
            if (object2 == Type.FILTERMODE) {
                filterModeRecord = new FilterModeRecord(record);
                continue;
            }
            if (object2 == Type.AUTOFILTERINFO) {
                autoFilterInfoRecord = new AutoFilterInfoRecord(record);
                continue;
            }
            if (object2 == Type.AUTOFILTER) {
                if (this.workbookSettings.getAutoFilterDisabled()) continue;
                object = new AutoFilterRecord(record);
                if (this.autoFilter == null) {
                    this.autoFilter = new AutoFilter(filterModeRecord, autoFilterInfoRecord);
                    filterModeRecord = null;
                    autoFilterInfoRecord = null;
                }
                this.autoFilter.add((AutoFilterRecord)object);
                continue;
            }
            if (object2 == Type.LEFTMARGIN) {
                object = new LeftMarginRecord(record);
                this.settings.setLeftMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (object2 == Type.RIGHTMARGIN) {
                object = new RightMarginRecord(record);
                this.settings.setRightMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (object2 == Type.TOPMARGIN) {
                object = new TopMarginRecord(record);
                this.settings.setTopMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (object2 == Type.BOTTOMMARGIN) {
                object = new BottomMarginRecord(record);
                this.settings.setBottomMargin(((MarginRecord)object).getMargin());
                continue;
            }
            if (object2 == Type.HORIZONTALPAGEBREAKS) {
                object = null;
                object = this.workbookBof.isBiff8() ? new HorizontalPageBreaksRecord(record) : new HorizontalPageBreaksRecord(record, HorizontalPageBreaksRecord.biff7);
                this.rowBreaks = ((HorizontalPageBreaksRecord)object).getRowBreaks();
                continue;
            }
            if (object2 == Type.VERTICALPAGEBREAKS) {
                object = null;
                object = this.workbookBof.isBiff8() ? new VerticalPageBreaksRecord(record) : new VerticalPageBreaksRecord(record, VerticalPageBreaksRecord.biff7);
                this.columnBreaks = ((VerticalPageBreaksRecord)object).getColumnBreaks();
                continue;
            }
            if (object2 == Type.PLS) {
                this.plsRecord = new PLSRecord(record);
                continue;
            }
            if (object2 == Type.DVAL) {
                if (this.workbookSettings.getCellValidationDisabled()) continue;
                object = new DataValidityListRecord(record);
                if (((DataValidityListRecord)object).getObjectId() == -1) {
                    if (msoDrawingRecord != null && objRecord == null) {
                        if (this.drawingData == null) {
                            this.drawingData = new DrawingData();
                        }
                        Drawing2 drawing2 = new Drawing2(msoDrawingRecord, this.drawingData, this.workbook.getDrawingGroup());
                        this.drawings.add(drawing2);
                        msoDrawingRecord = null;
                        this.dataValidation = new DataValidation((DataValidityListRecord)object);
                        continue;
                    }
                    this.dataValidation = new DataValidation((DataValidityListRecord)object);
                    continue;
                }
                if (arrayList.contains(new Integer(((DataValidityListRecord)object).getObjectId()))) {
                    this.dataValidation = new DataValidation((DataValidityListRecord)object);
                    continue;
                }
                logger.warn("object id " + ((DataValidityListRecord)object).getObjectId() + " referenced " + " by data validity list record not found - ignoring");
                continue;
            }
            if (object2 == Type.HCENTER) {
                object = new CentreRecord(record);
                this.settings.setHorizontalCentre(((CentreRecord)object).isCentre());
                continue;
            }
            if (object2 == Type.VCENTER) {
                object = new CentreRecord(record);
                this.settings.setVerticalCentre(((CentreRecord)object).isCentre());
                continue;
            }
            if (object2 == Type.DV) {
                if (this.workbookSettings.getCellValidationDisabled()) continue;
                object = new DataValiditySettingsRecord(record, (ExternalSheet)this.workbook, (WorkbookMethods)this.workbook, this.workbook.getSettings());
                if (this.dataValidation != null) {
                    this.dataValidation.add((DataValiditySettingsRecord)object);
                    this.addCellValidation(((DataValiditySettingsRecord)object).getFirstColumn(), ((DataValiditySettingsRecord)object).getFirstRow(), ((DataValiditySettingsRecord)object).getLastColumn(), ((DataValiditySettingsRecord)object).getLastRow(), (DataValiditySettingsRecord)object);
                    continue;
                }
                logger.warn("cannot add data validity settings");
                continue;
            }
            if (object2 == Type.OBJ) {
                objRecord = new ObjRecord(record);
                if (!this.workbookSettings.getDrawingsDisabled()) {
                    if (msoDrawingRecord == null && continueRecord != null) {
                        logger.warn("Cannot find drawing record - using continue record");
                        msoDrawingRecord = new MsoDrawingRecord(continueRecord.getRecord());
                        continueRecord = null;
                    }
                    this.handleObjectRecord(objRecord, msoDrawingRecord, hashMap);
                    arrayList.add(new Integer(objRecord.getObjectId()));
                }
                if (objRecord.getType() == ObjRecord.CHART) continue;
                objRecord = null;
                msoDrawingRecord = null;
                continue;
            }
            if (object2 == Type.MSODRAWING) {
                if (this.workbookSettings.getDrawingsDisabled()) continue;
                if (msoDrawingRecord != null) {
                    this.drawingData.addRawData(msoDrawingRecord.getData());
                }
                msoDrawingRecord = new MsoDrawingRecord(record);
                if (!bl3) continue;
                msoDrawingRecord.setFirst();
                bl3 = false;
                continue;
            }
            if (object2 == Type.BUTTONPROPERTYSET) {
                this.buttonPropertySet = new ButtonPropertySetRecord(record);
                continue;
            }
            if (object2 == Type.CALCMODE) {
                object = new CalcModeRecord(record);
                this.settings.setAutomaticFormulaCalculation(((CalcModeRecord)object).isAutomatic());
                continue;
            }
            if (object2 == Type.SAVERECALC) {
                object = new SaveRecalcRecord(record);
                this.settings.setRecalculateFormulasBeforeSave(((SaveRecalcRecord)object).getRecalculateOnSave());
                continue;
            }
            if (object2 == Type.GUTS) {
                object = new GuttersRecord(record);
                this.maxRowOutlineLevel = ((GuttersRecord)object).getRowOutlineLevel() > 0 ? ((GuttersRecord)object).getRowOutlineLevel() - 1 : 0;
                this.maxColumnOutlineLevel = ((GuttersRecord)object).getColumnOutlineLevel() > 0 ? ((GuttersRecord)object).getRowOutlineLevel() - 1 : 0;
                continue;
            }
            if (object2 == Type.BOF) {
                object = new BOFRecord(record);
                Assert.verify(!((BOFRecord)object).isWorksheet());
                int n5 = this.excelFile.getPos() - record.getLength() - 4;
                Record record2 = this.excelFile.next();
                while (record2.getCode() != Type.EOF.value) {
                    record2 = this.excelFile.next();
                }
                if (((BOFRecord)object).isChart()) {
                    if (!this.workbook.getWorkbookBof().isBiff8()) {
                        logger.warn("only biff8 charts are supported");
                    } else {
                        if (this.drawingData == null) {
                            this.drawingData = new DrawingData();
                        }
                        if (!this.workbookSettings.getDrawingsDisabled()) {
                            Chart chart = new Chart(msoDrawingRecord, objRecord, this.drawingData, n5, this.excelFile.getPos(), this.excelFile, this.workbookSettings);
                            this.charts.add(chart);
                            if (this.workbook.getDrawingGroup() != null) {
                                this.workbook.getDrawingGroup().add(chart);
                            }
                        }
                    }
                    msoDrawingRecord = null;
                    objRecord = null;
                }
                if (!this.sheetBof.isChart()) continue;
                bl2 = false;
                continue;
            }
            if (object2 != Type.EOF) continue;
            bl2 = false;
        }
        this.excelFile.restorePos();
        if (this.outOfBoundsCells.size() > 0) {
            this.handleOutOfBoundsCells();
        }
        object2 = this.sharedFormulas.iterator();
        while (object2.hasNext()) {
            object = (SharedFormulaRecord)object2.next();
            Cell[] cellArray = ((SharedFormulaRecord)object).getFormulas(this.formattingRecords, this.nineteenFour);
            for (int i = 0; i < cellArray.length; ++i) {
                this.addCell(cellArray[i]);
            }
        }
        if (!bl && baseSharedFormulaRecord != null) {
            this.addCell(this.revertSharedFormula(baseSharedFormulaRecord));
        }
        if (msoDrawingRecord != null && this.workbook.getDrawingGroup() != null) {
            this.workbook.getDrawingGroup().setDrawingsOmitted(msoDrawingRecord, objRecord);
        }
        if (!hashMap.isEmpty()) {
            logger.warn("Not all comments have a corresponding Note record");
        }
    }

    private boolean addToSharedFormulas(BaseSharedFormulaRecord baseSharedFormulaRecord) {
        boolean bl = false;
        SharedFormulaRecord sharedFormulaRecord = null;
        int n = this.sharedFormulas.size();
        for (int i = 0; i < n && !bl; ++i) {
            sharedFormulaRecord = (SharedFormulaRecord)this.sharedFormulas.get(i);
            bl = sharedFormulaRecord.add(baseSharedFormulaRecord);
        }
        return bl;
    }

    private Cell revertSharedFormula(BaseSharedFormulaRecord baseSharedFormulaRecord) {
        int n = this.excelFile.getPos();
        this.excelFile.setPos(baseSharedFormulaRecord.getFilePos());
        FormulaRecord formulaRecord = new FormulaRecord(baseSharedFormulaRecord.getRecord(), this.excelFile, this.formattingRecords, this.workbook, this.workbook, FormulaRecord.ignoreSharedFormula, this.sheet, this.workbookSettings);
        try {
            Cell cell = formulaRecord.getFormula();
            if (formulaRecord.getFormula().getType() == CellType.NUMBER_FORMULA) {
                NumberFormulaRecord numberFormulaRecord = (NumberFormulaRecord)formulaRecord.getFormula();
                if (this.formattingRecords.isDate(formulaRecord.getXFIndex())) {
                    cell = new DateFormulaRecord(numberFormulaRecord, this.formattingRecords, this.workbook, this.workbook, this.nineteenFour, this.sheet);
                }
            }
            this.excelFile.setPos(n);
            return cell;
        }
        catch (FormulaException formulaException) {
            logger.warn(CellReferenceHelper.getCellReference(formulaRecord.getColumn(), formulaRecord.getRow()) + " " + formulaException.getMessage());
            return null;
        }
    }

    final int getNumRows() {
        return this.numRows;
    }

    final int getNumCols() {
        return this.numCols;
    }

    final Cell[][] getCells() {
        return this.cells;
    }

    final ArrayList getRowProperties() {
        return this.rowProperties;
    }

    final ArrayList getColumnInfosArray() {
        return this.columnInfosArray;
    }

    final ArrayList getHyperlinks() {
        return this.hyperlinks;
    }

    final ArrayList getConditionalFormats() {
        return this.conditionalFormats;
    }

    final AutoFilter getAutoFilter() {
        return this.autoFilter;
    }

    final ArrayList getCharts() {
        return this.charts;
    }

    final ArrayList getDrawings() {
        return this.drawings;
    }

    final DataValidation getDataValidation() {
        return this.dataValidation;
    }

    final Range[] getMergedCells() {
        return this.mergedCells;
    }

    final SheetSettings getSettings() {
        return this.settings;
    }

    final int[] getRowBreaks() {
        return this.rowBreaks;
    }

    final int[] getColumnBreaks() {
        return this.columnBreaks;
    }

    final WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    final PLSRecord getPLS() {
        return this.plsRecord;
    }

    final ButtonPropertySetRecord getButtonPropertySet() {
        return this.buttonPropertySet;
    }

    private void addCellComment(int n, int n2, String string, double d, double d2) {
        Cell cell = this.cells[n2][n];
        if (cell == null) {
            logger.warn("Cell at " + CellReferenceHelper.getCellReference(n, n2) + " not present - adding a blank");
            MulBlankCell mulBlankCell = new MulBlankCell(n2, n, 0, this.formattingRecords, this.sheet);
            CellFeatures cellFeatures = new CellFeatures();
            cellFeatures.setReadComment(string, d, d2);
            mulBlankCell.setCellFeatures(cellFeatures);
            this.addCell(mulBlankCell);
            return;
        }
        if (cell instanceof CellFeaturesAccessor) {
            CellFeaturesAccessor cellFeaturesAccessor = (CellFeaturesAccessor)((Object)cell);
            CellFeatures cellFeatures = cellFeaturesAccessor.getCellFeatures();
            if (cellFeatures == null) {
                cellFeatures = new CellFeatures();
                cellFeaturesAccessor.setCellFeatures(cellFeatures);
            }
            cellFeatures.setReadComment(string, d, d2);
        } else {
            logger.warn("Not able to add comment to cell type " + cell.getClass().getName() + " at " + CellReferenceHelper.getCellReference(n, n2));
        }
    }

    private void addCellValidation(int n, int n2, int n3, int n4, DataValiditySettingsRecord dataValiditySettingsRecord) {
        for (int i = n2; i <= n4; ++i) {
            for (int j = n; j <= n3; ++j) {
                CellFeatures cellFeatures;
                CellFeaturesAccessor cellFeaturesAccessor;
                Object object = null;
                if (this.cells.length > i && this.cells[i].length > j) {
                    object = this.cells[i][j];
                }
                if (object == null) {
                    logger.warn("Cell at " + CellReferenceHelper.getCellReference(j, i) + " not present - adding a blank");
                    cellFeaturesAccessor = new MulBlankCell(i, j, 0, this.formattingRecords, this.sheet);
                    cellFeatures = new CellFeatures();
                    cellFeatures.setValidationSettings(dataValiditySettingsRecord);
                    ((MulBlankCell)cellFeaturesAccessor).setCellFeatures(cellFeatures);
                    this.addCell((Cell)((Object)cellFeaturesAccessor));
                    return;
                }
                if (object instanceof CellFeaturesAccessor) {
                    cellFeaturesAccessor = (CellFeaturesAccessor)object;
                    cellFeatures = cellFeaturesAccessor.getCellFeatures();
                    if (cellFeatures == null) {
                        cellFeatures = new CellFeatures();
                        cellFeaturesAccessor.setCellFeatures(cellFeatures);
                    }
                    cellFeatures.setValidationSettings(dataValiditySettingsRecord);
                    continue;
                }
                logger.warn("Not able to add comment to cell type " + object.getClass().getName() + " at " + CellReferenceHelper.getCellReference(j, i));
            }
        }
    }

    private void handleObjectRecord(ObjRecord objRecord, MsoDrawingRecord msoDrawingRecord, HashMap hashMap) {
        if (msoDrawingRecord == null) {
            logger.warn("Object record is not associated with a drawing  record - ignoring");
            return;
        }
        try {
            if (objRecord.getType() == ObjRecord.PICTURE) {
                if (this.drawingData == null) {
                    this.drawingData = new DrawingData();
                }
                Drawing drawing = new Drawing(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.sheet);
                this.drawings.add(drawing);
                return;
            }
            if (objRecord.getType() == ObjRecord.EXCELNOTE) {
                WritableRecordData writableRecordData;
                if (this.drawingData == null) {
                    this.drawingData = new DrawingData();
                }
                Comment comment = new Comment(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.workbookSettings);
                Record record = this.excelFile.next();
                if (record.getType() == Type.MSODRAWING || record.getType() == Type.CONTINUE) {
                    writableRecordData = new MsoDrawingRecord(record);
                    comment.addMso((MsoDrawingRecord)writableRecordData);
                    record = this.excelFile.next();
                }
                Assert.verify(record.getType() == Type.TXO);
                writableRecordData = new TextObjectRecord(record);
                comment.setTextObject((TextObjectRecord)writableRecordData);
                record = this.excelFile.next();
                Assert.verify(record.getType() == Type.CONTINUE);
                ContinueRecord continueRecord = new ContinueRecord(record);
                comment.setText(continueRecord);
                record = this.excelFile.next();
                if (record.getType() == Type.CONTINUE) {
                    ContinueRecord continueRecord2 = new ContinueRecord(record);
                    comment.setFormatting(continueRecord2);
                }
                hashMap.put(new Integer(comment.getObjectId()), comment);
                return;
            }
            if (objRecord.getType() == ObjRecord.COMBOBOX) {
                if (this.drawingData == null) {
                    this.drawingData = new DrawingData();
                }
                ComboBox comboBox = new ComboBox(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.workbookSettings);
                this.drawings.add(comboBox);
                return;
            }
            if (objRecord.getType() == ObjRecord.BUTTON) {
                WritableRecordData writableRecordData;
                if (this.drawingData == null) {
                    this.drawingData = new DrawingData();
                }
                Button button = new Button(msoDrawingRecord, objRecord, this.drawingData, this.workbook.getDrawingGroup(), this.workbookSettings);
                Record record = this.excelFile.next();
                if (record.getType() == Type.MSODRAWING) {
                    writableRecordData = new MsoDrawingRecord(record);
                    button.addMso((MsoDrawingRecord)writableRecordData);
                    record = this.excelFile.next();
                }
                Assert.verify(record.getType() == Type.TXO);
                writableRecordData = new TextObjectRecord(record);
                button.setTextObject((TextObjectRecord)writableRecordData);
                record = this.excelFile.next();
                Assert.verify(record.getType() == Type.CONTINUE);
                ContinueRecord continueRecord = new ContinueRecord(record);
                button.setText(continueRecord);
                record = this.excelFile.next();
                if (record.getType() == Type.CONTINUE) {
                    ContinueRecord continueRecord3 = new ContinueRecord(record);
                    button.setFormatting(continueRecord3);
                }
                this.drawings.add(button);
                return;
            }
            if (objRecord.getType() != ObjRecord.CHART) {
                logger.warn(objRecord.getType() + " on sheet \"" + this.sheet.getName() + "\" not supported - omitting");
                if (this.drawingData == null) {
                    this.drawingData = new DrawingData();
                }
                this.drawingData.addData(msoDrawingRecord.getData());
                if (this.workbook.getDrawingGroup() != null) {
                    this.workbook.getDrawingGroup().setDrawingsOmitted(msoDrawingRecord, objRecord);
                }
                return;
            }
        }
        catch (DrawingDataException drawingDataException) {
            logger.warn(drawingDataException.getMessage() + "...disabling drawings for the remainder of the workbook");
            this.workbookSettings.setDrawingsDisabled(true);
        }
    }

    DrawingData getDrawingData() {
        return this.drawingData;
    }

    private void handleOutOfBoundsCells() {
        Cell[] cellArray;
        int n = this.numRows;
        int n2 = this.numCols;
        Object object = this.outOfBoundsCells.iterator();
        while (object.hasNext()) {
            cellArray = (Cell[])object.next();
            n = Math.max(n, cellArray.getRow() + 1);
            n2 = Math.max(n2, cellArray.getColumn() + 1);
        }
        logger.warn("Some cells exceeded the specified bounds.  Resizing sheet dimensions from " + this.numCols + "x" + this.numRows + " to " + n2 + "x" + n);
        if (n2 > this.numCols) {
            for (int i = 0; i < this.numRows; ++i) {
                cellArray = new Cell[n2];
                Cell[] cellArray2 = this.cells[i];
                System.arraycopy(cellArray2, 0, cellArray, 0, cellArray2.length);
                this.cells[i] = cellArray;
            }
        }
        if (n > this.numRows) {
            object = new Cell[n][];
            System.arraycopy(this.cells, 0, object, 0, this.cells.length);
            this.cells = object;
            for (int i = this.numRows; i < n; ++i) {
                object[i] = new Cell[n2];
            }
        }
        this.numRows = n;
        this.numCols = n2;
        object = this.outOfBoundsCells.iterator();
        while (object.hasNext()) {
            Cell cell = (Cell)object.next();
            this.addCell(cell);
        }
        this.outOfBoundsCells.clear();
    }

    public int getMaxColumnOutlineLevel() {
        return this.maxColumnOutlineLevel;
    }

    public int getMaxRowOutlineLevel() {
        return this.maxRowOutlineLevel;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

