/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DateFormat;
import java.util.Date;
import jxl.CellType;
import jxl.DateCell;
import jxl.DateFormulaCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SheetImpl;

public class SharedDateFormulaRecord
extends BaseSharedFormulaRecord
implements DateCell,
FormulaData,
DateFormulaCell {
    private DateRecord dateRecord;
    private double value;

    public SharedDateFormulaRecord(SharedNumberFormulaRecord sharedNumberFormulaRecord, FormattingRecords formattingRecords, boolean bl, SheetImpl sheetImpl, int n) {
        super(sharedNumberFormulaRecord.getRecord(), formattingRecords, sharedNumberFormulaRecord.getExternalSheet(), sharedNumberFormulaRecord.getNameTable(), sheetImpl, n);
        this.dateRecord = new DateRecord(sharedNumberFormulaRecord, sharedNumberFormulaRecord.getXFIndex(), formattingRecords, bl, sheetImpl);
        this.value = sharedNumberFormulaRecord.getValue();
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.dateRecord.getContents();
    }

    public CellType getType() {
        return CellType.DATE_FORMULA;
    }

    public byte[] getFormulaData() throws FormulaException {
        if (!this.getSheet().getWorkbookBof().isBiff8()) {
            throw new FormulaException(FormulaException.BIFF8_SUPPORTED);
        }
        FormulaParser formulaParser = new FormulaParser(this.getTokens(), this, this.getExternalSheet(), this.getNameTable(), this.getSheet().getWorkbook().getSettings());
        formulaParser.parse();
        byte[] byArray = formulaParser.getBytes();
        byte[] byArray2 = new byte[byArray.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), byArray2, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), byArray2, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), byArray2, 4);
        DoubleHelper.getIEEEBytes(this.value, byArray2, 6);
        System.arraycopy(byArray, 0, byArray2, 22, byArray.length);
        IntegerHelper.getTwoBytes(byArray.length, byArray2, 20);
        byte[] byArray3 = new byte[byArray2.length - 6];
        System.arraycopy(byArray2, 6, byArray3, 0, byArray2.length - 6);
        return byArray3;
    }

    public Date getDate() {
        return this.dateRecord.getDate();
    }

    public boolean isTime() {
        return this.dateRecord.isTime();
    }

    public DateFormat getDateFormat() {
        return this.dateRecord.getDateFormat();
    }
}

