/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import jxl.CellFeatures;
import jxl.CellType;
import jxl.NumberCell;
import jxl.biff.FormattingRecords;
import jxl.format.CellFormat;
import jxl.read.biff.CellFeaturesAccessor;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SheetImpl;

class NumberValue
implements NumberCell,
CellFeaturesAccessor {
    private int row;
    private int column;
    private double value;
    private NumberFormat format;
    private CellFormat cellFormat;
    private CellFeatures features;
    private int xfIndex;
    private FormattingRecords formattingRecords;
    private boolean initialized;
    private SheetImpl sheet;
    private static DecimalFormat defaultFormat = new DecimalFormat("#.###");

    public NumberValue(int n, int n2, double d, int n3, FormattingRecords formattingRecords, SheetImpl sheetImpl) {
        this.row = n;
        this.column = n2;
        this.value = d;
        this.format = defaultFormat;
        this.xfIndex = n3;
        this.formattingRecords = formattingRecords;
        this.sheet = sheetImpl;
        this.initialized = false;
    }

    final void setNumberFormat(NumberFormat numberFormat) {
        if (numberFormat != null) {
            this.format = numberFormat;
        }
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.format.format(this.value);
    }

    public CellType getType() {
        return CellType.NUMBER;
    }

    public CellFormat getCellFormat() {
        if (!this.initialized) {
            this.cellFormat = this.formattingRecords.getXFRecord(this.xfIndex);
            this.initialized = true;
        }
        return this.cellFormat;
    }

    public boolean isHidden() {
        ColumnInfoRecord columnInfoRecord = this.sheet.getColumnInfo(this.column);
        if (columnInfoRecord != null && columnInfoRecord.getWidth() == 0) {
            return true;
        }
        RowRecord rowRecord = this.sheet.getRowInfo(this.row);
        return rowRecord != null && (rowRecord.getRowHeight() == 0 || rowRecord.isCollapsed());
    }

    public NumberFormat getNumberFormat() {
        return this.format;
    }

    public CellFeatures getCellFeatures() {
        return this.features;
    }

    public void setCellFeatures(CellFeatures cellFeatures) {
        this.features = cellFeatures;
    }
}

