/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.RecordData;
import jxl.read.biff.Record;

class MulRKRecord
extends RecordData {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$MulRKRecord == null ? (class$jxl$read$biff$MulRKRecord = MulRKRecord.class$("jxl.read.biff.MulRKRecord")) : class$jxl$read$biff$MulRKRecord);
    private int row;
    private int colFirst;
    private int colLast;
    private int numrks;
    private int[] rknumbers;
    private int[] xfIndices;
    static /* synthetic */ Class class$jxl$read$biff$MulRKRecord;

    public MulRKRecord(Record record) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        int n = this.getRecord().getLength();
        this.row = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.colFirst = IntegerHelper.getInt(byArray[2], byArray[3]);
        this.colLast = IntegerHelper.getInt(byArray[n - 2], byArray[n - 1]);
        this.numrks = this.colLast - this.colFirst + 1;
        this.rknumbers = new int[this.numrks];
        this.xfIndices = new int[this.numrks];
        this.readRks(byArray);
    }

    private void readRks(byte[] byArray) {
        int n = 4;
        for (int i = 0; i < this.numrks; ++i) {
            int n2;
            this.xfIndices[i] = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
            this.rknumbers[i] = n2 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3], byArray[n + 4], byArray[n + 5]);
            n += 6;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getFirstColumn() {
        return this.colFirst;
    }

    public int getNumberOfColumns() {
        return this.numrks;
    }

    public int getRKNumber(int n) {
        return this.rknumbers[n];
    }

    public int getXFIndex(int n) {
        return this.xfIndices[n];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

