/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Workbook;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.EscherDisplay;
import jxl.read.biff.SheetImpl;

public class Escher {
    public Escher(Workbook workbook, OutputStream outputStream, String string) throws IOException {
        if (string == null || !string.equals("UnicodeBig")) {
            string = "UTF8";
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                SheetImpl sheetImpl = (SheetImpl)workbook.getSheet(i);
                bufferedWriter.write(sheetImpl.getName());
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                DrawingData drawingData = sheetImpl.getDrawingData();
                if (drawingData != null) {
                    EscherDisplay escherDisplay = new EscherDisplay(drawingData, bufferedWriter);
                    escherDisplay.display();
                }
                bufferedWriter.newLine();
                bufferedWriter.newLine();
                bufferedWriter.flush();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }
}

