/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import common.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jxl.Cell;
import jxl.Range;
import jxl.Workbook;
import jxl.demo.BiffDump;
import jxl.demo.CSV;
import jxl.demo.Escher;
import jxl.demo.EscherDrawingGroup;
import jxl.demo.Features;
import jxl.demo.Formulas;
import jxl.demo.PropertySetsReader;
import jxl.demo.ReadWrite;
import jxl.demo.Write;
import jxl.demo.WriteAccess;
import jxl.demo.XML;

public class Demo {
    private static final int CSVFormat = 13;
    private static final int XMLFormat = 14;
    private static Logger logger = Logger.getLogger(class$jxl$demo$Demo == null ? (class$jxl$demo$Demo = Demo.class$("jxl.demo.Demo")) : class$jxl$demo$Demo);
    static /* synthetic */ Class class$jxl$demo$Demo;

    private static void displayHelp() {
        System.err.println("Command format:  Demo [-unicode] [-csv] [-hide] excelfile");
        System.err.println("                 Demo -xml [-format]  excelfile");
        System.err.println("                 Demo -readwrite|-rw excelfile output");
        System.err.println("                 Demo -biffdump | -bd | -wa | -write | -formulas | -features | -escher | -escherdg excelfile");
        System.err.println("                 Demo -ps excelfile [property] [output]");
        System.err.println("                 Demo -version | -logtest | -h | -help");
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (stringArray[0].equals("-help") || stringArray[0].equals("-h")) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (stringArray[0].equals("-version")) {
            System.out.println("v" + Workbook.getVersion());
            System.exit(0);
        }
        if (stringArray[0].equals("-logtest")) {
            logger.debug("A sample \"debug\" message");
            logger.info("A sample \"info\" message");
            logger.warn("A sample \"warning\" message");
            logger.error("A sample \"error\" message");
            logger.fatal("A sample \"fatal\" message");
            System.exit(0);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        String string = stringArray[0];
        String string2 = null;
        String string3 = null;
        if (stringArray[0].equals("-write")) {
            bl = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-formulas")) {
            bl3 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-features")) {
            bl7 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-escher")) {
            bl8 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-escherdg")) {
            bl9 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-biffdump") || stringArray[0].equals("-bd")) {
            bl4 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-wa")) {
            bl5 = true;
            string = stringArray[1];
        } else if (stringArray[0].equals("-ps")) {
            bl6 = true;
            string = stringArray[1];
            if (stringArray.length > 2) {
                string3 = stringArray[2];
            }
            if (stringArray.length == 4) {
                string2 = stringArray[3];
            }
        } else if (stringArray[0].equals("-readwrite") || stringArray[0].equals("-rw")) {
            bl2 = true;
            string = stringArray[1];
            string2 = stringArray[2];
        } else {
            string = stringArray[stringArray.length - 1];
        }
        String string4 = "UTF8";
        int n = 13;
        boolean bl10 = false;
        boolean bl11 = false;
        if (!(bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || bl8 || bl9)) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                if (stringArray[i].equals("-unicode")) {
                    string4 = "UnicodeBig";
                    continue;
                }
                if (stringArray[i].equals("-xml")) {
                    n = 14;
                    continue;
                }
                if (stringArray[i].equals("-csv")) {
                    n = 13;
                    continue;
                }
                if (stringArray[i].equals("-format")) {
                    bl10 = true;
                    continue;
                }
                if (stringArray[i].equals("-hide")) {
                    bl11 = true;
                    continue;
                }
                System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
                System.exit(1);
            }
        }
        try {
            if (bl) {
                Write write = new Write(string);
                write.write();
            } else if (bl2) {
                ReadWrite readWrite = new ReadWrite(string, string2);
                readWrite.readWrite();
            } else if (bl3) {
                Workbook workbook = Workbook.getWorkbook(new File(string));
                Formulas formulas = new Formulas(workbook, System.out, string4);
                workbook.close();
            } else if (bl7) {
                Workbook workbook = Workbook.getWorkbook(new File(string));
                Features features = new Features(workbook, System.out, string4);
                workbook.close();
            } else if (bl8) {
                Workbook workbook = Workbook.getWorkbook(new File(string));
                Escher escher = new Escher(workbook, System.out, string4);
                workbook.close();
            } else if (bl9) {
                Workbook workbook = Workbook.getWorkbook(new File(string));
                EscherDrawingGroup escherDrawingGroup = new EscherDrawingGroup(workbook, System.out, string4);
                workbook.close();
            } else if (bl4) {
                BiffDump biffDump = new BiffDump(new File(string), System.out);
            } else if (bl5) {
                WriteAccess writeAccess = new WriteAccess(new File(string));
            } else if (bl6) {
                OutputStream outputStream = System.out;
                if (string2 != null) {
                    outputStream = new FileOutputStream(string2);
                }
                PropertySetsReader propertySetsReader = new PropertySetsReader(new File(string), string3, outputStream);
            } else {
                Workbook workbook = Workbook.getWorkbook(new File(string));
                if (n == 13) {
                    CSV cSV = new CSV(workbook, System.out, string4, bl11);
                } else if (n == 14) {
                    XML xML = new XML(workbook, System.out, string4, bl10);
                }
                workbook.close();
            }
        }
        catch (Throwable throwable) {
            System.out.println(throwable.toString());
            throwable.printStackTrace();
        }
    }

    private static void findTest(Workbook workbook) {
        int n;
        Range[] rangeArray;
        logger.info("Find test");
        Cell cell = workbook.findCellByName("named1");
        if (cell != null) {
            logger.info("named1 contents:  " + cell.getContents());
        }
        if ((cell = workbook.findCellByName("named2")) != null) {
            logger.info("named2 contents:  " + cell.getContents());
        }
        if ((cell = workbook.findCellByName("namedrange")) != null) {
            logger.info("named2 contents:  " + cell.getContents());
        }
        if ((rangeArray = workbook.findByName("namedrange")) != null) {
            cell = rangeArray[0].getTopLeft();
            logger.info("namedrange top left contents:  " + cell.getContents());
            cell = rangeArray[0].getBottomRight();
            logger.info("namedrange bottom right contents:  " + cell.getContents());
        }
        if ((rangeArray = workbook.findByName("nonadjacentrange")) != null) {
            for (n = 0; n < rangeArray.length; ++n) {
                cell = rangeArray[n].getTopLeft();
                logger.info("nonadjacent top left contents:  " + cell.getContents());
                cell = rangeArray[n].getBottomRight();
                logger.info("nonadjacent bottom right contents:  " + cell.getContents());
            }
        }
        if ((rangeArray = workbook.findByName("horizontalnonadjacentrange")) != null) {
            for (n = 0; n < rangeArray.length; ++n) {
                cell = rangeArray[n].getTopLeft();
                logger.info("horizontalnonadjacent top left contents:  " + cell.getContents());
                cell = rangeArray[n].getBottomRight();
                logger.info("horizontalnonadjacent bottom right contents:  " + cell.getContents());
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

