/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;

public class CSV {
    public CSV(Workbook workbook, OutputStream outputStream, String string, boolean bl) throws IOException {
        if (string == null || !string.equals("UnicodeBig")) {
            string = "UTF8";
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
                Sheet sheet = workbook.getSheet(i);
                if (bl && sheet.getSettings().isHidden()) continue;
                bufferedWriter.write("*** " + sheet.getName() + " ****");
                bufferedWriter.newLine();
                Cell[] cellArray = null;
                for (int j = 0; j < sheet.getRows(); ++j) {
                    cellArray = sheet.getRow(j);
                    if (cellArray.length > 0) {
                        if (!bl || !cellArray[0].isHidden()) {
                            bufferedWriter.write(cellArray[0].getContents());
                        }
                        for (int k = 1; k < cellArray.length; ++k) {
                            bufferedWriter.write(44);
                            if (bl && cellArray[k].isHidden()) continue;
                            bufferedWriter.write(cellArray[k].getContents());
                        }
                    }
                    bufferedWriter.newLine();
                }
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.toString());
        }
    }
}

