/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Area;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.Operator;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class VariableArgFunction
extends Operator
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$VariableArgFunction == null ? (class$jxl$biff$formula$VariableArgFunction = VariableArgFunction.class$("jxl.biff.formula.VariableArgFunction")) : class$jxl$biff$formula$VariableArgFunction);
    private Function function;
    private int arguments;
    private boolean readFromSheet;
    private WorkbookSettings settings;
    static /* synthetic */ Class class$jxl$biff$formula$VariableArgFunction;

    public VariableArgFunction(WorkbookSettings workbookSettings) {
        this.readFromSheet = true;
        this.settings = workbookSettings;
    }

    public VariableArgFunction(Function function, int n, WorkbookSettings workbookSettings) {
        this.function = function;
        this.arguments = n;
        this.readFromSheet = false;
        this.settings = workbookSettings;
    }

    public int read(byte[] byArray, int n) throws FormulaException {
        this.arguments = byArray[n];
        int n2 = IntegerHelper.getInt(byArray[n + 1], byArray[n + 2]);
        this.function = Function.getFunction(n2);
        if (this.function == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.UNRECOGNIZED_FUNCTION, n2);
        }
        return 3;
    }

    public void getOperands(Stack stack) {
        int n;
        ParseItem[] parseItemArray = new ParseItem[this.arguments];
        for (n = this.arguments - 1; n >= 0; --n) {
            ParseItem parseItem;
            parseItemArray[n] = parseItem = (ParseItem)stack.pop();
        }
        for (n = 0; n < this.arguments; ++n) {
            this.add(parseItemArray[n]);
        }
    }

    public void getString(StringBuffer stringBuffer) {
        stringBuffer.append(this.function.getName(this.settings));
        stringBuffer.append('(');
        if (this.arguments > 0) {
            ParseItem[] parseItemArray = this.getOperands();
            if (this.readFromSheet) {
                parseItemArray[0].getString(stringBuffer);
                for (int i = 1; i < this.arguments; ++i) {
                    stringBuffer.append(',');
                    parseItemArray[i].getString(stringBuffer);
                }
            } else {
                parseItemArray[this.arguments - 1].getString(stringBuffer);
                for (int i = this.arguments - 2; i >= 0; --i) {
                    stringBuffer.append(',');
                    parseItemArray[i].getString(stringBuffer);
                }
            }
        }
        stringBuffer.append(')');
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].adjustRelativeCellReferences(n, n2);
        }
    }

    void columnInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnInserted(n, n2, bl);
        }
    }

    void columnRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].columnRemoved(n, n2, bl);
        }
    }

    void rowInserted(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowInserted(n, n2, bl);
        }
    }

    void rowRemoved(int n, int n2, boolean bl) {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].rowRemoved(n, n2, bl);
        }
    }

    void handleImportedCellReferences() {
        ParseItem[] parseItemArray = this.getOperands();
        for (int i = 0; i < parseItemArray.length; ++i) {
            parseItemArray[i].handleImportedCellReferences();
        }
    }

    Function getFunction() {
        return this.function;
    }

    byte[] getBytes() {
        this.handleSpecialCases();
        ParseItem[] parseItemArray = this.getOperands();
        byte[] byArray = new byte[]{};
        for (int i = 0; i < parseItemArray.length; ++i) {
            byte[] byArray2 = parseItemArray[i].getBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        byte[] byArray4 = new byte[byArray.length + 4];
        System.arraycopy(byArray, 0, byArray4, 0, byArray.length);
        byArray4[byArray.length] = !this.useAlternateCode() ? Token.FUNCTIONVARARG.getCode() : Token.FUNCTIONVARARG.getCode2();
        byArray4[byArray.length + 1] = (byte)this.arguments;
        IntegerHelper.getTwoBytes(this.function.getCode(), byArray4, byArray.length + 2);
        return byArray4;
    }

    int getPrecedence() {
        return 3;
    }

    private void handleSpecialCases() {
        if (this.function == Function.SUMPRODUCT) {
            ParseItem[] parseItemArray = this.getOperands();
            for (int i = parseItemArray.length - 1; i >= 0; --i) {
                if (!(parseItemArray[i] instanceof Area)) continue;
                parseItemArray[i].setAlternateCode();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

