/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import jxl.WorkbookSettings;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.ArgumentSeparator;
import jxl.biff.formula.Attribute;
import jxl.biff.formula.BuiltInFunction;
import jxl.biff.formula.CloseParentheses;
import jxl.biff.formula.DoubleValue;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.IntegerValue;
import jxl.biff.formula.OpenParentheses;
import jxl.biff.formula.Operand;
import jxl.biff.formula.Operator;
import jxl.biff.formula.Parenthesis;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.Parser;
import jxl.biff.formula.StringFunction;
import jxl.biff.formula.StringOperator;
import jxl.biff.formula.Token;
import jxl.biff.formula.VariableArgFunction;
import jxl.biff.formula.Yylex;

class StringFormulaParser
implements Parser {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$StringFormulaParser == null ? (class$jxl$biff$formula$StringFormulaParser = StringFormulaParser.class$("jxl.biff.formula.StringFormulaParser")) : class$jxl$biff$formula$StringFormulaParser);
    private String formula;
    private String parsedFormula;
    private ParseItem root;
    private Stack arguments;
    private WorkbookSettings settings;
    private ExternalSheet externalSheet;
    private WorkbookMethods nameTable;
    static /* synthetic */ Class class$jxl$biff$formula$StringFormulaParser;

    public StringFormulaParser(String string, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        this.formula = string;
        this.settings = workbookSettings;
        this.externalSheet = externalSheet;
        this.nameTable = workbookMethods;
    }

    public void parse() throws FormulaException {
        ArrayList arrayList = this.getTokens();
        Iterator iterator = arrayList.iterator();
        this.root = this.parseCurrent(iterator);
    }

    private ParseItem parseCurrent(Iterator iterator) throws FormulaException {
        ParseItem parseItem;
        Stack<ParseItem> stack = new Stack<ParseItem>();
        Stack<ParseItem> stack2 = new Stack<ParseItem>();
        Stack<ParseItem> stack3 = null;
        boolean bl = false;
        ParseItem parseItem2 = null;
        while (iterator.hasNext() && !bl) {
            Operator operator;
            ParseItem parseItem3;
            parseItem = (ParseItem)iterator.next();
            if (parseItem instanceof Operand) {
                this.handleOperand((Operand)parseItem, stack);
            } else if (parseItem instanceof StringFunction) {
                this.handleFunction((StringFunction)parseItem, iterator, stack);
            } else if (parseItem instanceof Operator) {
                parseItem3 = (Operator)parseItem;
                if (parseItem3 instanceof StringOperator) {
                    operator = (StringOperator)parseItem3;
                    parseItem3 = stack.isEmpty() || parseItem2 instanceof Operator ? ((StringOperator)operator).getUnaryOperator() : ((StringOperator)operator).getBinaryOperator();
                }
                if (stack2.empty()) {
                    stack2.push(parseItem3);
                } else {
                    operator = (Operator)stack2.peek();
                    if (((Operator)parseItem3).getPrecedence() <= operator.getPrecedence()) {
                        stack2.push(parseItem3);
                    } else {
                        stack2.pop();
                        operator.getOperands(stack);
                        stack.push(operator);
                        stack2.push(parseItem3);
                    }
                }
            } else if (parseItem instanceof ArgumentSeparator) {
                while (!stack2.isEmpty()) {
                    parseItem3 = (Operator)stack2.pop();
                    ((Operator)parseItem3).getOperands(stack);
                    stack.push(parseItem3);
                }
                if (stack3 == null) {
                    stack3 = new Stack<ParseItem>();
                }
                stack3.push((ParseItem)stack.pop());
                stack.clear();
            } else if (parseItem instanceof OpenParentheses) {
                parseItem3 = this.parseCurrent(iterator);
                operator = new Parenthesis();
                parseItem3.setParent(operator);
                operator.add(parseItem3);
                stack.push(operator);
            } else if (parseItem instanceof CloseParentheses) {
                bl = true;
            }
            parseItem2 = parseItem;
        }
        while (!stack2.isEmpty()) {
            parseItem = (Operator)stack2.pop();
            ((Operator)parseItem).getOperands(stack);
            stack.push(parseItem);
        }
        ParseItem parseItem4 = parseItem = !stack.empty() ? (ParseItem)stack.pop() : null;
        if (stack3 != null && parseItem != null) {
            stack3.push(parseItem);
        }
        this.arguments = stack3;
        if (!stack.empty() || !stack2.empty()) {
            logger.warn("Formula " + this.formula + " has a non-empty parse stack");
        }
        return parseItem;
    }

    private ArrayList getTokens() throws FormulaException {
        ArrayList<ParseItem> arrayList = new ArrayList<ParseItem>();
        StringReader stringReader = new StringReader(this.formula);
        Yylex yylex = new Yylex(stringReader);
        yylex.setExternalSheet(this.externalSheet);
        yylex.setNameTable(this.nameTable);
        try {
            ParseItem parseItem = yylex.yylex();
            while (parseItem != null) {
                arrayList.add(parseItem);
                parseItem = yylex.yylex();
            }
        }
        catch (IOException iOException) {
            logger.warn(iOException.toString());
        }
        catch (Error error) {
            throw new FormulaException(FormulaException.LEXICAL_ERROR, this.formula + " at char  " + yylex.getPos());
        }
        return arrayList;
    }

    public String getFormula() {
        if (this.parsedFormula == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.root.getString(stringBuffer);
            this.parsedFormula = stringBuffer.toString();
        }
        return this.parsedFormula;
    }

    public byte[] getBytes() {
        byte[] byArray = this.root.getBytes();
        if (this.root.isVolatile()) {
            byte[] byArray2 = new byte[byArray.length + 4];
            System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
            byArray2[0] = Token.ATTRIBUTE.getCode();
            byArray2[1] = 1;
            byArray = byArray2;
        }
        return byArray;
    }

    private void handleFunction(StringFunction stringFunction, Iterator iterator, Stack stack) throws FormulaException {
        ParseItem parseItem = this.parseCurrent(iterator);
        if (stringFunction.getFunction(this.settings) == Function.UNKNOWN) {
            throw new FormulaException(FormulaException.UNRECOGNIZED_FUNCTION);
        }
        if (stringFunction.getFunction(this.settings) == Function.SUM && this.arguments == null) {
            Attribute attribute = new Attribute(stringFunction, this.settings);
            attribute.add(parseItem);
            stack.push(attribute);
            return;
        }
        if (stringFunction.getFunction(this.settings) == Function.IF) {
            Attribute attribute = new Attribute(stringFunction, this.settings);
            VariableArgFunction variableArgFunction = new VariableArgFunction(this.settings);
            int n = this.arguments.size();
            for (int i = 0; i < n; ++i) {
                ParseItem parseItem2 = (ParseItem)this.arguments.get(i);
                variableArgFunction.add(parseItem2);
            }
            attribute.setIfConditions(variableArgFunction);
            stack.push(attribute);
            return;
        }
        if (stringFunction.getFunction(this.settings).getNumArgs() == 255) {
            if (this.arguments == null) {
                int n = parseItem != null ? 1 : 0;
                VariableArgFunction variableArgFunction = new VariableArgFunction(stringFunction.getFunction(this.settings), n, this.settings);
                if (parseItem != null) {
                    variableArgFunction.add(parseItem);
                }
                stack.push(variableArgFunction);
            } else {
                int n;
                int n2 = this.arguments.size();
                VariableArgFunction variableArgFunction = new VariableArgFunction(stringFunction.getFunction(this.settings), n2, this.settings);
                ParseItem[] parseItemArray = new ParseItem[n2];
                for (n = 0; n < n2; ++n) {
                    ParseItem parseItem3;
                    parseItemArray[n2 - n - 1] = parseItem3 = (ParseItem)this.arguments.pop();
                }
                for (n = 0; n < parseItemArray.length; ++n) {
                    variableArgFunction.add(parseItemArray[n]);
                }
                stack.push(variableArgFunction);
                this.arguments.clear();
                this.arguments = null;
            }
            return;
        }
        BuiltInFunction builtInFunction = new BuiltInFunction(stringFunction.getFunction(this.settings), this.settings);
        int n = stringFunction.getFunction(this.settings).getNumArgs();
        if (n == 1) {
            builtInFunction.add(parseItem);
        } else {
            if (this.arguments == null && n != 0 || this.arguments != null && n != this.arguments.size()) {
                throw new FormulaException(FormulaException.INCORRECT_ARGUMENTS);
            }
            for (int i = 0; i < n; ++i) {
                ParseItem parseItem4 = (ParseItem)this.arguments.get(i);
                builtInFunction.add(parseItem4);
            }
        }
        stack.push(builtInFunction);
    }

    public void adjustRelativeCellReferences(int n, int n2) {
        this.root.adjustRelativeCellReferences(n, n2);
    }

    public void columnInserted(int n, int n2, boolean bl) {
        this.root.columnInserted(n, n2, bl);
    }

    public void columnRemoved(int n, int n2, boolean bl) {
        this.root.columnRemoved(n, n2, bl);
    }

    public void rowInserted(int n, int n2, boolean bl) {
        this.root.rowInserted(n, n2, bl);
    }

    public void rowRemoved(int n, int n2, boolean bl) {
        this.root.rowRemoved(n, n2, bl);
    }

    private void handleOperand(Operand operand, Stack stack) {
        if (!(operand instanceof IntegerValue)) {
            stack.push(operand);
            return;
        }
        if (operand instanceof IntegerValue) {
            IntegerValue integerValue = (IntegerValue)operand;
            if (!integerValue.isOutOfRange()) {
                stack.push(integerValue);
            } else {
                DoubleValue doubleValue = new DoubleValue(integerValue.getValue());
                stack.push(doubleValue);
            }
        }
    }

    public boolean handleImportedCellReferences() {
        this.root.handleImportedCellReferences();
        return this.root.isValid();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

