/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Logger;
import jxl.Cell;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class SharedFormulaCellReference
extends Operand
implements ParsedThing {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$SharedFormulaCellReference == null ? (class$jxl$biff$formula$SharedFormulaCellReference = SharedFormulaCellReference.class$("jxl.biff.formula.SharedFormulaCellReference")) : class$jxl$biff$formula$SharedFormulaCellReference);
    private boolean columnRelative;
    private boolean rowRelative;
    private int column;
    private int row;
    private Cell relativeTo;
    static /* synthetic */ Class class$jxl$biff$formula$SharedFormulaCellReference;

    public SharedFormulaCellReference(Cell cell) {
        this.relativeTo = cell;
    }

    public int read(byte[] byArray, int n) {
        this.row = IntegerHelper.getShort(byArray[n], byArray[n + 1]);
        int n2 = IntegerHelper.getInt(byArray[n + 2], byArray[n + 3]);
        this.column = (byte)(n2 & 0xFF);
        this.columnRelative = (n2 & 0x4000) != 0;
        boolean bl = this.rowRelative = (n2 & 0x8000) != 0;
        if (this.columnRelative && this.relativeTo != null) {
            this.column = this.relativeTo.getColumn() + this.column;
        }
        if (this.rowRelative && this.relativeTo != null) {
            this.row = this.relativeTo.getRow() + this.row;
        }
        return 4;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public void getString(StringBuffer stringBuffer) {
        CellReferenceHelper.getCellReference(this.column, this.row, stringBuffer);
    }

    byte[] getBytes() {
        byte[] byArray = new byte[5];
        byArray[0] = Token.REF.getCode();
        IntegerHelper.getTwoBytes(this.row, byArray, 1);
        int n = this.column;
        if (this.columnRelative) {
            n |= 0x4000;
        }
        if (this.rowRelative) {
            n |= 0x8000;
        }
        IntegerHelper.getTwoBytes(n, byArray, 3);
        return byArray;
    }

    void handleImportedCellReferences() {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

