/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import jxl.biff.IntegerHelper;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;

class NameRange
extends Operand
implements ParsedThing {
    private WorkbookMethods nameTable;
    private String name;
    private int index;

    public NameRange(WorkbookMethods workbookMethods) {
        this.nameTable = workbookMethods;
        Assert.verify(this.nameTable != null);
    }

    public NameRange(String string, WorkbookMethods workbookMethods) throws FormulaException {
        this.name = string;
        this.nameTable = workbookMethods;
        this.index = this.nameTable.getNameIndex(this.name);
        if (this.index < 0) {
            throw new FormulaException(FormulaException.CELL_NAME_NOT_FOUND, this.name);
        }
        ++this.index;
    }

    public int read(byte[] byArray, int n) {
        this.index = IntegerHelper.getInt(byArray[n], byArray[n + 1]);
        this.name = this.nameTable.getName(this.index - 1);
        return 4;
    }

    byte[] getBytes() {
        byte[] byArray = new byte[5];
        byArray[0] = Token.NAMED_RANGE.getCode();
        IntegerHelper.getTwoBytes(this.index, byArray, 1);
        return byArray;
    }

    public void getString(StringBuffer stringBuffer) {
        stringBuffer.append(this.name);
    }

    void handleImportedCellReferences() {
        this.setInvalid();
    }
}

