/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

public class FormulaErrorCode {
    private int errorCode;
    private String description;
    private static FormulaErrorCode[] codes = new FormulaErrorCode[0];
    public static final FormulaErrorCode UNKNOWN = new FormulaErrorCode(255, "?");
    public static final FormulaErrorCode NULL = new FormulaErrorCode(0, "#NULL!");
    public static final FormulaErrorCode DIV0 = new FormulaErrorCode(7, "#DIV/0!");
    public static final FormulaErrorCode VALUE = new FormulaErrorCode(15, "#VALUE!");
    public static final FormulaErrorCode REF = new FormulaErrorCode(23, "#REF!");
    public static final FormulaErrorCode NAME = new FormulaErrorCode(29, "#NAME?");
    public static final FormulaErrorCode NUM = new FormulaErrorCode(36, "#NUM!");
    public static final FormulaErrorCode NA = new FormulaErrorCode(42, "#N/A!");

    FormulaErrorCode(int n, String string) {
        this.errorCode = n;
        this.description = string;
        FormulaErrorCode[] formulaErrorCodeArray = new FormulaErrorCode[codes.length + 1];
        System.arraycopy(codes, 0, formulaErrorCodeArray, 0, codes.length);
        formulaErrorCodeArray[FormulaErrorCode.codes.length] = this;
        codes = formulaErrorCodeArray;
    }

    public int getCode() {
        return this.errorCode;
    }

    public String getDescription() {
        return this.description;
    }

    public static FormulaErrorCode getErrorCode(int n) {
        boolean bl = false;
        FormulaErrorCode formulaErrorCode = UNKNOWN;
        for (int i = 0; i < codes.length && !bl; ++i) {
            if (FormulaErrorCode.codes[i].errorCode != n) continue;
            bl = true;
            formulaErrorCode = codes[i];
        }
        return formulaErrorCode;
    }

    public static FormulaErrorCode getErrorCode(String string) {
        boolean bl = false;
        FormulaErrorCode formulaErrorCode = UNKNOWN;
        if (string == null || string.length() == 0) {
            return formulaErrorCode;
        }
        for (int i = 0; i < codes.length && !bl; ++i) {
            if (!FormulaErrorCode.codes[i].description.equals(string)) continue;
            bl = true;
            formulaErrorCode = codes[i];
        }
        return formulaErrorCode;
    }
}

