/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.drawing.BStoreContainer;
import jxl.biff.drawing.BlipStoreEntry;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientData;
import jxl.biff.drawing.ClientTextBox;
import jxl.biff.drawing.Dg;
import jxl.biff.drawing.Dgg;
import jxl.biff.drawing.EscherAtom;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.biff.drawing.Spgr;
import jxl.biff.drawing.SpgrContainer;
import jxl.biff.drawing.SplitMenuColors;

class EscherContainer
extends EscherRecord {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$EscherContainer == null ? (class$jxl$biff$drawing$EscherContainer = EscherContainer.class$("jxl.biff.drawing.EscherContainer")) : class$jxl$biff$drawing$EscherContainer);
    private boolean initialized;
    private ArrayList children;
    static /* synthetic */ Class class$jxl$biff$drawing$EscherContainer;

    public EscherContainer(EscherRecordData escherRecordData) {
        super(escherRecordData);
        this.initialized = false;
        this.children = new ArrayList();
    }

    protected EscherContainer(EscherRecordType escherRecordType) {
        super(escherRecordType);
        this.setContainer(true);
        this.children = new ArrayList();
    }

    public EscherRecord[] getChildren() {
        if (!this.initialized) {
            this.initialize();
        }
        EscherRecord[] escherRecordArray = this.children.toArray(new EscherRecord[this.children.size()]);
        return escherRecordArray;
    }

    public void add(EscherRecord escherRecord) {
        this.children.add(escherRecord);
    }

    public void remove(EscherRecord escherRecord) {
        boolean bl = this.children.remove(escherRecord);
    }

    private void initialize() {
        int n = Math.min(this.getPos() + this.getLength(), this.getStreamLength());
        EscherRecord escherRecord = null;
        for (int i = this.getPos() + 8; i < n; i += escherRecord.getLength()) {
            EscherRecordData escherRecordData = new EscherRecordData(this.getEscherStream(), i);
            EscherRecordType escherRecordType = escherRecordData.getType();
            escherRecord = escherRecordType == EscherRecordType.DGG ? new Dgg(escherRecordData) : (escherRecordType == EscherRecordType.DG ? new Dg(escherRecordData) : (escherRecordType == EscherRecordType.BSTORE_CONTAINER ? new BStoreContainer(escherRecordData) : (escherRecordType == EscherRecordType.SPGR_CONTAINER ? new SpgrContainer(escherRecordData) : (escherRecordType == EscherRecordType.SP_CONTAINER ? new SpContainer(escherRecordData) : (escherRecordType == EscherRecordType.SPGR ? new Spgr(escherRecordData) : (escherRecordType == EscherRecordType.SP ? new Sp(escherRecordData) : (escherRecordType == EscherRecordType.CLIENT_ANCHOR ? new ClientAnchor(escherRecordData) : (escherRecordType == EscherRecordType.CLIENT_DATA ? new ClientData(escherRecordData) : (escherRecordType == EscherRecordType.BSE ? new BlipStoreEntry(escherRecordData) : (escherRecordType == EscherRecordType.OPT ? new Opt(escherRecordData) : (escherRecordType == EscherRecordType.SPLIT_MENU_COLORS ? new SplitMenuColors(escherRecordData) : (escherRecordType == EscherRecordType.CLIENT_TEXT_BOX ? new ClientTextBox(escherRecordData) : new EscherAtom(escherRecordData)))))))))))));
            this.children.add(escherRecord);
        }
        this.initialized = true;
    }

    byte[] getData() {
        if (!this.initialized) {
            this.initialize();
        }
        byte[] byArray = new byte[]{};
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            byte[] byArray2 = escherRecord.getData();
            if (byArray2 == null) continue;
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            byArray = byArray3;
        }
        return this.setHeaderData(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

