/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.LengthConverter;
import common.LengthUnit;
import common.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.CellView;
import jxl.Image;
import jxl.Sheet;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientData;
import jxl.biff.drawing.DrawingData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.DrawingGroupObject;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Origin;
import jxl.biff.drawing.PNGReader;
import jxl.biff.drawing.ShapeType;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;

public class Drawing
implements DrawingGroupObject,
Image {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Drawing == null ? (class$jxl$biff$drawing$Drawing = Drawing.class$("jxl.biff.drawing.Drawing")) : class$jxl$biff$drawing$Drawing);
    private EscherContainer readSpContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private boolean initialized = false;
    private File imageFile;
    private byte[] imageData;
    private int objectId;
    private int blipId;
    private double x;
    private double y;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    private DrawingData drawingData;
    private ShapeType type;
    private int shapeId;
    private int drawingNumber;
    private Sheet sheet;
    private PNGReader pngReader;
    private ImageAnchorProperties imageAnchorProperties;
    public static ImageAnchorProperties MOVE_AND_SIZE_WITH_CELLS = new ImageAnchorProperties(1);
    public static ImageAnchorProperties MOVE_WITH_CELLS = new ImageAnchorProperties(2);
    public static ImageAnchorProperties NO_MOVE_OR_SIZE_WITH_CELLS = new ImageAnchorProperties(3);
    private static final double DEFAULT_FONT_SIZE = 10.0;
    static /* synthetic */ Class class$jxl$biff$drawing$Drawing;

    public Drawing(MsoDrawingRecord msoDrawingRecord, ObjRecord objRecord, DrawingData drawingData, DrawingGroup drawingGroup, Sheet sheet) {
        this.drawingGroup = drawingGroup;
        this.msoDrawingRecord = msoDrawingRecord;
        this.drawingData = drawingData;
        this.objRecord = objRecord;
        this.sheet = sheet;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData.addData(this.msoDrawingRecord.getData());
        this.drawingNumber = this.drawingData.getNumDrawings() - 1;
        this.drawingGroup.addDrawing(this);
        Assert.verify(msoDrawingRecord != null && objRecord != null);
        this.initialize();
    }

    protected Drawing(DrawingGroupObject drawingGroupObject, DrawingGroup drawingGroup) {
        Drawing drawing = (Drawing)drawingGroupObject;
        Assert.verify(drawing.origin == Origin.READ);
        this.msoDrawingRecord = drawing.msoDrawingRecord;
        this.objRecord = drawing.objRecord;
        this.initialized = false;
        this.origin = Origin.READ;
        this.drawingData = drawing.drawingData;
        this.drawingGroup = drawingGroup;
        this.drawingNumber = drawing.drawingNumber;
        this.drawingGroup.addDrawing(this);
    }

    public Drawing(double d, double d2, double d3, double d4, File file) {
        this.imageFile = file;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.referenceCount = 1;
        this.imageAnchorProperties = MOVE_WITH_CELLS;
        this.type = ShapeType.PICTURE_FRAME;
    }

    public Drawing(double d, double d2, double d3, double d4, byte[] byArray) {
        this.imageData = byArray;
        this.initialized = true;
        this.origin = Origin.WRITE;
        this.x = d;
        this.y = d2;
        this.width = d3;
        this.height = d4;
        this.referenceCount = 1;
        this.imageAnchorProperties = MOVE_WITH_CELLS;
        this.type = ShapeType.PICTURE_FRAME;
    }

    private void initialize() {
        Opt opt;
        this.readSpContainer = this.drawingData.getSpContainer(this.drawingNumber);
        Assert.verify(this.readSpContainer != null);
        EscherRecord[] escherRecordArray = this.readSpContainer.getChildren();
        Sp sp = (Sp)this.readSpContainer.getChildren()[0];
        this.shapeId = sp.getShapeId();
        this.objectId = this.objRecord.getObjectId();
        this.type = ShapeType.getType(sp.getShapeType());
        if (this.type == ShapeType.UNKNOWN) {
            logger.warn("Unknown shape type");
        }
        if ((opt = (Opt)this.readSpContainer.getChildren()[1]).getProperty(260) != null) {
            this.blipId = opt.getProperty((int)260).value;
        }
        if (opt.getProperty(261) != null) {
            this.imageFile = new File(opt.getProperty((int)261).stringValue);
        } else if (this.type == ShapeType.PICTURE_FRAME) {
            logger.warn("no filename property for drawing");
            this.imageFile = new File(Integer.toString(this.blipId));
        }
        ClientAnchor clientAnchor = null;
        for (int i = 0; i < escherRecordArray.length && clientAnchor == null; ++i) {
            if (escherRecordArray[i].getType() != EscherRecordType.CLIENT_ANCHOR) continue;
            clientAnchor = (ClientAnchor)escherRecordArray[i];
        }
        if (clientAnchor == null) {
            logger.warn("client anchor not found");
        } else {
            this.x = clientAnchor.getX1();
            this.y = clientAnchor.getY1();
            this.width = clientAnchor.getX2() - this.x;
            this.height = clientAnchor.getY2() - this.y;
            this.imageAnchorProperties = ImageAnchorProperties.getImageAnchorProperties(clientAnchor.getProperties());
        }
        if (this.blipId == 0) {
            logger.warn("linked drawings are not supported");
        }
        this.initialized = true;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public String getImageFilePath() {
        if (this.imageFile == null) {
            return this.blipId != 0 ? Integer.toString(this.blipId) : "__new__image__";
        }
        return this.imageFile.getPath();
    }

    public final void setObjectId(int n, int n2, int n3) {
        this.objectId = n;
        this.blipId = n2;
        this.shapeId = n3;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    public final int getObjectId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.objectId;
    }

    public int getShapeId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.shapeId;
    }

    public final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    public MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    public EscherContainer getSpContainer() {
        Object object;
        if (!this.initialized) {
            this.initialize();
        }
        if (this.origin == Origin.READ) {
            return this.getReadSpContainer();
        }
        SpContainer spContainer = new SpContainer();
        Sp sp = new Sp(this.type, this.shapeId, 2560);
        spContainer.add(sp);
        Opt opt = new Opt();
        opt.addProperty(260, true, false, this.blipId);
        if (this.type == ShapeType.PICTURE_FRAME) {
            object = this.imageFile != null ? this.imageFile.getPath() : "";
            opt.addProperty(261, true, true, ((String)object).length() * 2, (String)object);
            opt.addProperty(447, false, false, 65536);
            opt.addProperty(959, false, false, 524288);
            spContainer.add(opt);
        }
        object = new ClientAnchor(this.x, this.y, this.x + this.width, this.y + this.height, this.imageAnchorProperties.getValue());
        spContainer.add((EscherRecord)object);
        ClientData clientData = new ClientData();
        spContainer.add(clientData);
        return spContainer;
    }

    public void setDrawingGroup(DrawingGroup drawingGroup) {
        this.drawingGroup = drawingGroup;
    }

    public DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    public void setReferenceCount(int n) {
        this.referenceCount = n;
    }

    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.x;
    }

    public void setX(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.x = d;
    }

    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.y;
    }

    public void setY(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.y = d;
    }

    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    public void setWidth(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.width = d;
    }

    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    public void setHeight(double d) {
        if (this.origin == Origin.READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = Origin.READ_WRITE;
        }
        this.height = d;
    }

    private EscherContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    public byte[] getImageData() {
        Assert.verify(this.origin == Origin.READ || this.origin == Origin.READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    public byte[] getImageBytes() throws IOException {
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            return this.getImageData();
        }
        Assert.verify(this.origin == Origin.WRITE);
        if (this.imageFile == null) {
            Assert.verify(this.imageData != null);
            return this.imageData;
        }
        byte[] byArray = new byte[(int)this.imageFile.length()];
        FileInputStream fileInputStream = new FileInputStream(this.imageFile);
        fileInputStream.read(byArray, 0, byArray.length);
        fileInputStream.close();
        return byArray;
    }

    public ShapeType getType() {
        return this.type;
    }

    public void writeAdditionalRecords(jxl.write.biff.File file) throws IOException {
        if (this.origin == Origin.READ) {
            file.write(this.objRecord);
            return;
        }
        ObjRecord objRecord = new ObjRecord(this.objectId, ObjRecord.PICTURE);
        file.write(objRecord);
    }

    public void writeTailRecords(jxl.write.biff.File file) throws IOException {
    }

    public double getColumn() {
        return this.getX();
    }

    public double getRow() {
        return this.getY();
    }

    public boolean isFirst() {
        return this.msoDrawingRecord.isFirst();
    }

    public boolean isFormObject() {
        return false;
    }

    public void removeRow(int n) {
        if (this.y > (double)n) {
            this.setY(n);
        }
    }

    private double getWidthInPoints() {
        if (this.sheet == null) {
            logger.warn("calculating image width:  sheet is null");
            return 0.0;
        }
        int n = (int)this.x;
        int n2 = (int)Math.ceil(this.x + this.width) - 1;
        CellView cellView = this.sheet.getColumnView(n);
        int n3 = cellView.getSize();
        double d = (1.0 - (this.x - (double)n)) * (double)n3;
        double d2 = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
        double d3 = d * 0.59 * d2 / 256.0;
        int n4 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n2 != n) {
            cellView = this.sheet.getColumnView(n2);
            n4 = cellView.getSize();
            d4 = (this.x + this.width - (double)n2) * (double)n4;
            d2 = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
            d5 = d4 * 0.59 * d2 / 256.0;
        }
        double d6 = 0.0;
        for (int i = 0; i < n2 - n - 1; ++i) {
            cellView = this.sheet.getColumnView(n + 1 + i);
            d2 = cellView.getFormat() != null ? (double)cellView.getFormat().getFont().getPointSize() : 10.0;
            d6 += (double)cellView.getSize() * 0.59 * d2 / 256.0;
        }
        double d7 = d6 + d3 + d5;
        return d7;
    }

    private double getHeightInPoints() {
        if (this.sheet == null) {
            logger.warn("calculating image height:  sheet is null");
            return 0.0;
        }
        int n = (int)this.y;
        int n2 = (int)Math.ceil(this.y + this.height) - 1;
        int n3 = this.sheet.getRowView(n).getSize();
        double d = (1.0 - (this.y - (double)n)) * (double)n3;
        int n4 = 0;
        double d2 = 0.0;
        if (n2 != n) {
            n4 = this.sheet.getRowView(n2).getSize();
            d2 = (this.y + this.height - (double)n2) * (double)n4;
        }
        double d3 = 0.0;
        for (int i = 0; i < n2 - n - 1; ++i) {
            d3 += (double)this.sheet.getRowView(n + 1 + i).getSize();
        }
        double d4 = d3 + (double)n3 + (double)n4;
        double d5 = d4 / 20.0;
        return d5;
    }

    public double getWidth(LengthUnit lengthUnit) {
        double d = this.getWidthInPoints();
        return d * LengthConverter.getConversionFactor(LengthUnit.POINTS, lengthUnit);
    }

    public double getHeight(LengthUnit lengthUnit) {
        double d = this.getHeightInPoints();
        return d * LengthConverter.getConversionFactor(LengthUnit.POINTS, lengthUnit);
    }

    public int getImageWidth() {
        return this.getPngReader().getWidth();
    }

    public int getImageHeight() {
        return this.getPngReader().getHeight();
    }

    public double getHorizontalResolution(LengthUnit lengthUnit) {
        int n = this.getPngReader().getHorizontalResolution();
        return (double)n / LengthConverter.getConversionFactor(LengthUnit.METRES, lengthUnit);
    }

    public double getVerticalResolution(LengthUnit lengthUnit) {
        int n = this.getPngReader().getVerticalResolution();
        return (double)n / LengthConverter.getConversionFactor(LengthUnit.METRES, lengthUnit);
    }

    private PNGReader getPngReader() {
        if (this.pngReader != null) {
            return this.pngReader;
        }
        byte[] byArray = null;
        if (this.origin == Origin.READ || this.origin == Origin.READ_WRITE) {
            byArray = this.getImageData();
        } else {
            try {
                byArray = this.getImageBytes();
            }
            catch (IOException iOException) {
                logger.warn("Could not read image file");
                byArray = new byte[]{};
            }
        }
        this.pngReader = new PNGReader(byArray);
        this.pngReader.read();
        return this.pngReader;
    }

    protected void setImageAnchor(ImageAnchorProperties imageAnchorProperties) {
        this.imageAnchorProperties = imageAnchorProperties;
        if (this.origin == Origin.READ) {
            this.origin = Origin.READ_WRITE;
        }
    }

    protected ImageAnchorProperties getImageAnchor() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.imageAnchorProperties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static class ImageAnchorProperties {
        private int value;
        private static ImageAnchorProperties[] o = new ImageAnchorProperties[0];

        ImageAnchorProperties(int n) {
            this.value = n;
            ImageAnchorProperties[] imageAnchorPropertiesArray = o;
            o = new ImageAnchorProperties[imageAnchorPropertiesArray.length + 1];
            System.arraycopy(imageAnchorPropertiesArray, 0, o, 0, imageAnchorPropertiesArray.length);
            ImageAnchorProperties.o[imageAnchorPropertiesArray.length] = this;
        }

        int getValue() {
            return this.value;
        }

        static ImageAnchorProperties getImageAnchorProperties(int n) {
            ImageAnchorProperties imageAnchorProperties = MOVE_AND_SIZE_WITH_CELLS;
            for (int i = 0; i < o.length; ++i) {
                if (o[i].getValue() != n) continue;
                imageAnchorProperties = o[i];
                break;
            }
            return imageAnchorProperties;
        }
    }
}

