/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.WorkbookSettings;
import jxl.biff.DisplayFormat;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class FormatRecord
extends WritableRecordData
implements DisplayFormat,
jxl.format.Format {
    public static Logger logger = Logger.getLogger(class$jxl$biff$FormatRecord == null ? (class$jxl$biff$FormatRecord = FormatRecord.class$("jxl.biff.FormatRecord")) : class$jxl$biff$FormatRecord);
    private boolean initialized;
    private byte[] data;
    private int indexCode;
    private String formatString;
    private boolean date;
    private boolean number;
    private Format format;
    private static String[] dateStrings = new String[]{"dd", "mm", "yy", "hh", "ss", "m/", "/d"};
    public static final BiffType biff8 = new BiffType();
    public static final BiffType biff7 = new BiffType();
    static /* synthetic */ Class class$jxl$biff$FormatRecord;

    FormatRecord(String string, int n) {
        super(Type.FORMAT);
        this.formatString = string;
        this.indexCode = n;
        this.initialized = true;
    }

    protected FormatRecord() {
        super(Type.FORMAT);
        this.initialized = false;
    }

    protected FormatRecord(FormatRecord formatRecord) {
        super(Type.FORMAT);
        this.initialized = false;
        this.formatString = formatRecord.formatString;
        this.date = formatRecord.date;
        this.number = formatRecord.number;
    }

    public FormatRecord(Record record, WorkbookSettings workbookSettings, BiffType biffType) {
        super(record);
        Object object;
        int n;
        byte[] byArray = this.getRecord().getData();
        this.indexCode = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.initialized = true;
        if (biffType == biff8) {
            n = IntegerHelper.getInt(byArray[2], byArray[3]);
            this.formatString = byArray[4] == 0 ? StringHelper.getString(byArray, n, 5, workbookSettings) : StringHelper.getUnicodeString(byArray, n, 5);
        } else {
            n = byArray[2];
            object = new byte[n];
            System.arraycopy(byArray, 3, object, 0, ((byte[])object).length);
            this.formatString = new String((byte[])object);
        }
        this.date = false;
        this.number = false;
        for (n = 0; n < dateStrings.length; ++n) {
            object = dateStrings[n];
            if (this.formatString.indexOf((String)object) == -1 && this.formatString.indexOf(((String)object).toUpperCase()) == -1) continue;
            this.date = true;
            break;
        }
        if (!(this.date || this.formatString.indexOf(35) == -1 && this.formatString.indexOf(48) == -1)) {
            this.number = true;
        }
    }

    public byte[] getData() {
        this.data = new byte[this.formatString.length() * 2 + 3 + 2];
        IntegerHelper.getTwoBytes(this.indexCode, this.data, 0);
        IntegerHelper.getTwoBytes(this.formatString.length(), this.data, 2);
        this.data[4] = 1;
        StringHelper.getUnicodeBytes(this.formatString, this.data, 5);
        return this.data;
    }

    public int getFormatIndex() {
        return this.indexCode;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(int n) {
        this.indexCode = n;
        this.initialized = true;
    }

    protected final String replace(String string, String string2, String string3) {
        String string4 = string;
        int n = string4.indexOf(string2);
        while (n != -1) {
            StringBuffer stringBuffer = new StringBuffer(string4.substring(0, n));
            stringBuffer.append(string3);
            stringBuffer.append(string4.substring(n + string2.length()));
            string4 = stringBuffer.toString();
            n = string4.indexOf(string2);
        }
        return string4;
    }

    protected final void setFormatString(String string) {
        this.formatString = string;
    }

    public final boolean isDate() {
        return this.date;
    }

    public final boolean isNumber() {
        return this.number;
    }

    public final NumberFormat getNumberFormat() {
        if (this.format != null && this.format instanceof NumberFormat) {
            return (NumberFormat)this.format;
        }
        try {
            String string = this.formatString;
            string = this.replace(string, "E+", "E");
            string = this.replace(string, "_)", "");
            string = this.replace(string, "_", "");
            string = this.replace(string, "[Red]", "");
            string = this.replace(string, "\\", "");
            this.format = new DecimalFormat(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.format = new DecimalFormat("#.###");
        }
        return (NumberFormat)this.format;
    }

    public final DateFormat getDateFormat() {
        int n;
        StringBuffer stringBuffer;
        if (this.format != null && this.format instanceof DateFormat) {
            return (DateFormat)this.format;
        }
        String string = this.formatString;
        int n2 = string.indexOf("AM/PM");
        while (n2 != -1) {
            stringBuffer = new StringBuffer(string.substring(0, n2));
            stringBuffer.append('a');
            stringBuffer.append(string.substring(n2 + 5));
            string = stringBuffer.toString();
            n2 = string.indexOf("AM/PM");
        }
        n2 = string.indexOf("ss.0");
        while (n2 != -1) {
            stringBuffer = new StringBuffer(string.substring(0, n2));
            stringBuffer.append("ss.SSS");
            n2 += 4;
            while (n2 < string.length() && string.charAt(n2) == '0') {
                ++n2;
            }
            stringBuffer.append(string.substring(n2));
            string = stringBuffer.toString();
            n2 = string.indexOf("ss.0");
        }
        stringBuffer = new StringBuffer();
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) == '\\') continue;
            stringBuffer.append(string.charAt(n));
        }
        string = stringBuffer.toString();
        if (string.charAt(0) == '[' && (n = string.indexOf(93)) != -1) {
            string = string.substring(n + 1);
        }
        string = this.replace(string, ";@", "");
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            int n3;
            int n4;
            if (cArray[i] != 'm') continue;
            if (i > 0 && (cArray[i - 1] == 'm' || cArray[i - 1] == 'M')) {
                cArray[i] = cArray[i - 1];
                continue;
            }
            int n5 = Integer.MAX_VALUE;
            for (n4 = i - 1; n4 > 0; --n4) {
                if (cArray[n4] != 'h') continue;
                n5 = i - n4;
                break;
            }
            for (n4 = i + 1; n4 < cArray.length; ++n4) {
                if (cArray[n4] != 'h') continue;
                n5 = Math.min(n5, n4 - i);
                break;
            }
            for (n4 = i - 1; n4 > 0; --n4) {
                if (cArray[n4] != 'H') continue;
                n5 = i - n4;
                break;
            }
            for (n4 = i + 1; n4 < cArray.length; ++n4) {
                if (cArray[n4] != 'H') continue;
                n5 = Math.min(n5, n4 - i);
                break;
            }
            for (n4 = i - 1; n4 > 0; --n4) {
                if (cArray[n4] != 's') continue;
                n5 = Math.min(n5, i - n4);
                break;
            }
            for (n4 = i + 1; n4 < cArray.length; ++n4) {
                if (cArray[n4] != 's') continue;
                n5 = Math.min(n5, n4 - i);
                break;
            }
            n4 = Integer.MAX_VALUE;
            for (n3 = i - 1; n3 > 0; --n3) {
                if (cArray[n3] != 'd') continue;
                n4 = i - n3;
                break;
            }
            for (n3 = i + 1; n3 < cArray.length; ++n3) {
                if (cArray[n3] != 'd') continue;
                n4 = Math.min(n4, n3 - i);
                break;
            }
            for (n3 = i - 1; n3 > 0; --n3) {
                if (cArray[n3] != 'y') continue;
                n4 = Math.min(n4, i - n3);
                break;
            }
            for (n3 = i + 1; n3 < cArray.length; ++n3) {
                if (cArray[n3] != 'y') continue;
                n4 = Math.min(n4, n3 - i);
                break;
            }
            if (n4 < n5) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                continue;
            }
            if (n4 != n5 || n4 == Integer.MAX_VALUE || (n3 = cArray[i - n4]) != 121 && n3 != 100) continue;
            cArray[i] = Character.toUpperCase(cArray[i]);
        }
        try {
            this.format = new SimpleDateFormat(new String(cArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.format = new SimpleDateFormat("dd MM yyyy hh:mm:ss");
        }
        return (DateFormat)this.format;
    }

    public int getIndexCode() {
        return this.indexCode;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public boolean isBuiltIn() {
        return false;
    }

    public int hashCode() {
        return this.formatString.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FormatRecord)) {
            return false;
        }
        FormatRecord formatRecord = (FormatRecord)object;
        if (this.initialized && formatRecord.initialized) {
            if (this.date != formatRecord.date || this.number != formatRecord.number) {
                return false;
            }
            return this.formatString.equals(formatRecord.formatString);
        }
        return this.formatString.equals(formatRecord.formatString);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class BiffType {
        private BiffType() {
        }
    }
}

