/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.biff.FontRecord;
import jxl.biff.IndexMapping;
import jxl.write.biff.File;

public class Fonts {
    private ArrayList fonts = new ArrayList();
    private static final int numDefaultFonts = 4;

    public void addFont(FontRecord fontRecord) {
        if (!fontRecord.isInitialized()) {
            int n = this.fonts.size();
            if (n >= 4) {
                ++n;
            }
            fontRecord.initialize(n);
            this.fonts.add(fontRecord);
        }
    }

    public FontRecord getFont(int n) {
        if (n > 4) {
            --n;
        }
        return (FontRecord)this.fonts.get(n);
    }

    public void write(File file) throws IOException {
        Iterator iterator = this.fonts.iterator();
        FontRecord fontRecord = null;
        while (iterator.hasNext()) {
            fontRecord = (FontRecord)iterator.next();
            file.write(fontRecord);
        }
    }

    IndexMapping rationalize() {
        IndexMapping indexMapping = new IndexMapping(this.fonts.size() + 1);
        ArrayList<FontRecord> arrayList = new ArrayList<FontRecord>();
        FontRecord fontRecord = null;
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            fontRecord = (FontRecord)this.fonts.get(i);
            arrayList.add(fontRecord);
            indexMapping.setMapping(fontRecord.getFontIndex(), fontRecord.getFontIndex());
        }
        Iterator iterator = null;
        FontRecord fontRecord2 = null;
        boolean bl = false;
        for (int i = 4; i < this.fonts.size(); ++i) {
            fontRecord = (FontRecord)this.fonts.get(i);
            bl = false;
            iterator = arrayList.iterator();
            while (iterator.hasNext() && !bl) {
                fontRecord2 = (FontRecord)iterator.next();
                if (!fontRecord.equals(fontRecord2)) continue;
                bl = true;
                indexMapping.setMapping(fontRecord.getFontIndex(), indexMapping.getNewIndex(fontRecord2.getFontIndex()));
                ++n;
            }
            if (bl) continue;
            arrayList.add(fontRecord);
            int n2 = fontRecord.getFontIndex() - n;
            Assert.verify(n2 > 4);
            indexMapping.setMapping(fontRecord.getFontIndex(), n2);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            fontRecord = (FontRecord)iterator.next();
            fontRecord.initialize(indexMapping.getNewIndex(fontRecord.getFontIndex()));
        }
        this.fonts = arrayList;
        return indexMapping;
    }
}

