/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Logger;
import jxl.biff.IntegerHelper;

public class DValParser {
    private static Logger logger = Logger.getLogger(class$jxl$biff$DValParser == null ? (class$jxl$biff$DValParser = DValParser.class$("jxl.biff.DValParser")) : class$jxl$biff$DValParser);
    private static int PROMPT_BOX_VISIBLE_MASK = 1;
    private static int PROMPT_BOX_AT_CELL_MASK = 2;
    private static int VALIDITY_DATA_CACHED_MASK = 4;
    private boolean promptBoxVisible;
    private boolean promptBoxAtCell;
    private boolean validityDataCached;
    private int numDVRecords;
    private int objectId;
    static /* synthetic */ Class class$jxl$biff$DValParser;

    public DValParser(byte[] byArray) {
        int n = IntegerHelper.getInt(byArray[0], byArray[1]);
        this.promptBoxVisible = (n & PROMPT_BOX_VISIBLE_MASK) != 0;
        this.promptBoxAtCell = (n & PROMPT_BOX_AT_CELL_MASK) != 0;
        this.validityDataCached = (n & VALIDITY_DATA_CACHED_MASK) != 0;
        this.objectId = IntegerHelper.getInt(byArray[10], byArray[11], byArray[12], byArray[13]);
        this.numDVRecords = IntegerHelper.getInt(byArray[14], byArray[15], byArray[16], byArray[17]);
    }

    public DValParser(int n, int n2) {
        this.objectId = n;
        this.numDVRecords = n2;
        this.validityDataCached = true;
    }

    public byte[] getData() {
        byte[] byArray = new byte[18];
        int n = 0;
        if (this.promptBoxVisible) {
            n |= PROMPT_BOX_VISIBLE_MASK;
        }
        if (this.promptBoxAtCell) {
            n |= PROMPT_BOX_AT_CELL_MASK;
        }
        if (this.validityDataCached) {
            n |= VALIDITY_DATA_CACHED_MASK;
        }
        IntegerHelper.getTwoBytes(n, byArray, 0);
        IntegerHelper.getFourBytes(this.objectId, byArray, 10);
        IntegerHelper.getFourBytes(this.numDVRecords, byArray, 14);
        return byArray;
    }

    public void dvRemoved() {
        --this.numDVRecords;
    }

    public int getNumberOfDVRecords() {
        return this.numDVRecords;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public void dvAdded() {
        ++this.numDVRecords;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

