/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.sql.SQLException;
import net.ucanaccess.util.Logger;

public class UcanaccessSQLException
extends SQLException {
    private static final long serialVersionUID = -1432048647665807662L;
    private Throwable cause;
    private int errorCode;
    private String sqlState;

    public UcanaccessSQLException() {
    }

    private String versionMessage(String message) {
        if (message != null && message.startsWith("UCAExc:")) {
            return message;
        }
        String version = this.getClass().getPackage().getImplementationVersion();
        version = version == null ? "4.x.x " : version + " ";
        version = "UCAExc:::" + version;
        return version + message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.versionMessage(super.getLocalizedMessage());
    }

    @Override
    public String getMessage() {
        return this.versionMessage(super.getMessage());
    }

    public UcanaccessSQLException(ExceptionMessages reason) {
        super(Logger.getMessage(reason.name()));
        this.sqlState = String.valueOf(15000);
        this.errorCode = 15000;
    }

    public UcanaccessSQLException(ExceptionMessages reason, Object ... pars) {
        super(Logger.getMessage(reason.name(), pars));
        this.sqlState = String.valueOf(15000);
        this.errorCode = 15000;
    }

    public UcanaccessSQLException(String reason, String SQLState) {
        super(Logger.getMessage(reason), SQLState);
    }

    public UcanaccessSQLException(String reason, String SQLState, int vendorCode) {
        super(Logger.getMessage(reason), SQLState, vendorCode);
    }

    public UcanaccessSQLException(String reason, String _sqlState, int _vendorCode, Throwable _cause) {
        super(Logger.getMessage(reason), _sqlState, _vendorCode, _cause);
    }

    public UcanaccessSQLException(String _reason, String _sqlState, Throwable _cause) {
        super(Logger.getMessage(_reason), _sqlState, _cause);
    }

    public UcanaccessSQLException(String reason, Throwable _cause) {
        super(Logger.getMessage(reason), _cause);
    }

    public UcanaccessSQLException(Throwable _cause) {
        super(UcanaccessSQLException.explaneCause(_cause));
        this.cause = _cause;
        if (_cause instanceof SQLException) {
            SQLException se = (SQLException)_cause;
            this.errorCode = se.getErrorCode();
            this.sqlState = se.getSQLState();
        } else {
            this.sqlState = String.valueOf(15000);
            this.errorCode = 15000;
        }
    }

    public static String explaneCause(Throwable cause) {
        SQLException se;
        if (cause instanceof SQLException && (se = (SQLException)cause).getErrorCode() == -5562) {
            return cause.getMessage() + " " + Logger.getMessage(ExceptionMessages.INVALID_TYPES_IN_COMBINATION.name());
        }
        return cause.getMessage();
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public int getErrorCode() {
        return this.errorCode == 0 ? super.getErrorCode() : this.errorCode;
    }

    @Override
    public String getSQLState() {
        return this.sqlState == null ? super.getSQLState() : this.sqlState;
    }

    public static enum ExceptionMessages {
        CONCURRENT_PROCESS_ACCESS,
        INVALID_CREATE_STATEMENT,
        INVALID_INTERVAL_VALUE,
        INVALID_JACKCESS_OPENER,
        INVALID_MONTH_NUMBER,
        NOT_A_VALID_PASSWORD,
        ONLY_IN_MEMORY_ALLOWED,
        UNPARSABLE_DATE,
        COMPLEX_TYPE_UNSUPPORTED,
        INVALID_PARAMETER,
        INVALID_TYPES_IN_COMBINATION,
        UNSUPPORTED_TYPE,
        STATEMENT_DDL,
        CLOSE_ON_COMPLETION_STATEMENT,
        ACCESS_97,
        PARAMETER_NULL,
        TABLE_DOESNT_EXIST,
        DEFAULT_NEEDED;

    }
}

