/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Cursor;
import com.healthmarketscience.jackcess.CursorBuilder;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.complex.ComplexValueForeignKey;
import com.healthmarketscience.jackcess.util.SimpleColumnMatcher;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.converters.SQLConverter;

public class IndexSelector {
    private Index bestIndex;
    private boolean primaryCursor;
    private Table table;

    public IndexSelector(Table _table) {
        this.table = _table;
    }

    public Index getBestIndex() {
        if (this.bestIndex == null) {
            List<? extends Index> li = this.table.getIndexes();
            for (Index index : li) {
                if (!index.isPrimaryKey()) continue;
                this.bestIndex = index;
                this.primaryCursor = true;
                break;
            }
            if (this.bestIndex == null) {
                for (Index index : li) {
                    if (!index.isUnique()) continue;
                    this.bestIndex = index;
                    break;
                }
            }
            if (this.bestIndex == null && li.size() == 1) {
                this.bestIndex = li.get(0);
            }
        }
        return this.bestIndex;
    }

    public Cursor getCursor() throws IOException {
        Index idx = this.getBestIndex();
        CursorBuilder cb = this.table.newCursor();
        Cursor cursor = idx == null ? cb.toCursor() : cb.setIndex(idx).toCursor();
        cursor.setColumnMatcher(new ColumnMatcher());
        return cursor;
    }

    public boolean isPrimaryCursor() {
        return this.primaryCursor;
    }

    private class ColumnMatcher
    extends SimpleColumnMatcher {
        private ColumnMatcher() {
        }

        @Override
        public boolean matches(Table _table, String _columnName, Object _currVal, Object _dbVal) {
            if (_currVal == null && _dbVal == null) {
                return true;
            }
            if (_currVal == null || _dbVal == null) {
                return false;
            }
            if (_currVal instanceof Date && _dbVal instanceof Date) {
                return ((Date)_currVal).compareTo((Date)_dbVal) == 0;
            }
            if (_currVal instanceof BigDecimal && _dbVal instanceof BigDecimal) {
                return ((BigDecimal)_currVal).compareTo((BigDecimal)_dbVal) == 0;
            }
            if (_dbVal instanceof BigDecimal && _currVal instanceof Number) {
                return ((BigDecimal)_dbVal).compareTo(new BigDecimal(_currVal.toString())) == 0;
            }
            if (_currVal instanceof BigDecimal && _dbVal instanceof Number) {
                return ((BigDecimal)_currVal).compareTo(new BigDecimal(_dbVal.toString())) == 0;
            }
            if (_currVal instanceof Integer && _dbVal instanceof Short) {
                return ((Integer)_currVal).intValue() == ((Short)_dbVal).intValue();
            }
            if (_dbVal instanceof Integer && _currVal instanceof Short) {
                return ((Integer)_dbVal).intValue() == ((Short)_currVal).intValue();
            }
            if (_currVal instanceof Integer && _dbVal instanceof Byte) {
                return (Integer)_currVal == SQLConverter.asUnsigned((Byte)_dbVal);
            }
            if (_dbVal instanceof Integer && _currVal instanceof Byte) {
                return (Integer)_dbVal == SQLConverter.asUnsigned((Byte)_currVal);
            }
            if (_dbVal instanceof Float && _currVal instanceof Double || _dbVal instanceof Double && _currVal instanceof Float) {
                if (new BigDecimal(_dbVal.toString()).compareTo(new BigDecimal(_currVal.toString())) == 0) {
                    return true;
                }
                if (_dbVal instanceof Float && _currVal instanceof Double) {
                    return ((Float)_dbVal).doubleValue() == ((Double)_currVal).doubleValue();
                }
            }
            if (_currVal instanceof byte[] && _dbVal instanceof byte[]) {
                byte[] val1 = (byte[])_currVal;
                byte[] val2 = (byte[])_dbVal;
                if (val1.length != val2.length) {
                    return false;
                }
                for (int y = 0; y < val1.length; ++y) {
                    if (val1[y] == val2[y]) continue;
                    return false;
                }
                return true;
            }
            if (_currVal instanceof ComplexBase[] && _dbVal instanceof ComplexValueForeignKey) {
                try {
                    boolean eq = Arrays.equals((ComplexBase[])_currVal, ComplexBase.convert((ComplexValueForeignKey)_dbVal));
                    return eq;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return super.matches(_table, _columnName, _currVal, _dbVal);
        }
    }
}

