/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.Table;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.BlobKey;
import net.ucanaccess.jdbc.UcanaccessConnection;

public class BlobAction
implements IFeedbackAction {
    private Table table;
    private boolean containsBlob;
    private HashSet<BlobKey> keys = new HashSet();

    /*
     * WARNING - void declaration
     */
    public BlobAction(Table _table, Object[] newValues) throws SQLException {
        this.table = _table;
        if (!BlobKey.hasPrimaryKey(_table)) {
            return;
        }
        Index pk = _table.getPrimaryKeyIndex();
        HashSet<String> hsKey = new HashSet<String>();
        for (Index.Column column : pk.getColumns()) {
            hsKey.add(column.getName());
        }
        HashSet<String> hsBlob = new HashSet<String>();
        boolean bl = false;
        HashMap<String, Object> keyMap = new HashMap<String, Object>();
        for (Column column : _table.getColumns()) {
            void var6_8;
            if (column.getType().equals((Object)DataType.OLE) && newValues[var6_8] != null) {
                this.containsBlob = true;
                hsBlob.add(column.getName());
            }
            if (hsKey.contains(column.getName())) {
                keyMap.put(column.getName(), newValues[var6_8]);
            }
            ++var6_8;
        }
        for (String string : hsBlob) {
            this.keys.add(new BlobKey(keyMap, this.table.getName(), string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doAction(ICommand toChange) throws SQLException {
        if (this.containsBlob) {
            UcanaccessConnection conn = UcanaccessConnection.getCtxConnection();
            Connection connHsqldb = conn.getHSQLDBConnection();
            Statement ps = null;
            for (BlobKey bkey : this.keys) {
                String sql = "UPDATE " + SQLConverter.escapeIdentifier(this.table.getName(), connHsqldb) + " SET " + SQLConverter.escapeIdentifier(bkey.getColumnName(), connHsqldb) + "=? WHERE ";
                StringBuilder sb = new StringBuilder();
                String and = "";
                ArrayList<Object> values = new ArrayList<Object>();
                for (Map.Entry<String, Object> me : bkey.getKey().entrySet()) {
                    sb.append(and).append(SQLConverter.escapeIdentifier(me.getKey(), connHsqldb)).append(" = ?");
                    values.add(me.getValue());
                }
                sql = sql + sb.toString();
                conn.setFeedbackState(true);
                try {
                    conn.setFeedbackState(true);
                    ps = connHsqldb.prepareStatement(sql);
                    ps.setObject(1, bkey.getBytes());
                    int j = 2;
                    for (Object e : values) {
                        ps.setObject(j, e);
                        ++j;
                    }
                    ps.executeUpdate();
                    conn.setFeedbackState(false);
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
        }
    }
}

