/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public class DelayedWeakReference<T>
extends WeakReference<T>
implements Delayed {
    private final long origin = System.currentTimeMillis();
    private final long delay;

    public DelayedWeakReference(T t2, long l2) {
        super(t2);
        this.delay = l2;
    }

    public DelayedWeakReference(T t2, ReferenceQueue<T> referenceQueue, long l2) {
        super(t2, referenceQueue);
        this.delay = l2;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof DelayedWeakReference) {
            long l2 = this.delay - ((DelayedWeakReference)delayed).delay;
            return l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
        }
        long l3 = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return l3 == 0L ? 0 : (l3 < 0L ? -1 : 1);
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        if (timeUnit == null) {
            throw new NullPointerException("time unit must not be null");
        }
        return timeUnit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }
}

