/*
 * Decompiled with CFR 0.152.
 */
package com.informix.lang;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import java.sql.Connection;
import java.sql.SQLException;

public abstract class Interval {
    public static final byte TU_YEAR = 0;
    public static final byte TU_MONTH = 2;
    public static final byte TU_DAY = 4;
    public static final byte TU_HOUR = 6;
    public static final byte TU_MINUTE = 8;
    public static final byte TU_SECOND = 10;
    public static final byte TU_FRAC = 12;
    public static final byte TU_F1 = 11;
    public static final byte TU_F2 = 12;
    public static final byte TU_F3 = 13;
    public static final byte TU_F4 = 14;
    public static final byte TU_F5 = 15;
    protected static final int DECSIZE = 16;
    protected static final int NUMBER_UNITS = 7;
    protected static final int YEAR_IDX = 0;
    protected static final int MONTH_IDX = 1;
    protected static final int DAY_IDX = 2;
    protected static final int HOUR_IDX = 3;
    protected static final int MIN_IDX = 4;
    protected static final int SEC_IDX = 5;
    protected static final int FRAC_IDX = 6;
    protected static final char[] dtdelim = new char[]{'-', '-', ' ', ':', ':', '.', ' '};
    protected static final boolean DEBUG = true;
    protected static boolean debugFlag = false;
    protected short int_qual = 0;
    private String locale = null;
    private static String staticlocale = null;

    protected Interval() throws SQLException {
    }

    protected Interval(Connection connection) throws SQLException {
        this.setConnection(connection);
    }

    public static byte getLength(short s2) {
        return (byte)(s2 >> 8);
    }

    protected byte getLength() {
        return Interval.getLength(this.int_qual);
    }

    public short getQualifier() {
        return this.int_qual;
    }

    public static short getQualifier(byte by, byte by2, byte by3) throws SQLException {
        Interval.goodQualifier(by, by2, by3);
        byte by4 = (byte)(by3 - by2 + by);
        short s2 = (short)(by4 << 8 | by2 << 4 | by3);
        return s2;
    }

    protected short getQualifier(byte by, byte by2) throws SQLException {
        this.goodQualifier(by, by2);
        short s2 = (short)(by2 - by + (by == 0 ? 4 : 2));
        short s3 = (short)((byte)s2 << 8 | by << 4 | by2);
        return s3;
    }

    public static void goodQualifier(byte by, byte by2, byte by3) throws SQLException {
        if (by < 0 || by > 9) {
            throw IfxErrMsg.getSQLException(-79717, "", staticlocale);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79718, "", staticlocale);
        }
        if (by3 < 0 || by3 > 15) {
            throw IfxErrMsg.getSQLException(-79719, "", staticlocale);
        }
    }

    protected boolean goodQualifier(byte by, byte by2) throws SQLException {
        if (by > by2) {
            throw IfxErrMsg.getSQLException(-79720, "", this.locale);
        }
        if (by < 0 || by > 15) {
            throw IfxErrMsg.getSQLException(-79718, "", this.locale);
        }
        if (by2 < 0 || by2 > 15) {
            throw IfxErrMsg.getSQLException(-79719, "", this.locale);
        }
        return true;
    }

    public static byte getScale(short s2) {
        byte by = Interval.getEndCode(s2);
        byte by2 = 0;
        if (by > 10) {
            by2 = (byte)(by - 10);
        }
        return by2;
    }

    public static byte getStartCode(short s2) {
        byte by = (byte)(s2 >> 4 & 0xF);
        return by;
    }

    public static byte getEndCode(short s2) {
        byte by = (byte)(s2 & 0xF);
        return by;
    }

    public byte getStartCode() {
        return Interval.getStartCode(this.int_qual);
    }

    public byte getEndCode() {
        return Interval.getEndCode(this.int_qual);
    }

    protected static byte getFirstLength(short s2) {
        int n2 = Interval.getLength(s2) - (Interval.getEndCode(s2) - Interval.getStartCode(s2));
        byte by = (byte)n2;
        return by;
    }

    public static byte getStaticStartCode(short s2) {
        byte by = (byte)(s2 >> 4 & 0xF);
        return by;
    }

    public static byte getStaticEndCode(short s2) {
        byte by = (byte)(s2 & 0xF);
        return by;
    }

    public static String getFieldName(byte by) {
        switch (by) {
            case 0: {
                return "year";
            }
            case 2: {
                return "month";
            }
            case 4: {
                return "day";
            }
            case 6: {
                return "hour";
            }
            case 8: {
                return "minute";
            }
            case 10: {
                return "second";
            }
            case 11: {
                return "fraction(1)";
            }
            case 12: {
                return "fraction(2)";
            }
            case 13: {
                return "fraction";
            }
            case 14: {
                return "fraction(4)";
            }
            case 15: {
                return "fraction(5)";
            }
        }
        return "";
    }

    public static String getIfxTypeName(int n2, short s2) {
        String string = null;
        byte by = Interval.getStaticStartCode(s2);
        if (by == 12) {
            by = 13;
        }
        if (n2 == 14) {
            byte by2 = Interval.getFirstLength(s2);
            string = "interval " + Interval.getFieldName(by) + (by < 11 && (by > 0 && by2 != 2 || by == 0 && by2 != 4) ? "(" + Interval.getFirstLength(s2) + ")" : "") + " to " + Interval.getFieldName(Interval.getStaticEndCode(s2));
        } else if (n2 == 10) {
            string = "datetime " + Interval.getFieldName(by) + " to " + Interval.getFieldName(Interval.getStaticEndCode(s2));
        }
        return string;
    }

    protected int[] stringToUnits(String string, short s2) throws SQLException {
        int n2;
        int[] nArray = new int[7];
        for (n2 = 0; n2 < 7; ++n2) {
            nArray[n2] = 0;
        }
        n2 = Interval.getEndCode(s2);
        int n3 = Interval.getStartCode(s2);
        byte by = Interval.getLength(s2);
        string = string.trim();
        int n4 = 0;
        if (string.length() == 0) {
            return nArray;
        }
        Interval.println("str --" + string + "--");
        Interval.println("startCode " + n3 + " endCode " + n2 + " qual " + Integer.toString(s2, 16));
        try {
            int n5;
            int n6;
            if (n3 == 12) {
                if (string.charAt(n4) == '0') {
                    ++n4;
                }
                if (string.charAt(n4) != '.') {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80000, this.locale);
                }
                ++n4;
            } else {
                for (n6 = 0; n6 < string.length() && Character.isDigit(string.charAt(n4 + n6)); n6 = (int)((byte)(n6 + 1))) {
                }
                Interval.println("fwidth " + by + " numDigits " + n6);
                if (n6 == 0) {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80001, this.locale);
                }
                if (n6 > by) {
                    throw IfxErrMsg.getLocSQLMinorException(-79721, -80002, this.locale);
                }
                nArray[n3 / 2] = Integer.parseInt(string.substring(n4, n4 + n6));
                Interval.println("data[" + n3 / 2 + "]: " + nArray[n3 / 2]);
                n4 += n6 + 1;
                n3 = (byte)(n3 + 2);
            }
            while (n3 <= n2 && n3 <= 10) {
                n6 = n4;
                n5 = n4 + 1;
                if (!Character.isDigit(string.charAt(n4)) && string.charAt(n4) != ' ') {
                    throw IfxErrMsg.getLocSQLMinorException(-79722, -80003, Integer.toString(n4), this.locale);
                }
                if (n5 < string.length() && Character.isDigit(string.charAt(n5))) {
                    n6 = n5++;
                }
                nArray[n3 / 2] = Integer.parseInt(string.substring(n4, n6 + 1));
                Interval.println("data[" + n3 / 2 + "]: " + nArray[n3 / 2]);
                Interval.println("strIdx " + n4 + " endIdx " + n6 + " idx " + n5);
                if (n5 < string.length() && string.charAt(n5) != dtdelim[n3 / 2]) {
                    if (n3 == n2) break;
                    Interval.println("startCode " + n3 + " idx " + n5);
                    throw IfxErrMsg.getLocSQLMinorException(-79723, -80003, Integer.toString(n5), this.locale);
                }
                n4 = n5 + 1;
                n3 = (byte)(n3 + 2);
            }
            if (n4 < string.length()) {
                Interval.println("fraction part if any :" + string.substring(n4) + ":");
                n6 = n4 - 1;
                n5 = n4;
                n3 = 11;
                int n7 = 0;
                while (n5 < string.length() && n3 <= n2 && Character.isDigit(string.charAt(n5))) {
                    ++n6;
                    ++n5;
                    n3 = (byte)(n3 + 1);
                    ++n7;
                }
                if (n6 >= n4) {
                    int n8 = Integer.parseInt(string.substring(n4, n6 + 1));
                    int n9 = 9 - n7;
                    for (int i2 = 0; i2 < n9; ++i2) {
                        n8 *= 10;
                    }
                    nArray[6] = n8;
                }
                n4 = n5;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw IfxErrMsg.getLocSQLException(-79724, this.locale);
        }
        if (n4 < string.length()) {
            throw IfxErrMsg.getSQLException(-79725, string.substring(n4), this.locale);
        }
        return nArray;
    }

    protected static void print(String string) {
        if (debugFlag) {
            System.out.print(string);
        }
    }

    protected static void println(String string) {
        if (debugFlag) {
            System.out.println(string);
        }
    }

    public void setConnection(Connection connection) {
        if (connection != null) {
            this.locale = ((IfxConnection)connection).getclLocale();
        }
        Interval.setStaticLocale(this.locale);
    }

    private static void setStaticLocale(String string) {
        staticlocale = string;
    }
}

