/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnectionProperty;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.PreparedStatementCache$PreparedStatementCleanupThread;
import com.informix.util.DelayedWeakReference;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class PreparedStatementCache
extends LinkedHashMap<String, IfxPreparedStatement> {
    private static final long serialVersionUID = 1L;
    private static final BlockingQueue<DelayedWeakReference<PreparedStatementCache>> a = new DelayQueue<DelayedWeakReference<PreparedStatementCache>>();
    private static final MemoryMXBean b = ManagementFactory.getMemoryMXBean();
    private static final AtomicLong c = new AtomicLong();
    private static final ReferenceQueue<PreparedStatement> d = new ReferenceQueue();
    final WeakReference<IfxSqliConnect> e;
    private int f;
    protected final int initialMaximumEntries;
    protected final int zeroPointPercentage;
    protected final long minimumDelay;
    protected final long maximumDelay;

    public static List<BSONObject> getCacheInfo() {
        boolean bl = IfxSqliConnect.md;
        DelayedWeakReference<PreparedStatementCache>[] delayedWeakReferenceArray = PreparedStatementCache.getPreparedStatementCaches();
        ArrayList<BSONObject> arrayList = new ArrayList<BSONObject>();
        for (DelayedWeakReference<PreparedStatementCache> delayedWeakReference : delayedWeakReferenceArray) {
            PreparedStatementCache preparedStatementCache = (PreparedStatementCache)delayedWeakReference.get();
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            if (preparedStatementCache == null || delayedWeakReference.isEnqueued()) continue;
            basicBSONObject.put("size", (Object)preparedStatementCache.size());
            if (!bl) continue;
        }
        return arrayList;
    }

    public static DelayedWeakReference<PreparedStatementCache>[] getPreparedStatementCaches() {
        DelayedWeakReference[] delayedWeakReferenceArray = a.toArray(new DelayedWeakReference[0]);
        return delayedWeakReferenceArray;
    }

    public static double computeUsedHeapPercentage() {
        long l2 = b.getHeapMemoryUsage().getUsed();
        long l3 = b.getHeapMemoryUsage().getMax();
        double d2 = (double)(l2 * 100L) / (double)l3;
        return d2;
    }

    public PreparedStatementCache(IfxSqliConnect ifxSqliConnect, int n2) {
        super(n2 + 1, 1.0f, false);
        this.e = new WeakReference<IfxSqliConnect>(ifxSqliConnect);
        this.f = n2;
        this.initialMaximumEntries = n2;
        this.zeroPointPercentage = IfxConnectionProperty.IFMXCONNECTION_CLEANER_ZEROPOINT.getIntValue(ifxSqliConnect);
        this.minimumDelay = IfxConnectionProperty.IFMXCONNECTION_CLEANER_DELAY_MINIMUM.getLongValue(ifxSqliConnect);
        this.maximumDelay = IfxConnectionProperty.IFMXCONNECTION_CLEANER_DELAY_MAXIMUM.getLongValue(ifxSqliConnect);
        a.offer(new DelayedWeakReference<PreparedStatementCache>(this, 0L));
    }

    public synchronized int getMaximumEntries() {
        return this.f;
    }

    public synchronized void setMaximumEntries(int n2) {
        block5: {
            boolean bl = IfxSqliConnect.md;
            this.f = n2;
            if (this.size() > n2) {
                Set<String> set = this.keySet();
                Iterator<String> iterator = set.iterator();
                ArrayList<Object> arrayList = new ArrayList<Object>();
                int n3 = 0;
                while (iterator.hasNext()) {
                    String string = iterator.next();
                    if (!bl) {
                        if (n3 >= n2) {
                            arrayList.add(string);
                        }
                        ++n3;
                        if (!bl) continue;
                    }
                    break block5;
                }
                for (String string : arrayList) {
                    this.remove(string);
                    if (!bl) continue;
                }
            }
        }
    }

    @Override
    public synchronized IfxPreparedStatement get(Object object) {
        return (IfxPreparedStatement)super.get(object);
    }

    @Override
    protected synchronized boolean removeEldestEntry(Map.Entry<String, IfxPreparedStatement> entry) {
        if (this.size() > this.f) {
            IfxPreparedStatement ifxPreparedStatement = entry.getValue();
            if (ifxPreparedStatement != null) {
                try {
                    ifxPreparedStatement.superClose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized IfxPreparedStatement remove(Object object) {
        return (IfxPreparedStatement)super.remove(object);
    }

    @Override
    public synchronized void clear() {
        block4: {
            boolean bl = IfxSqliConnect.md;
            for (IfxPreparedStatement ifxPreparedStatement : this.values()) {
                try {
                    if (bl) break block4;
                    if (ifxPreparedStatement != null) {
                        ifxPreparedStatement.close();
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!bl) continue;
            }
            super.clear();
        }
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public synchronized int size() {
        return super.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object object) {
        return super.containsKey(object);
    }

    @Override
    public synchronized IfxPreparedStatement put(String string, IfxPreparedStatement ifxPreparedStatement) {
        return super.put(string, ifxPreparedStatement);
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends IfxPreparedStatement> map) {
        super.putAll(map);
    }

    @Override
    public synchronized Object clone() {
        return super.clone();
    }

    @Override
    public synchronized Set<String> keySet() {
        return super.keySet();
    }

    @Override
    public synchronized Collection<IfxPreparedStatement> values() {
        return super.values();
    }

    @Override
    public synchronized Set<Map.Entry<String, IfxPreparedStatement>> entrySet() {
        return super.entrySet();
    }

    @Override
    public synchronized boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    static /* synthetic */ BlockingQueue a() {
        return a;
    }

    static {
        PreparedStatementCache$PreparedStatementCleanupThread preparedStatementCache$PreparedStatementCleanupThread = new PreparedStatementCache$PreparedStatementCleanupThread();
        preparedStatementCache$PreparedStatementCleanupThread.start();
    }
}

