/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import com.informix.util.dateUtil;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class IfxVarChar
extends IfxObject {
    private static final int h = 255;
    protected String value;
    private String i;
    private String j;

    IfxVarChar() throws SQLException {
        this.setIfxType(13);
    }

    IfxVarChar(String string) throws SQLException {
        block3: {
            block2: {
                this.setIfxType(13);
                this.value = string;
                if (this.value != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.unnullify();
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        try {
            String string = this.conn.getdbEncoding();
            return ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string, ((IfxSqliConnect)this.conn).encoption);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        try {
            block7: {
                byte[] byArray;
                block9: {
                    block8: {
                        if (!this.isNull()) break block7;
                        if (!((IfxSqliConnect)this.conn).r()) break block8;
                        byArray = new byte[2];
                        if (!IfxSqliConnect.md) break block9;
                    }
                    byArray = new byte[this.encodedLength + 1];
                }
                memoryUtil.byfill(byArray, (byte)0);
                byArray[0] = 1;
                return byArray;
            }
            String string = this.conn.getdbEncoding();
            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxVarChar(this.value, string, this.encodedLength, ((IfxSqliConnect)this.conn).encoption);
            if (((IfxSqliConnect)this.conn).r()) {
                int n2 = 1 + (0xFF & byArray[0]);
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                return byArray2;
            }
            return byArray;
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, String string) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length, string);
    }

    @Override
    public void fromIfx(byte[] byArray, int n2, int n3, String string) throws SQLException {
        try {
            block7: {
                int n4;
                block6: {
                    n4 = byArray[n2] & 0xFF;
                    if (n4 == 1 && byArray[n2 + 1] == 0) {
                        this.value = null;
                        this.nullify();
                        return;
                    }
                    if (n4 != 0) break block6;
                    this.value = new String("");
                    if (!IfxSqliConnect.md) break block7;
                }
                IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                this.value = IfxToJavaType.IfxToJavaChar(byArray, n2 + 1, n4, string, ((IfxSqliConnect)this.conn).encoption);
            }
            this.unnullify();
        }
        catch (IOException iOException) {
            throw IfxErrMsg.getSQLException(-79783, this.conn);
        }
    }

    @Override
    public void fromIfx(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = byArray[n2] & 0xFF;
        String string = this.conn.getdbEncoding();
        if (n3 > 0) {
            n4 = Math.min(n4, n3);
        }
        if (((IfxSqliConnect)this.conn).isOnLine5SER()) {
            string = "NOENCODING";
        }
        this.fromIfx(byArray, n2, n3, string);
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        byte[] byArray;
        block9: {
            block8: {
                if (TraceFlag.compiletrace) {
                    this.a(99, "IfxVarChar.toBytes() called");
                }
                byArray = null;
                if (this.value != null) break block8;
                this.nullify();
                if (!IfxSqliConnect.md) break block9;
            }
            try {
                String string = ((IfxSqliConnect)this.conn).returnEnc();
                byte[] byArray2 = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(this.value, string, ((IfxSqliConnect)this.conn).encoption);
                int n2 = byArray2.length;
                byArray = new byte[n2 - 2];
                System.arraycopy(byArray2, 2, byArray, 0, n2 - 2);
            }
            catch (Exception exception) {
                this.value = null;
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxVarChar.toBytes() exited");
        }
        return byArray;
    }

    @Override
    public String toString() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.fromString(string, false);
    }

    @Override
    public void fromString(String string, boolean bl) throws SQLException {
        block3: {
            block5: {
                String string2;
                block4: {
                    boolean bl2;
                    block2: {
                        bl2 = IfxSqliConnect.md;
                        if (string != null) break block2;
                        this.nullify();
                        if (!bl2) break block3;
                    }
                    this.clearWarning();
                    string2 = null;
                    string2 = bl ? string.trim() : string;
                    if (string2.length() <= 255) break block4;
                    this.value = string2.substring(0, 255);
                    if (!bl2) break block5;
                }
                this.value = string2;
            }
            this.unnullify();
        }
    }

    @Override
    public void fromBytes(byte[] byArray) throws SQLException {
        block6: {
            block7: {
                if (TraceFlag.compiletrace) {
                    this.a(99, "IfxVarChar.fromBytes() called");
                }
                if (byArray != null) break block7;
                this.nullify();
                if (!IfxSqliConnect.md) break block6;
            }
            try {
                int n2 = byArray.length;
                if (byArray.length > 255) {
                    n2 = 255;
                }
                String string = this.conn.getdbEncoding();
                IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                this.value = IfxToJavaType.IfxToJavaChar(byArray, 0, n2, string, ((IfxSqliConnect)this.conn).encoption);
                this.unnullify();
            }
            catch (Exception exception) {
                this.value = null;
                if (!(exception instanceof IOException)) break block6;
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxVarChar.fromBytes() exited");
        }
    }

    @Override
    public byte toByte() throws SQLException {
        byte by;
        if (this.isNull()) {
            return 0;
        }
        try {
            by = Byte.parseByte(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return by;
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        block3: {
            block2: {
                if (by != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromByte((byte)by);
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.value = String.valueOf(by);
        this.unnullify();
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.equalsIgnoreCase("1") || this.value.equalsIgnoreCase("true") || this.value.equalsIgnoreCase("t");
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        block3: {
            block2: {
                if (bl != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromBoolean((boolean)bl);
        }
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        block3: {
            block2: {
                if (!bl) break block2;
                this.value = "true";
                if (!IfxSqliConnect.md) break block3;
            }
            this.value = "false";
        }
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            this.b(this.value);
            Integer n2 = Integer.parseInt(this.i);
            return n2;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    private void b(String string) {
        int n2;
        int n3;
        int n4;
        block12: {
            boolean bl;
            block14: {
                block13: {
                    int n5;
                    int n6;
                    block11: {
                        bl = IfxSqliConnect.md;
                        if (string == null) {
                            this.value = string;
                            this.i = string;
                            this.nullify();
                            return;
                        }
                        this.value = string;
                        n4 = string.length();
                        for (n3 = n4 - 1; n3 >= 0; --n3) {
                            n6 = string.charAt(n3);
                            n5 = 32;
                            if (!bl) {
                                if (n6 != n5) break;
                                if (!bl) continue;
                            }
                            break block11;
                        }
                        n6 = n3;
                        n5 = n4 - 1;
                    }
                    if (n6 == n5) break block13;
                    this.i = string.substring(0, ++n3);
                    if (!bl) break block14;
                }
                this.i = string;
            }
            if (this.conn != null && this.conn.getTrimTrailingSpaces()) {
                this.j = this.i;
            }
            n4 = this.i.length();
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = string.charAt(n3);
                if (!bl) {
                    if (n2 != 32) break;
                    if (!bl) continue;
                }
                break block12;
            }
            n2 = n3;
        }
        if (n2 != 0) {
            this.i = this.i.substring(n3, n4);
        }
        this.unnullify();
    }

    @Override
    public void fromInt(Integer n2) throws SQLException {
        block3: {
            block2: {
                if (n2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromInt((int)n2);
        }
    }

    @Override
    public void fromInt(int n2) throws SQLException {
        this.value = Integer.toString(n2);
        this.unnullify();
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        try {
            Short s2 = new Short(this.value);
            return s2;
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromShort(Short s2) throws SQLException {
        block3: {
            block2: {
                if (s2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromShort((short)s2);
        }
    }

    @Override
    public void fromShort(short s2) throws SQLException {
        this.value = String.valueOf(s2);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.value);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
    }

    @Override
    public void fromLong(Long l2) throws SQLException {
        block3: {
            block2: {
                if (l2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromLong((long)l2);
        }
    }

    @Override
    public void fromLong(long l2) throws SQLException {
        this.value = String.valueOf(l2);
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        Float f2 = Float.valueOf(this.value);
        return f2.floatValue();
    }

    @Override
    public void fromFloat(Float f2) throws SQLException {
        block3: {
            block2: {
                if (f2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromFloat(f2.floatValue());
        }
    }

    @Override
    public void fromFloat(float f2) throws SQLException {
        this.value = String.valueOf(f2);
        this.unnullify();
    }

    @Override
    public Date toDate() throws SQLException {
        Date date = null;
        if (this.isNull()) {
            return null;
        }
        try {
            date = dateUtil.convertDateObj(this.value, this.conn);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return date;
    }

    @Override
    public void fromDate(Date date) throws SQLException {
        block3: {
            block2: {
                if (date != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.value = dateUtil.convertDateStr(date, this.conn);
            this.unnullify();
        }
    }

    @Override
    public Time toTime() throws SQLException {
        Time time;
        long l2 = 0L;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = true;
            Object object = dateUtil.convertDateTimeObj(this.value, this.conn, bl);
            l2 = ((java.util.Date)object).getTime();
            time = new Time(l2);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return time;
    }

    @Override
    public void fromTime(Time time) throws SQLException {
        block3: {
            block2: {
                if (time != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            long l2 = time.getTime();
            this.value = dateUtil.convertDateTimeStr(time, this.conn, l2);
            this.unnullify();
        }
    }

    @Override
    public Timestamp toTimestamp() throws SQLException {
        Timestamp timestamp;
        if (this.isNull()) {
            return null;
        }
        try {
            boolean bl = false;
            timestamp = (Timestamp)dateUtil.convertDateTimeObj(this.value, this.conn, bl);
        }
        catch (Exception exception) {
            throw new SQLException(IfxErrMsg.getMessage(-79716, this.conn) + exception.toString(), IfxErrMsg.getSQLSTATE(-79716), -79716);
        }
        return timestamp;
    }

    @Override
    public void fromTimestamp(Timestamp timestamp) throws SQLException {
        block3: {
            block2: {
                if (timestamp != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            long l2 = timestamp.getTime();
            this.value = dateUtil.convertDateTimeStr(timestamp, this.conn, l2);
            this.unnullify();
        }
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        Double d2 = Double.valueOf(this.value);
        return d2;
    }

    @Override
    public void fromDouble(Double d2) throws SQLException {
        block3: {
            block2: {
                if (d2 != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.fromDouble((double)d2);
        }
    }

    @Override
    public void fromDouble(double d2) throws SQLException {
        this.value = String.valueOf(d2);
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        BigDecimal bigDecimal;
        if (this.isNull()) {
            return null;
        }
        try {
            bigDecimal = new BigDecimal(this.value);
        }
        catch (NumberFormatException numberFormatException) {
            throw IfxErrMsg.getSQLException(-79716, numberFormatException.toString(), this.conn);
        }
        return bigDecimal;
    }

    public void fromBigDecimal(BigDecimal bigDecimal) throws SQLException {
        block3: {
            block2: {
                if (bigDecimal != null) break block2;
                this.nullify();
                if (!IfxSqliConnect.md) break block3;
            }
            this.value = bigDecimal.toString();
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null || !(object instanceof IfxVarChar)) {
            return false;
        }
        IfxVarChar ifxVarChar = (IfxVarChar)object;
        if (ifxVarChar.isNull()) {
            return false;
        }
        return this.value.equals(ifxVarChar.value);
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        byte[] byArray;
        block5: {
            if (this.isNull()) {
                return null;
            }
            try {
                String string = this.conn.getdbEncoding();
                if (string != null) {
                    byArray = this.value.getBytes(string);
                    if (!IfxSqliConnect.md) break block5;
                }
                byArray = this.value.getBytes();
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        return new ByteArrayInputStream(byArray);
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n2) throws SQLException {
        block5: {
            block7: {
                boolean bl;
                block6: {
                    bl = IfxSqliConnect.md;
                    this.a(3, "IfxVarChar: fromAsciiStream()");
                    if (inputStream == null) break block5;
                    this.a(3, "IfxVarChar: fromAsciiStream(): length = " + n2);
                    if (n2 != 0) break block6;
                    this.value = "";
                    if (!bl) break block7;
                }
                byte[] byArray = new byte[n2];
                int n3 = 0;
                try {
                    block2: while (true) {
                        int n4 = inputStream.read(byArray, n3, n2);
                        this.a(3, "IfxVarChar: fromAsciiStream(): readLen=" + n4);
                        this.a(3, "IfxVarChar: fromAsciiStream(): length = " + (n2 -= n4));
                        this.a(3, "IfxVarChar: fromAsciiStream(): offset =" + (n3 += n4));
                        do {
                            if (n2 > 0) continue block2;
                        } while (bl);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(byArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n2) throws SQLException {
        this.fromAsciiStream(inputStream, n2);
    }

    @Override
    public InputStream toInputStream() throws SQLException {
        return this.toAsciiStream();
    }

    @Override
    public void fromCharacterStream(Reader reader, int n2) throws SQLException {
        block5: {
            block7: {
                boolean bl;
                block6: {
                    bl = IfxSqliConnect.md;
                    this.a(3, "IfxVarChar: fromCharacterStream()");
                    if (reader == null) break block5;
                    this.a(3, "IfxVarChar: fromCharacterStream():length =" + n2);
                    if (n2 != 0) break block6;
                    this.value = "";
                    if (!bl) break block7;
                }
                char[] cArray = new char[n2];
                int n3 = 0;
                try {
                    block2: while (true) {
                        int n4 = reader.read(cArray, n3, n2);
                        this.a(3, "IfxVarChar: fromcharacterStream():readLen=" + n4);
                        this.a(3, "IfxVarChar: fromCharacterStream():length=" + (n2 -= n4));
                        this.a(3, "IfxVarChar: fromCharacterStream():offset=" + (n3 += n4));
                        do {
                            if (n2 > 0) continue block2;
                        } while (bl);
                        break;
                    }
                }
                catch (Exception exception) {
                    throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                }
                this.value = new String(cArray);
                this.a(3, "IfxVarChar: value = " + this.value);
            }
            this.unnullify();
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        this.a(99, "IfxVarChar: toCharacterStream()");
        this.a(3, "IfxVarChar: toCharacterStream(): value = " + this.value);
        return new StringReader(this.value);
    }
}

