/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected static final short MODE_READ_WRITE = 0;
    protected static final short MODE_RW_BUFF = 1;
    protected static final short MODE_CLIENT_ONLY = 2;
    protected IfxSmartBlob smb;
    protected IfxLocator locatorPointer;
    protected IfxConnection conn;
    protected boolean isBlob_loaded;
    protected IfxTmpFile tempBlobFile;
    protected InputStream blobStream;
    protected byte[] blobBuffer;
    protected String BlobFileName;
    protected long blobSize;
    protected short ifxType;
    protected int smartBlobMode;

    protected IfxLob() {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n2) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        this.a(inputStream, n2, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n2, String string) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        ifxLobDescriptor.setSbspace(string);
        this.a(inputStream, n2, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, InputStream inputStream, int n2, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        this.smb = null;
        this.locatorPointer = null;
        this.conn = null;
        this.isBlob_loaded = false;
        this.tempBlobFile = null;
        this.blobStream = null;
        this.blobBuffer = null;
        this.blobSize = 0L;
        this.smartBlobMode = 0;
        this.conn = (IfxConnection)connection;
        this.a(inputStream, n2, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray) throws SQLException {
        int n2;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n2 = 0;
                if (!IfxSqliConnect.md) break block3;
            }
            n2 = byArray.length;
        }
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        this.a(byArray, n2, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray, String string) throws SQLException {
        int n2;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n2 = 0;
                if (!IfxSqliConnect.md) break block3;
            }
            n2 = byArray.length;
        }
        IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(connection);
        ifxLobDescriptor.setSbspace(string);
        this.a(byArray, n2, ifxLobDescriptor);
    }

    protected IfxLob(Connection connection, byte[] byArray, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        int n2;
        block3: {
            block2: {
                this.smb = null;
                this.locatorPointer = null;
                this.conn = null;
                this.isBlob_loaded = false;
                this.tempBlobFile = null;
                this.blobStream = null;
                this.blobBuffer = null;
                this.blobSize = 0L;
                this.smartBlobMode = 0;
                this.conn = (IfxConnection)connection;
                if (byArray != null) break block2;
                n2 = 0;
                if (!IfxSqliConnect.md) break block3;
            }
            n2 = byArray.length;
        }
        this.a(byArray, n2, ifxLobDescriptor);
    }

    private void a(InputStream inputStream, int n2, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(ifxLobDescriptor, 8, this.locatorPointer);
            if (n2 > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), inputStream, n2);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException sQLException) {
            this.smb = null;
            throw sQLException;
        }
    }

    private void a(byte[] byArray, int n2, IfxLobDescriptor ifxLobDescriptor) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(ifxLobDescriptor, 8, this.locatorPointer);
            if (n2 > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), byArray);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException sQLException) {
            this.smb = null;
            throw sQLException;
        }
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null) {
            return this.locatorPointer;
        }
        return this.smb.locator;
    }

    protected void setLocator(IfxLocator ifxLocator) throws SQLException {
        block5: {
            block4: {
                if (this.ifxType != 3 && this.ifxType != 2) {
                    throw IfxErrMsg.getSQLException(-79787, this.conn);
                }
                if (this.smb == null) break block4;
                this.smb.locator = ifxLocator;
                if (!IfxSqliConnect.md) break block5;
            }
            this.locatorPointer = ifxLocator;
        }
    }

    protected void setIfxLobType(short s2) {
        this.ifxType = s2;
    }

    protected void setSize(long l2) {
        this.blobSize = l2;
    }

    protected void setConnection(IfxConnection ifxConnection) {
        this.conn = ifxConnection;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    protected void setMode(int n2) {
        this.smartBlobMode = n2;
    }

    protected byte[] getPortion(long l2, long l3) {
        byte[] byArray;
        block23: {
            block24: {
                int n2;
                long l4;
                boolean bl;
                block22: {
                    IfxInputStream ifxInputStream;
                    block21: {
                        block20: {
                            bl = IfxSqliConnect.md;
                            if (l2 < 1L || l3 < 0L) {
                                return null;
                            }
                            if (l3 == 0L) {
                                return new byte[0];
                            }
                            try {
                                if (!this.isBlob_loaded) {
                                    this.loadSmBlob();
                                }
                            }
                            catch (Exception exception) {
                                return null;
                            }
                            if (l2 > this.blobSize) {
                                return null;
                            }
                            l4 = l2 - 1L;
                            if (l4 + l3 <= this.blobSize) break block20;
                            n2 = (int)(this.blobSize - l4);
                            if (!bl) break block21;
                        }
                        n2 = (int)l3;
                    }
                    byArray = new byte[n2];
                    if (this.tempBlobFile == null) break block22;
                    try {
                        ifxInputStream = this.tempBlobFile.b();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    try {
                        if (l4 > 0L) {
                            ifxInputStream.skip(l4);
                        }
                        ifxInputStream.read(byArray, 0, n2);
                        ((FileInputStream)ifxInputStream).close();
                        if (this.ifxType == 3 || this.ifxType == 2) {
                            this.isBlob_loaded = false;
                            this.tempBlobFile.close();
                            this.tempBlobFile = null;
                        }
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    if (!bl) break block23;
                }
                if (this.blobBuffer == null) break block24;
                System.arraycopy(this.blobBuffer, (int)l4, byArray, 0, n2);
                if (this.ifxType != 3 && this.ifxType != 2) break block23;
                this.blobBuffer = null;
                this.isBlob_loaded = false;
                if (!bl) break block23;
            }
            return null;
        }
        return byArray;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream ifxLobInputStream = new IfxLobInputStream(this.conn, this.getLocator());
                return ifxLobInputStream;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
        return byteArrayInputStream;
    }

    protected void setStream(InputStream inputStream, int n2) throws SQLException {
        if (n2 > 0) {
            this.smb.IfxLoWrite(this.smb.getHandle(), inputStream, n2);
        }
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
    }

    protected int setBuffer(byte[] byArray) throws SQLException {
        return this.setBuffer(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    protected int setBuffer(byte[] byArray, int n2, int n3) throws SQLException {
        int n4 = 0;
        if (byArray.length > 0 && n3 > 0) {
            n4 = this.smb.IfxLoWrite(this.smb.getHandle(), byArray, n2, n3);
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        return n4;
    }

    public long seek(long l2, int n2) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoSeek(this.smb.getHandle(), l2, n2);
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public long where() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoTell(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public IfxLoStat getLoStat() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoGetStat(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public void truncate(long l2) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.IfxLoTruncate(this.smb.getHandle(), l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null && this.smb.getHandle() != -1) {
            IfxConnection ifxConnection = this.conn;
            synchronized (ifxConnection) {
                this.smb.IfxLoClose(this.smb.getHandle());
            }
        }
        this.smb = null;
    }

    protected void loadSmBlob() throws SQLException {
        block14: {
            IfxOutputStream ifxOutputStream;
            boolean bl;
            block16: {
                int n2;
                block15: {
                    bl = IfxSqliConnect.md;
                    ifxOutputStream = null;
                    this.tempBlobFile = null;
                    this.blobBuffer = null;
                    this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
                    if (this.blobSize == 0L) {
                        this.blobBuffer = new byte[0];
                        this.tempBlobFile = null;
                        return;
                    }
                    n2 = this.conn.getBlobCacheSize();
                    if (n2 >= 0 && (n2 <= 0 || this.blobSize > (long)n2)) break block15;
                    try {
                        this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
                    }
                    catch (Exception exception) {
                        throw IfxErrMsg.getSQLException(-79753, this.conn);
                    }
                    this.tempBlobFile = null;
                    if (!bl) break block16;
                }
                try {
                    this.tempBlobFile = new IfxTmpFile(this.conn);
                    ifxOutputStream = this.tempBlobFile.c();
                    this.blobBuffer = null;
                }
                catch (Exception exception) {
                    if (n2 == 0) {
                        throw IfxErrMsg.getSQLException(-79774, this.conn);
                    }
                    this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
                    ifxOutputStream = null;
                    this.tempBlobFile = null;
                }
            }
            try {
                if (this.blobBuffer == null) {
                    this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                    this.smb.IfxLoRead(this.smb.getHandle(), ifxOutputStream, (int)this.blobSize);
                    ((FileOutputStream)ifxOutputStream).close();
                    if (!bl) break block14;
                }
                this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), this.blobBuffer, (int)this.blobSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isBlob_loaded = true;
    }

    protected void verifySmbMode() throws SQLException {
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
    }
}

