/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLob;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxTmpFile;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.TraceFlag;
import com.informix.util.memoryUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxBlob
extends IfxObject {
    private static final short h = 0;
    private static final short i = 1;
    private static final short j = 2;
    private static final short k = 3;
    protected static final short BLOBISNULL = 1;
    protected static final short BLOB_TYPE_BYTES = 0;
    protected static final short BLOB_TYPE_STREAM = 1;
    protected byte[] blobDesc = null;
    protected int tb_start = 1;
    protected int tb_end = 0;
    protected int tb_size;
    protected short tb_flags;
    protected InputStream BlobInputStream;
    protected IfxTmpFile tempBlobFile = null;
    protected byte[] blobBuffer;
    protected short blobType;
    protected boolean isBlob_loaded = false;
    protected short ifxType = 0;

    IfxBlob() throws SQLException {
        this.blobDesc = new byte[56];
        this.nullify();
    }

    public IfxBlob(InputStream inputStream, int n2) throws SQLException {
        this.fromInputStream(inputStream, n2);
    }

    public IfxBlob(byte[] byArray) throws SQLException {
        this.fromBytes(byArray);
    }

    protected short getBlobType() {
        return this.blobType;
    }

    protected boolean isBlobByteType() {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 3");
        }
        return this.blobType == 0;
    }

    protected boolean isIfxTextType() {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 3");
        }
        return this.ifxType == 1;
    }

    protected byte[] getBlobBuffer() {
        return this.blobBuffer;
    }

    protected void setBlobBuffer(byte[] byArray) {
        this.blobBuffer = byArray;
    }

    protected int getBlobLength() {
        return this.tb_end - this.tb_start + 1;
    }

    protected void setBlobLength(int n2, int n3, int n4) {
        this.tb_size = n2;
        this.tb_start = n3;
        this.tb_end = n4;
    }

    protected void setBlobLength(int n2) {
        this.setBlobLength(n2, 1, n2);
    }

    protected InputStream getBlobInputStream() {
        return this.BlobInputStream;
    }

    protected String getBlobFileName() {
        if (this.tempBlobFile != null) {
            return this.tempBlobFile.getFileName();
        }
        return null;
    }

    protected void setBlobFileName() {
        if (this.tempBlobFile != null) {
            this.tempBlobFile.close();
            this.tempBlobFile = null;
        }
    }

    protected boolean isBlobLoaded() {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 4");
        }
        return this.isBlob_loaded;
    }

    protected void setLoaded() {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 5");
        }
        this.isBlob_loaded = true;
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n2, int n3) throws SQLException {
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, n2, this.blobDesc, 0, 56);
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[4];
        byte[] byArray5 = new byte[2];
        System.arraycopy(byArray, 16 + n2, byArray2, 0, 4);
        System.arraycopy(byArray, 8 + n2, byArray3, 0, 4);
        System.arraycopy(byArray, 12 + n2, byArray4, 0, 4);
        this.setBlobLength(IfxToJavaType.IfxToJavaInt(byArray2), IfxToJavaType.IfxToJavaInt(byArray3), IfxToJavaType.IfxToJavaInt(byArray4));
        boolean bl = this.conn.isXPS();
        if (bl) {
            this.tb_size = this.tb_end - this.tb_start + 1;
        }
        System.arraycopy(byArray, 38 + n2, byArray5, 0, 2);
        this.tb_flags = IfxToJavaType.IfxToJavaSmallInt(byArray5);
        if (this.tb_flags != 1) {
            this.isBlob_loaded = false;
            this.blobType = 0;
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 6");
        }
    }

    @Override
    public byte[] toIfx() {
        byte[] byArray = new byte[4];
        byArray = JavaToIfxType.JavaToIfxInt(this.tb_size);
        if (this.blobDesc == null) {
            this.blobDesc = new byte[56];
        }
        System.arraycopy(byArray, 0, this.blobDesc, 16, 4);
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 7");
        }
        return this.blobDesc;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            if (this.blobDesc == null) {
                this.blobDesc = new byte[56];
            }
            memoryUtil.byfill(this.blobDesc, (byte)0);
            this.blobDesc[39] = 1;
            return this.blobDesc;
        }
        return this.toIfx();
    }

    @Override
    public InputStream toAsciiStream() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 8");
        }
        if (this.tempBlobFile != null) {
            if (TraceFlag.compiletrace) {
                this.a(99, "IfxBlob() : - 8_1");
            }
            try {
                IfxInputStream ifxInputStream = this.tempBlobFile.b();
                return ifxInputStream;
            }
            catch (Exception exception) {
                if (TraceFlag.compiletrace) {
                    this.a(99, "IfxBlob:toAsciiStream(): " + exception.getMessage());
                }
                SQLException sQLException = IfxErrMsg.getSQLException(-79701, exception.toString(), this.conn);
                sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                throw sQLException;
            }
        }
        if (this.blobBuffer != null) {
            if (TraceFlag.compiletrace) {
                this.a(99, "IfxBlob() : - 8_2");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.blobBuffer);
            return byteArrayInputStream;
        }
        return null;
    }

    @Override
    public void fromInputStream(InputStream inputStream, int n2) throws SQLException {
        block5: {
            block4: {
                this.setBlobLength(n2);
                if (!(inputStream instanceof IfxLobInputStream)) break block4;
                this.BlobInputStream = ((IfxLobInputStream)inputStream).getStream();
                if (!IfxSqliConnect.md) break block5;
            }
            this.BlobInputStream = inputStream;
        }
        this.isBlob_loaded = false;
        this.blobType = 1;
        this.blobBuffer = null;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.g();
            this.a(99, "IfxBlob.fromInputStream() : - 1");
        }
    }

    @Override
    public void fromCharacterStream(Reader reader, int n2) throws SQLException {
        block14: {
            block15: {
                boolean bl;
                block13: {
                    block12: {
                        bl = IfxSqliConnect.md;
                        if (TraceFlag.compiletrace) {
                            this.a(99, "IfxBlob: fromCharacterStream() start...");
                        }
                        if (n2 <= 0 || reader == null) break block13;
                        char[] cArray = new char[n2];
                        int n3 = 0;
                        int n4 = 0;
                        BufferedReader bufferedReader = new BufferedReader(reader);
                        try {
                            if (bufferedReader.ready()) {
                                n3 = bufferedReader.read(cArray, n4, n2);
                                if (TraceFlag.compiletrace) {
                                    this.a(99, "IfxBlob: fromcharacterStream():readLen=" + n3);
                                }
                                this.setBlobLength(n3);
                                this.blobBuffer = new String(cArray).getBytes();
                                if (!bl) break block12;
                            }
                            this.setBlobLength(0);
                            this.blobBuffer = null;
                        }
                        catch (Exception exception) {
                            if (TraceFlag.compiletrace) {
                                this.a(99, "IfxBlob:fromCharacterStream(): " + exception.getMessage());
                            }
                            SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
                            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                            throw sQLException;
                        }
                    }
                    if (!bl) break block14;
                }
                this.setBlobLength(0);
                if (reader == null || n2 != 0) break block15;
                this.blobBuffer = new byte[0];
                if (!bl) break block14;
            }
            this.blobBuffer = null;
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob: fromCharacterStream() end...");
        }
    }

    @Override
    public Reader toCharacterStream() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob: toCharacterStream() start...");
        }
        if (this.isNull()) {
            if (TraceFlag.compiletrace) {
                this.a(99, "IfxBlob: toCharacterStream() end...");
            }
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob: toCharacterStream() end...");
        }
        return new StringReader(this.toString());
    }

    @Override
    public void fromAsciiStream(InputStream inputStream, int n2) throws SQLException {
        this.fromInputStream(inputStream, n2);
        this.ifxType = 1;
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 9");
        }
        return this.toAsciiStream();
    }

    @Override
    public void fromBinaryStream(InputStream inputStream, int n2) throws SQLException {
        this.fromInputStream(inputStream, n2);
        this.ifxType = 0;
    }

    @Override
    public String toString() {
        boolean bl = IfxSqliConnect.md;
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 10");
        }
        if (this.blobBuffer != null) {
            try {
                if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                    if (((IfxSqliConnect)this.conn).x()) {
                        IfxToJavaType cfr_ignored_0 = ((IfxSqliConnect)this.conn).ifxtojava;
                        return IfxToJavaType.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    IfxToJavaType cfr_ignored_1 = ((IfxSqliConnect)this.conn).ifxtojava;
                    return IfxToJavaType.IfxToJavaChar(this.blobBuffer, 0, this.blobBuffer.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                return new String(this.blobBuffer);
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (this.tempBlobFile != null) {
            byte[] byArray;
            block17: {
                int n2;
                IfxInputStream ifxInputStream;
                try {
                    ifxInputStream = this.tempBlobFile.b();
                    n2 = ifxInputStream.available();
                }
                catch (Exception exception) {
                    return null;
                }
                IfxInputStream ifxInputStream2 = ifxInputStream;
                byArray = new byte[n2];
                int n3 = 0;
                try {
                    byte by = (byte)((InputStream)ifxInputStream2).read();
                    while (by != -1) {
                        byArray[n3] = by;
                        ++n3;
                        by = (byte)((InputStream)ifxInputStream2).read();
                        if (!bl) {
                            if (!bl) continue;
                        }
                        break block17;
                    }
                    ((FileInputStream)ifxInputStream).close();
                }
                catch (Exception exception) {
                    return null;
                }
            }
            if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                try {
                    if (((IfxSqliConnect)this.conn).x()) {
                        IfxToJavaType cfr_ignored_2 = ((IfxSqliConnect)this.conn).ifxtojava;
                        return IfxToJavaType.IfxToJavaChar(byArray, 0, byArray.length, ((IfxSqliConnect)this.conn).getclEncoding(), ((IfxSqliConnect)this.conn).encoption);
                    }
                    IfxToJavaType cfr_ignored_3 = ((IfxSqliConnect)this.conn).ifxtojava;
                    return IfxToJavaType.IfxToJavaChar(byArray, 0, byArray.length, ((IfxSqliConnect)this.conn).returnEnc(), ((IfxSqliConnect)this.conn).encoption);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            return new String(byArray);
        }
        return null;
    }

    @Override
    public void fromString(String string) throws SQLException {
        block10: {
            boolean bl;
            block9: {
                bl = IfxSqliConnect.md;
                if (TraceFlag.compiletrace) {
                    this.a(99, "IfxBlob() : - 10");
                }
                if (string != null) break block9;
                this.setBlobLength(0);
                this.blobBuffer = null;
                this.nullify();
                if (!bl) break block10;
            }
            String string2 = this.conn.getdbEncoding();
            try {
                block12: {
                    block11: {
                        if (((IfxObject)this).ifxType == 12 || ((IfxObject)this).ifxType == 101) {
                            byte[] byArray = ((IfxSqliConnect)this.conn).javatoifx.JavaToIfxChar(string, string2, ((IfxSqliConnect)this.conn).encoption);
                        }
                        if (string2 == null) break block11;
                        this.blobBuffer = string.getBytes(string2);
                        if (!bl) break block12;
                    }
                    this.blobBuffer = string.getBytes();
                }
                this.setBlobLength(this.blobBuffer.toString().length());
                this.unnullify();
            }
            catch (Exception exception) {
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw IfxErrMsg.getSQLException(-79783, this.conn);
            }
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob.fromString() : - 2");
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (((IfxObject)this).ifxType == 12) {
            return this.toString();
        }
        return this.toBytes();
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob() : - 11");
        }
        if (this.blobBuffer != null) {
            return (byte[])this.blobBuffer.clone();
        }
        if (this.tempBlobFile != null) {
            int n2;
            IfxInputStream ifxInputStream;
            try {
                ifxInputStream = this.tempBlobFile.b();
                n2 = ifxInputStream.available();
            }
            catch (Exception exception) {
                return null;
            }
            byte[] byArray = new byte[n2];
            try {
                ifxInputStream.read(byArray, 0, n2);
                ((FileInputStream)ifxInputStream).close();
            }
            catch (Exception exception) {
                return null;
            }
            return byArray;
        }
        return null;
    }

    @Override
    public void fromBytes(byte[] byArray) {
        block5: {
            block4: {
                if (byArray != null) break block4;
                this.setBlobLength(0);
                this.blobBuffer = null;
                if (!IfxSqliConnect.md) break block5;
            }
            this.setBlobLength(byArray.length);
            this.blobBuffer = byArray;
            this.unnullify();
        }
        this.BlobInputStream = null;
        this.isBlob_loaded = false;
        this.blobType = 0;
        if (TraceFlag.compiletrace) {
            this.a(99, "IfxBlob.fromBytes() : - 2");
        }
    }

    @Override
    public Blob toBlob() throws SQLException {
        IfxBblob ifxBblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxBblob = new IfxBblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxBblob = new IfxBblob(this.blobBuffer);
        } else {
            return null;
        }
        ifxBblob.setLoadFlag();
        if (ifxBblob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(ifxBblob.smb);
        }
        ifxBblob.setIfxLobType((short)0);
        ifxBblob.setSize(this.getBlobLength());
        return ifxBblob;
    }

    @Override
    public Clob toClob() throws SQLException {
        IfxCblob ifxCblob = null;
        if (this.tempBlobFile != null) {
            try {
                ifxCblob = new IfxCblob(this.tempBlobFile);
            }
            catch (Exception exception) {
                return null;
            }
        } else if (this.blobBuffer != null) {
            ifxCblob = new IfxCblob((Connection)this.conn, this.blobBuffer);
        } else {
            return null;
        }
        ifxCblob.setLoadFlag();
        if (ifxCblob.smb != null) {
            ((IfxSqliConnect)this.conn).addToBlobList(ifxCblob.smb);
        }
        ifxCblob.setIfxLobType((short)1);
        ifxCblob.setSize(this.getBlobLength());
        return ifxCblob;
    }

    @Override
    public void fromBlob(Blob blob) throws SQLException {
        block5: {
            block4: {
                if (!(blob instanceof IfxLob)) break block4;
                short s2 = ((IfxLob)((Object)blob)).getIfxLobType();
                if (s2 == 2 || s2 == 0) {
                    this.fromBinaryStream(((IfxLob)((Object)blob)).getStreamImd(), (int)blob.length());
                }
                if (!IfxSqliConnect.md) break block5;
            }
            this.fromBinaryStream(blob.getBinaryStream(), (int)blob.length());
        }
    }

    @Override
    public void fromClob(Clob clob) throws SQLException {
        block5: {
            block4: {
                if (!(clob instanceof IfxLob)) break block4;
                short s2 = ((IfxLob)((Object)clob)).getIfxLobType();
                if (s2 == 3 || s2 == 1) {
                    this.fromAsciiStream(((IfxLob)((Object)clob)).getStreamImd(), (int)clob.length());
                }
                if (!IfxSqliConnect.md) break block5;
            }
            this.fromAsciiStream(clob.getAsciiStream(), (int)clob.length());
        }
    }

    @Override
    public void clear() {
        this.isBlob_loaded = false;
        this.ifxType = 0;
        if (this.tempBlobFile != null) {
            try {
                this.tempBlobFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.blobBuffer = null;
        this.tempBlobFile = null;
        super.clear();
    }

    void g() {
        if (TraceFlag.compiletrace) {
            this.a(3, "    tb_size: " + this.tb_size);
            this.a(3, "    tb_flags: " + this.tb_flags);
        }
    }

    protected void finalize() {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

