/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IfxCssOutputStream
extends FilterOutputStream {
    private OutputStream IfxOs = null;
    private ByteArrayOutputStream buffer = null;
    private IfxCsm myCSM = null;
    private IfxCsm.Status csmStatus = new IfxCsm.Status();

    public IfxCssOutputStream(OutputStream outputStream, IfxCsm ifxCsm) {
        super(outputStream);
        this.IfxOs = outputStream;
        this.myCSM = ifxCsm;
        this.buffer = new ByteArrayOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.buffer.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        int n2;
        IfxCsmBuffer ifxCsmBuffer = new IfxCsmBuffer();
        try {
            n2 = this.myCSM.ifxCsmProcessOutMessage(new IfxCsmReadBuffer(this.buffer.toByteArray()), ifxCsmBuffer, this.csmStatus);
        }
        catch (IfxCsmException ifxCsmException) {
            throw new IOException(ifxCsmException.toString());
        }
        if (n2 == 1) {
            this.buffer.reset();
            throw new IOException(this.csmStatus.getCsmString());
        }
        ifxCsmBuffer.writeTo(this.IfxOs);
        this.IfxOs.flush();
        ifxCsmBuffer.close();
        this.buffer.reset();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.buffer.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.buffer.write(byArray, n2, n3);
    }

    @Override
    public void write(int n2) throws IOException {
        this.buffer.write(n2);
    }
}

