/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Properties;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import oracle.net.jdbc.nl.NLException;
import oracle.net.ns.NetException;
import oracle.net.nt.CustomSSLSocketFactory;
import oracle.net.nt.DownHostsCache;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.NetStatImpl;
import oracle.net.nt.SSLSocketChannel;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsConfigure;
import oracle.net.nt.TimeoutSocketChannel;

public class TcpsNTAdapter
extends TcpNTAdapter {
    String matchSSLServerCertDNWith;
    boolean fullDNMatch;
    SSLSocketFactory l_sslSockFac;
    Socket underlyingSocket = null;
    SocketChannel underlyingSocketChannel = null;
    SSLSocket socketWithListener;
    SSLEngine l_sslEngine;
    boolean useNio;

    public TcpsNTAdapter(String string, Properties properties) throws NLException {
        super(string, properties);
    }

    @Override
    public void connect() throws IOException {
        this.useNio = Boolean.parseBoolean((String)this.socketOptions.get(20));
        if (!this.useNio) {
            this.l_sslSockFac = CustomSSLSocketFactory.getSSLSocketFactory(this.socketOptions);
            this.underlyingSocket = new Socket();
        } else {
            this.l_sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(this.host, this.port, this.socketOptions);
        }
        String string = (String)this.socketOptions.get(2);
        int n2 = string == null ? 0 : Integer.parseInt(string);
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(18));
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
        if (bl && inetAddressArray.length > 1) {
            inetAddressArray = TcpsNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        DownHostsCache.getInstance().reorderAddresses(inetAddressArray, this.port);
        int n3 = inetAddressArray.length;
        int n4 = 0;
        do {
            InetAddress inetAddress = inetAddressArray[n4];
            InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
            ++n4;
            --n3;
            long l2 = System.currentTimeMillis();
            this.underlyingSocket = new Socket();
            try {
                if (!this.useNio) {
                    this.underlyingSocket.connect(inetSocketAddress, n2);
                } else {
                    this.netStat = new NetStatImpl();
                    this.underlyingSocketChannel = new TimeoutSocketChannel(new InetSocketAddress(inetAddress, this.port), n2, this.netStat);
                    this.underlyingSocket = this.underlyingSocketChannel.socket();
                }
                if (!this.useNio) {
                    this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
                } else {
                    this.socketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine);
                    this.socket = this.socketChannel.socket();
                }
                String string2 = (String)this.socketOptions.get(3);
                if (string2 != null) {
                    this.setOption(3, string2);
                }
                this.setSSLSocketOptions();
                break;
            }
            catch (IOException iOException) {
                DownHostsCache.getInstance().markDownHost(inetAddress, this.port);
                try {
                    if (this.underlyingSocket != null) {
                        this.underlyingSocket.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 > 0) continue;
                String string3 = String.format("%s, socket connect lapse %d ms. %s %d %s %d", iOException.getMessage(), System.currentTimeMillis() - l2, inetAddress.toString(), this.port, string, n4);
                IOException iOException2 = new IOException(string3, iOException);
                throw iOException2;
            }
            catch (NumberFormatException numberFormatException) {
                throw new NetException(505);
            }
        } while (n4 < inetAddressArray.length);
    }

    public void renegotiateSession() throws IOException {
        if (this.useNio) {
            this.l_sslEngine = CustomSSLSocketFactory.getSSLSocketEngine(this.host, this.port, this.socketOptions);
            this.socketChannel = new SSLSocketChannel(this.underlyingSocketChannel, this.l_sslEngine);
            this.socket = this.socketChannel.socket();
        } else {
            this.socketWithListener = (SSLSocket)this.socket;
            this.socket = this.l_sslSockFac.createSocket(this.underlyingSocket, this.host, this.port, true);
        }
        String string = (String)this.socketOptions.get(3);
        if (string != null) {
            this.setOption(3, string);
        }
        this.setSSLSocketOptions();
    }

    public void setSSLSocketOptions() throws IOException {
        super.setSocketOptions();
        SSLSocket sSLSocket = null;
        if (!this.useNio) {
            sSLSocket = (SSLSocket)this.socket;
            sSLSocket.setUseClientMode(true);
        }
        TcpsConfigure.configureVersion(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(6), this.useNio);
        TcpsConfigure.configureCipherSuites(sSLSocket, this.l_sslEngine, (String)this.socketOptions.get(7), this.useNio);
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 108: {
                this.setServerDNMatchValue((String[])object);
                break;
            }
            case 107: {
                if (((String)object).equalsIgnoreCase("TRUE")) {
                    this.fullDNMatch = true;
                    break;
                }
                this.fullDNMatch = false;
                break;
            }
            default: {
                super.setOption(n2, object);
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        SSLSocket sSLSocket = null;
        SSLSession sSLSession = null;
        if (!this.useNio) {
            sSLSocket = (SSLSocket)this.socket;
            sSLSession = sSLSocket.getSession();
        } else {
            sSLSession = this.l_sslEngine.getSession();
        }
        switch (n2) {
            case 102: {
                String string = sSLSession.getCipherSuite();
                if (string != null && string.indexOf("NULL") == -1) {
                    return "TRUE";
                }
                return "FALSE";
            }
            case 105: {
                return sSLSession.getCipherSuite();
            }
            case 103: {
                X509Certificate x509Certificate = (X509Certificate)sSLSession.getPeerCertificates()[0];
                return x509Certificate.getSubjectDN().getName();
            }
            case 104: {
                return sSLSession.getPeerCertificateChain();
            }
            case 106: {
                String string = (String)this.socketOptions.get(4);
                if (string == null) {
                    string = System.getProperty("oracle.net.ssl_server_dn_match", "false");
                }
                if (string.equalsIgnoreCase("YES") || string.equalsIgnoreCase("ON") || string.equalsIgnoreCase("TRUE")) {
                    X509Certificate x509Certificate = (X509Certificate)sSLSession.getPeerCertificates()[0];
                    String string2 = x509Certificate.getSubjectDN().getName();
                    if (TcpsConfigure.matchServerDN(string2, this.matchSSLServerCertDNWith, this.fullDNMatch)) {
                        return "TRUE";
                    }
                    return "FALSE";
                }
                return "TRUE";
            }
        }
        return super.getOption(n2);
    }

    public void setServerDNMatchValue(String[] stringArray) {
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string != null) {
            this.matchSSLServerCertDNWith = string;
            this.fullDNMatch = true;
        } else if (string2 != null) {
            this.matchSSLServerCertDNWith = string2.indexOf(46) != -1 ? "CN=" + string2.substring(0, string2.indexOf(46)) : "CN=" + string2.trim();
        } else if (string3 != null) {
            this.matchSSLServerCertDNWith = string3.indexOf(46) != -1 ? "CN=" + string3.substring(0, string3.indexOf(46)) : "CN=" + string3.trim();
        }
    }

    @Override
    public NTAdapter.NetworkAdapterType getNetworkAdapterType() {
        return NTAdapter.NetworkAdapterType.TCPS;
    }
}

