/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics.internal.cloudwatch;

import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.metrics.internal.cloudwatch.CloudWatchMetricConfig;
import com.amazonaws.metrics.internal.cloudwatch.DimensionComparator;
import com.amazonaws.metrics.internal.cloudwatch.MachineMetric;
import com.amazonaws.metrics.internal.cloudwatch.MachineMetricFactory;
import com.amazonaws.metrics.internal.cloudwatch.spi.Dimensions;
import com.amazonaws.services.cloudwatch.model.Dimension;
import com.amazonaws.services.cloudwatch.model.MetricDatum;
import com.amazonaws.services.cloudwatch.model.PutMetricDataRequest;
import com.amazonaws.services.cloudwatch.model.StatisticSet;
import com.amazonaws.util.AwsHostNameUtils;
import com.amazonaws.util.json.Jackson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

class BlockingRequestBuilder {
    private static final String OS_METRIC_NAME = MachineMetric.getOSMetricName();
    private final MachineMetricFactory machineMetricFactory = new MachineMetricFactory();
    private final BlockingQueue<MetricDatum> queue;
    private final long timeoutNano;

    BlockingRequestBuilder(CloudWatchMetricConfig config, BlockingQueue<MetricDatum> queue) {
        this.queue = queue;
        this.timeoutNano = TimeUnit.MILLISECONDS.toNanos(config.getQueuePollTimeoutMilli());
    }

    Iterable<PutMetricDataRequest> nextUploadUnits() throws InterruptedException {
        HashMap<String, MetricDatum> uniqueMetrics = new HashMap<String, MetricDatum>();
        long startNano = System.nanoTime();
        long elapsedNano;
        while ((elapsedNano = System.nanoTime() - startNano) < this.timeoutNano) {
            MetricDatum datum = this.queue.poll(this.timeoutNano - elapsedNano, TimeUnit.NANOSECONDS);
            if (datum == null) {
                if (uniqueMetrics.size() > 0) {
                    return this.toPutMetricDataRequests(uniqueMetrics);
                }
                if (AwsSdkMetrics.isMachineMetricExcluded()) {
                    datum = this.queue.take();
                    startNano = System.nanoTime();
                }
            }
            if (datum == null) continue;
            this.summarize(datum, uniqueMetrics);
        }
        return this.toPutMetricDataRequests(uniqueMetrics);
    }

    private void summarize(MetricDatum datum, Map<String, MetricDatum> uniqueMetrics) {
        Double value = datum.getValue();
        if (value == null) {
            return;
        }
        List dims = datum.getDimensions();
        Collections.sort(dims, DimensionComparator.INSTANCE);
        String metricName = datum.getMetricName();
        String key = metricName + Jackson.toJsonString(dims);
        MetricDatum statDatum = uniqueMetrics.get(key);
        if (statDatum == null) {
            statDatum = new MetricDatum().withDimensions((Collection)datum.getDimensions()).withMetricName(metricName).withUnit(datum.getUnit()).withStatisticValues(new StatisticSet().withMaximum(value).withMinimum(value).withSampleCount(Double.valueOf(0.0)).withSum(Double.valueOf(0.0)));
            uniqueMetrics.put(key, statDatum);
        }
        StatisticSet stat = statDatum.getStatisticValues();
        stat.setSampleCount(Double.valueOf(stat.getSampleCount() + 1.0));
        stat.setSum(Double.valueOf(stat.getSum() + value));
        if (value > stat.getMaximum()) {
            stat.setMaximum(value);
        } else if (value < stat.getMinimum()) {
            stat.setMinimum(value);
        }
    }

    private Iterable<PutMetricDataRequest> toPutMetricDataRequests(Map<String, MetricDatum> uniqueMetrics) {
        for (MetricDatum datum : this.machineMetricFactory.generateMetrics()) {
            this.summarize(datum, uniqueMetrics);
        }
        ArrayList<PutMetricDataRequest> list = new ArrayList<PutMetricDataRequest>();
        ArrayList<MetricDatum> data = new ArrayList<MetricDatum>();
        for (MetricDatum m : uniqueMetrics.values()) {
            data.add(m);
            if (data.size() != 20) continue;
            list.addAll(this.newPutMetricDataRequests(data));
            data.clear();
        }
        if (data.size() > 0) {
            list.addAll(this.newPutMetricDataRequests(data));
        }
        return list;
    }

    private List<PutMetricDataRequest> newPutMetricDataRequests(Collection<MetricDatum> data) {
        String jvmMetricName;
        ArrayList<PutMetricDataRequest> list = new ArrayList<PutMetricDataRequest>();
        String ns = AwsSdkMetrics.getMetricNameSpace();
        PutMetricDataRequest req = this.newPutMetricDataRequest(data, ns, new Dimension[0]);
        list.add(req);
        boolean perHost = AwsSdkMetrics.isPerHostMetricEnabled();
        String perHostNameSpace = null;
        String hostName = null;
        Dimension hostDim = null;
        boolean singleNamespace = AwsSdkMetrics.isSingleMetricNamespace();
        if (perHost) {
            hostName = AwsSdkMetrics.getHostMetricName();
            String string = hostName = hostName == null ? "" : hostName.trim();
            if (hostName.length() == 0) {
                hostName = AwsHostNameUtils.localHostName();
            }
            hostDim = this.dimension(Dimensions.Host, hostName);
            if (singleNamespace) {
                req = this.newPutMetricDataRequest(data, ns, hostDim);
            } else {
                perHostNameSpace = ns + "/" + hostName;
                req = this.newPutMetricDataRequest(data, perHostNameSpace, new Dimension[0]);
            }
            list.add(req);
        }
        if ((jvmMetricName = AwsSdkMetrics.getJvmMetricName()) != null && (jvmMetricName = jvmMetricName.trim()).length() > 0) {
            if (singleNamespace) {
                Dimension jvmDim = this.dimension(Dimensions.JVM, jvmMetricName);
                req = perHost ? this.newPutMetricDataRequest(this.filterOSMetrics(data), ns, hostDim, jvmDim) : this.newPutMetricDataRequest(data, ns, jvmDim);
            } else {
                String perJvmNameSpace = perHostNameSpace == null ? ns + "/" + jvmMetricName : perHostNameSpace + "/" + jvmMetricName;
                req = this.newPutMetricDataRequest(perHost ? this.filterOSMetrics(data) : data, perJvmNameSpace, new Dimension[0]);
            }
            list.add(req);
        }
        return list;
    }

    private Collection<MetricDatum> filterOSMetrics(Collection<MetricDatum> data) {
        ArrayList<MetricDatum> output = new ArrayList<MetricDatum>(data.size());
        for (MetricDatum datum : data) {
            if (OS_METRIC_NAME.equals(datum.getMetricName())) continue;
            output.add(datum);
        }
        return output;
    }

    private PutMetricDataRequest newPutMetricDataRequest(Collection<MetricDatum> data, String namespace, Dimension ... extraDims) {
        if (extraDims != null) {
            ArrayList<MetricDatum> newData = new ArrayList<MetricDatum>(data.size());
            for (MetricDatum md : data) {
                MetricDatum newMD = this.cloneMetricDatum(md);
                for (Dimension dim : extraDims) {
                    newMD.withDimensions(new Dimension[]{dim});
                }
                newData.add(newMD);
            }
            data = newData;
        }
        return (PutMetricDataRequest)new PutMetricDataRequest().withNamespace(namespace).withMetricData(data).withRequestMetricCollector(RequestMetricCollector.NONE);
    }

    final MetricDatum cloneMetricDatum(MetricDatum md) {
        return new MetricDatum().withDimensions((Collection)md.getDimensions()).withMetricName(md.getMetricName()).withStatisticValues(md.getStatisticValues()).withTimestamp(md.getTimestamp()).withUnit(md.getUnit()).withValue(md.getValue());
    }

    private Dimension dimension(Dimensions name, String value) {
        return new Dimension().withName(name.toString()).withValue(value);
    }
}

