/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.ColumnIndex;
import net.sf.jsqlparser.statement.select.ColumnReference;
import net.sf.jsqlparser.statement.select.ColumnReferenceVisitor;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.OrderByVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SelectItemVisitor;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.Top;
import net.sf.jsqlparser.statement.select.Union;

public class SelectDeParser
implements SelectVisitor,
OrderByVisitor,
SelectItemVisitor,
FromItemVisitor,
ColumnReferenceVisitor {
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;

    public SelectDeParser() {
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    public void visit(PlainSelect plainSelect) {
        SelectItem selectItem;
        Iterator iter;
        this.buffer.append("SELECT ");
        Top top = plainSelect.getTop();
        if (top != null) {
            top.toString();
        }
        if (plainSelect.getDistinct() != null) {
            this.buffer.append("DISTINCT ");
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                iter = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    selectItem = (SelectItem)iter.next();
                    selectItem.accept(this);
                    if (!iter.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        iter = plainSelect.getSelectItems().iterator();
        while (iter.hasNext()) {
            selectItem = (SelectItem)iter.next();
            selectItem.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(" ");
        if (plainSelect.getFromItem() != null) {
            this.buffer.append("FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            iter = plainSelect.getJoins().iterator();
            while (iter.hasNext()) {
                Join join = (Join)iter.next();
                this.deparseJoin(join);
            }
        }
        if (plainSelect.getWhere() != null) {
            this.buffer.append(" WHERE ");
            plainSelect.getWhere().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.buffer.append(" GROUP BY ");
            iter = plainSelect.getGroupByColumnReferences().iterator();
            while (iter.hasNext()) {
                ColumnReference columnReference = (ColumnReference)iter.next();
                columnReference.accept(this);
                if (!iter.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            this.deparseOrderBy(plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            this.deparseLimit(plainSelect.getLimit());
        }
    }

    public void visit(Union union) {
        Iterator iter = union.getPlainSelects().iterator();
        while (iter.hasNext()) {
            this.buffer.append("(");
            PlainSelect plainSelect = (PlainSelect)iter.next();
            plainSelect.accept(this);
            this.buffer.append(")");
            if (!iter.hasNext()) continue;
            this.buffer.append(" UNION ");
        }
        if (union.getOrderByElements() != null) {
            this.deparseOrderBy(union.getOrderByElements());
        }
        if (union.getLimit() != null) {
            this.deparseLimit(union.getLimit());
        }
    }

    public void visit(OrderByElement orderBy) {
        orderBy.getColumnReference().accept(this);
        if (orderBy.isAsc()) {
            this.buffer.append(" ASC");
        } else {
            this.buffer.append(" DESC");
        }
    }

    public void visit(Column column) {
        this.buffer.append(column.getWholeColumnName());
    }

    public void visit(ColumnIndex columnIndex) {
        this.buffer.append(columnIndex.getIndex());
    }

    public void visit(AllColumns allColumns) {
        this.buffer.append("*");
    }

    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(allTableColumns.getTable().getWholeTableName() + ".*");
    }

    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(" AS " + selectExpressionItem.getAlias());
        }
    }

    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this);
        this.buffer.append(")");
    }

    public void visit(Table tableName) {
        this.buffer.append(tableName.getWholeTableName());
        String alias = tableName.getAlias();
        if (alias != null && alias.trim().length() > 0) {
            this.buffer.append(" AS " + alias);
        }
    }

    public void deparseOrderBy(List orderByElements) {
        this.buffer.append(" ORDER BY ");
        Iterator iter = orderByElements.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = (OrderByElement)iter.next();
            orderByElement.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deparseLimit(Limit limit) {
        this.buffer.append(" LIMIT ");
        if (limit.isRowCountJdbcParameter()) {
            this.buffer.append("?");
        } else if (limit.getRowCount() != 0L) {
            this.buffer.append(limit.getRowCount());
        } else {
            this.buffer.append("18446744073709551615");
        }
        if (limit.isOffsetJdbcParameter()) {
            this.buffer.append(" OFFSET ?");
        } else if (limit.getOffset() != 0L) {
            this.buffer.append(" OFFSET " + limit.getOffset());
        }
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    public void visit(SubJoin subjoin) {
        this.buffer.append("(");
        subjoin.getLeft().accept(this);
        this.buffer.append(" ");
        this.deparseJoin(subjoin.getJoin());
        this.buffer.append(")");
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            if (join.isRight()) {
                this.buffer.append("RIGHT ");
            } else if (join.isNatural()) {
                this.buffer.append("NATURAL ");
            } else if (join.isFull()) {
                this.buffer.append("FULL ");
            } else if (join.isLeft()) {
                this.buffer.append("LEFT ");
            }
            if (join.isOuter()) {
                this.buffer.append("OUTER ");
            } else if (join.isInner()) {
                this.buffer.append("INNER ");
            }
            this.buffer.append("JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        if (join.getOnExpression() != null) {
            this.buffer.append(" ON ");
            join.getOnExpression().accept(this.expressionVisitor);
        }
        if (join.getUsingColumns() != null) {
            this.buffer.append(" USING ( ");
            Iterator iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                this.buffer.append(column.getWholeColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(" ,");
            }
            this.buffer.append(")");
        }
    }
}

