/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;

public final class CountdownInputStream
extends InputStream {
    private long m_count;
    private InputStream m_input;

    public CountdownInputStream(InputStream inputStream) {
        this.m_input = inputStream;
    }

    @Override
    public int read() throws IOException {
        if (this.m_count <= 0L) {
            return -1;
        }
        int n = this.m_input.read();
        if (n >= 0) {
            --this.m_count;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        int n2 = byArray.length;
        if ((long)n2 > this.m_count) {
            n2 = (int)this.m_count;
        }
        if ((n = this.m_input.read(byArray, 0, n2)) > 0) {
            this.m_count -= (long)n;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (this.m_count <= 0L) {
            return -1;
        }
        if ((long)n2 > this.m_count) {
            n2 = (int)this.m_count;
        }
        if ((n3 = this.m_input.read(byArray, n, n2)) > 0) {
            this.m_count -= (long)n3;
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
    }

    @Override
    public int available() throws IOException {
        return Math.min(this.m_input.available(), (int)Math.min(Integer.MAX_VALUE, this.m_count));
    }

    @Override
    public long skip(long l) throws IOException {
        return l <= 0L ? 0L : this.m_input.skip(Math.min(this.m_count, l));
    }

    public long getCount() {
        return this.m_count;
    }

    public void setCount(long l) {
        this.m_count = l;
    }
}

