/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionOp;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.Type;

public class ExpressionArithmetic
extends Expression {
    ExpressionArithmetic(int n, Expression expression, Expression expression2) {
        super(n);
        this.nodes = new Expression[2];
        this.nodes[0] = expression;
        this.nodes[1] = expression2;
        switch (this.opType) {
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    ExpressionArithmetic(int n, Expression expression) {
        super(n);
        this.nodes = new Expression[1];
        this.nodes[0] = expression;
        switch (this.opType) {
            case 31: {
                return;
            }
        }
        throw Error.runtimeError(201, "Expression");
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer(64);
        switch (this.opType) {
            case 1: {
                if (this.valueData == null) {
                    return "NULL";
                }
                if (this.dataType == null) {
                    throw Error.runtimeError(201, "Expression");
                }
                return this.dataType.convertToSQLString(this.valueData);
            }
        }
        String string = ExpressionArithmetic.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        String string2 = ExpressionArithmetic.getContextSQL(this.nodes.length > 1 ? this.nodes[1] : null);
        switch (this.opType) {
            case 87: {
                stringBuffer.append(' ').append("CAST").append('(');
                stringBuffer.append(string).append(' ').append("AS").append(' ');
                stringBuffer.append(this.dataType.getTypeDefinition());
                stringBuffer.append(')');
                break;
            }
            case 31: {
                stringBuffer.append('-').append(string);
                break;
            }
            case 32: {
                stringBuffer.append(string).append('+').append(string2);
                break;
            }
            case 33: {
                stringBuffer.append(string).append('-').append(string2);
                break;
            }
            case 34: {
                stringBuffer.append(string).append('*').append(string2);
                break;
            }
            case 35: {
                stringBuffer.append(string).append('/').append(string2);
                break;
            }
            case 36: {
                stringBuffer.append(string).append("||").append(string2);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        int n2;
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append('\n');
        for (n2 = 0; n2 < n; ++n2) {
            stringBuffer.append(' ');
        }
        switch (this.opType) {
            case 1: {
                stringBuffer.append("VALUE = ").append(this.dataType.convertToSQLString(this.valueData));
                stringBuffer.append(", TYPE = ").append(this.dataType.getNameString());
                return stringBuffer.toString();
            }
            case 25: 
            case 26: {
                stringBuffer.append("VALUELIST ");
                stringBuffer.append(" TYPE = ").append(this.dataType.getNameString());
                for (n2 = 0; n2 < this.nodes.length; ++n2) {
                    stringBuffer.append(this.nodes[n2].describe(session, n + n));
                    stringBuffer.append(' ');
                }
                break;
            }
            case 31: {
                stringBuffer.append("NEGATE ");
                break;
            }
            case 32: {
                stringBuffer.append("ADD ");
                break;
            }
            case 33: {
                stringBuffer.append("SUBTRACT ");
                break;
            }
            case 34: {
                stringBuffer.append("MULTIPLY ");
                break;
            }
            case 35: {
                stringBuffer.append("DIVIDE ");
                break;
            }
            case 36: {
                stringBuffer.append("CONCAT ");
                break;
            }
            case 87: {
                stringBuffer.append("CAST ");
                stringBuffer.append(this.dataType.getTypeDefinition());
                stringBuffer.append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuffer.append(" arg_left=[");
            stringBuffer.append(this.nodes[0].describe(session, n + 1));
            stringBuffer.append(']');
        }
        if (this.getRightNode() != null) {
            stringBuffer.append(" arg_right=[");
            stringBuffer.append(this.nodes[1].describe(session, n + 1));
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }

    @Override
    public HsqlList resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, HsqlList hsqlList, boolean bl) {
        if (this.opType == 1) {
            return hsqlList;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            hsqlList = this.nodes[i].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, hsqlList, bl);
        }
        return hsqlList;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.opType) {
            case 1: {
                break;
            }
            case 31: {
                if (this.nodes[0].isUnresolvedParam() || this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[0].dataType;
                if (!this.dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[0].opType != 1) break;
                this.setAsConstantValue(session, expression);
                break;
            }
            case 32: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isCharacterType() || this.nodes[1].dataType != null && this.nodes[1].dataType.isCharacterType()) {
                    this.opType = 36;
                    this.resolveTypesForConcat(session, expression);
                    break;
                }
            }
            case 33: 
            case 34: 
            case 35: {
                this.resolveTypesForArithmetic(session, expression);
                break;
            }
            case 36: {
                this.resolveTypesForConcat(session, expression);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Expression");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resolveTypesForArithmetic(Session session, Expression expression) {
        if (this.nodes[0].isUnresolvedParam() && this.nodes[1].isUnresolvedParam()) {
            this.nodes[0].dataType = Type.SQL_INTEGER;
            this.nodes[1].dataType = Type.SQL_INTEGER;
        }
        if (this.nodes[0].dataType == null && this.nodes[1].dataType == null) {
            this.nodes[0].dataType = Type.SQL_INTEGER;
            this.nodes[1].dataType = Type.SQL_INTEGER;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            if (this.nodes[1].dataType == null) {
                throw Error.error(5567);
            }
            if (this.nodes[1].dataType.isIntervalType() && expression != null) {
                block0 : switch (expression.opType) {
                    case 40: 
                    case 41: 
                    case 43: 
                    case 44: 
                    case 45: {
                        for (int i = 0; i < expression.nodes.length; ++i) {
                            if (expression.nodes[i] == this) continue;
                            if (expression.nodes[i].dataType == null || !expression.nodes[i].dataType.isDateTimeType()) break block0;
                            this.nodes[0].dataType = expression.nodes[i].dataType;
                            break block0;
                        }
                        break;
                    }
                }
            }
            if (this.nodes[0].dataType == null) {
                switch (this.opType) {
                    case 33: {
                        if (!this.nodes[1].dataType.isIntervalType()) break;
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                        break;
                    }
                    case 32: {
                        if (this.nodes[1].dataType.isDateTimeType()) {
                            if (this.nodes[1].dataType.typeComparisonGroup == 91) {
                                this.nodes[0].dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                                break;
                            }
                            this.nodes[0].dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                            break;
                        }
                        if (!this.nodes[1].dataType.isIntervalType()) break;
                        this.nodes[0].dataType = Type.SQL_TIMESTAMP_WITH_TIME_ZONE;
                        break;
                    }
                }
            }
            if (this.nodes[0].dataType == null) {
                this.nodes[0].dataType = this.nodes[1].dataType;
            }
        } else if (this.nodes[1].isUnresolvedParam()) {
            if (this.nodes[0].dataType == null) {
                throw Error.error(5567);
            }
            switch (this.opType) {
                case 34: 
                case 35: {
                    if (this.nodes[0].dataType.isIntervalType()) {
                        this.nodes[1].dataType = Type.SQL_DECIMAL;
                        break;
                    }
                    this.nodes[1].dataType = this.nodes[0].dataType;
                    break;
                }
                case 32: 
                case 33: {
                    if (this.nodes[0].dataType.isDateTimeType()) {
                        if (this.dataType != null && this.dataType.isIntervalType()) {
                            this.nodes[1].dataType = this.nodes[0].dataType;
                            break;
                        }
                        if (this.nodes[0].dataType.typeComparisonGroup == 91) {
                            this.nodes[1].dataType = Type.SQL_INTERVAL_YEAR_TO_MONTH_MAX_PRECISION;
                            break;
                        }
                        this.nodes[1].dataType = Type.SQL_INTERVAL_DAY_TO_SECOND_MAX_PRECISION;
                        break;
                    }
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
            }
        }
        if (this.nodes[0].dataType == null || this.nodes[1].dataType == null) {
            throw Error.error(5567);
        }
        if (this.opType == 33 && this.nodes[0].dataType.isDateTimeType() && this.nodes[1].dataType.isDateTimeType() && this.nodes[0].dataType.isDateTimeTypeWithZone() ^ this.nodes[1].dataType.isDateTimeTypeWithZone()) {
            if (this.nodes[0].dataType.isDateTimeTypeWithZone()) {
                this.nodes[0] = new ExpressionOp(this.nodes[0]);
            }
            if (this.nodes[1].dataType.isDateTimeTypeWithZone()) {
                this.nodes[1] = new ExpressionOp(this.nodes[1]);
            }
        }
        if (this.dataType != null && this.dataType.isIntervalType()) {
            if (this.nodes[0].dataType.isDateTimeType() && this.nodes[1].dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.typeComparisonGroup != this.nodes[1].dataType.typeComparisonGroup) {
                    throw Error.error(5562);
                }
            } else {
                Type type = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, this.opType);
                if (type == null) {
                    throw Error.error(5562);
                }
                if (type.isIntervalType()) {
                    if (type.typeCode != this.dataType.typeCode) {
                        throw Error.error(5562);
                    }
                } else {
                    if (!type.isNumberType()) throw Error.error(5562);
                    this.nodes[0] = new ExpressionOp(this.nodes[0], this.dataType);
                    this.nodes[1] = new ExpressionOp(this.nodes[1], this.dataType);
                    this.nodes[0].resolveTypes(session, this);
                    this.nodes[1].resolveTypes(session, this);
                }
            }
        } else {
            this.dataType = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, this.opType);
            if (this.dataType.isDateTimeType()) {
                if (this.nodes[0].dataType.isIntervalType()) {
                    if (this.opType != 32) {
                        throw Error.error(5563);
                    }
                    Expression expression2 = this.nodes[0];
                    this.nodes[0] = this.nodes[1];
                    this.nodes[1] = expression2;
                } else if (this.nodes[1].dataType.isNumberType() && !session.database.sqlSyntaxOra) {
                    throw Error.error(5562);
                }
            }
        }
        if (this.nodes[0].opType != 1 || this.nodes[1].opType != 1) return;
        this.setAsConstantValue(session, expression);
    }

    void resolveTypesForConcat(Session session, Expression expression) {
        Cloneable cloneable;
        if (this.dataType != null) {
            return;
        }
        if (this.nodes[0].isUnresolvedParam()) {
            this.nodes[0].dataType = this.getParameterType(this.nodes[1].dataType);
        } else if (this.nodes[1].isUnresolvedParam()) {
            this.nodes[1].dataType = this.getParameterType(this.nodes[0].dataType);
        }
        if (this.nodes[0].dataType == null) {
            this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[1].dataType == null) {
            this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
        }
        if (this.nodes[0].dataType.isBinaryType() ^ this.nodes[1].dataType.isBinaryType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isArrayType()) {
            cloneable = this.nodes[1];
            if (cloneable.opType == 95) {
                if (expression == null) {
                    throw Error.error(5563);
                }
                this.nodes[1] = cloneable.getLeftNode();
                cloneable.nodes[0] = this;
                expression.replaceNode(this, (Expression)cloneable);
            }
        }
        if (this.nodes[0].dataType.isArrayType() ^ this.nodes[1].dataType.isArrayType()) {
            throw Error.error(5563);
        }
        if (this.nodes[0].dataType.isCharacterType() && !this.nodes[1].dataType.isCharacterType()) {
            if (session.database.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            cloneable = CharacterType.getCharacterType(12, this.nodes[1].dataType.displaySize(), this.nodes[0].dataType.getCollation());
            this.nodes[1] = ExpressionOp.getCastExpression(session, this.nodes[1], (Type)cloneable);
        }
        if (this.nodes[1].dataType.isCharacterType() && !this.nodes[0].dataType.isCharacterType()) {
            if (session.database.sqlEnforceTypes) {
                throw Error.error(5562);
            }
            cloneable = CharacterType.getCharacterType(12, this.nodes[0].dataType.displaySize(), this.nodes[1].dataType.getCollation());
            this.nodes[0] = ExpressionOp.getCastExpression(session, this.nodes[0], (Type)cloneable);
        }
        this.dataType = this.nodes[0].dataType.getCombinedType(session, this.nodes[1].dataType, 36);
        if (this.nodes[0].opType == 1 && this.nodes[1].opType == 1) {
            this.setAsConstantValue(session, expression);
        }
    }

    private Type getParameterType(Type type) {
        if (type == null) {
            return null;
        }
        switch (type.typeCode) {
            case 1: 
            case 12: {
                return Type.SQL_VARCHAR_DEFAULT;
            }
            case 40: {
                return Type.SQL_CLOB;
            }
            case 60: 
            case 61: {
                return Type.SQL_VARBINARY_DEFAULT;
            }
            case 30: {
                return Type.SQL_BLOB;
            }
            case 14: 
            case 15: {
                return Type.SQL_BIT_VARYING_MAX_LENGTH;
            }
            case 50: {
                return type;
            }
        }
        return null;
    }

    @Override
    public Object getValue(Session session) {
        switch (this.opType) {
            case 1: {
                return this.valueData;
            }
            case 5: {
                Object object = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return object;
            }
            case 31: {
                return this.dataType.negate(this.nodes[0].getValue(session, this.nodes[0].dataType));
            }
        }
        Object object = this.nodes[0].getValue(session);
        Object object2 = this.nodes[1].getValue(session);
        switch (this.opType) {
            case 32: {
                return this.dataType.add(session, object, object2, this.nodes[1].dataType);
            }
            case 33: {
                return this.dataType.subtract(session, object, object2, this.nodes[1].dataType);
            }
            case 34: {
                return this.dataType.multiply(object, object2);
            }
            case 35: {
                return this.dataType.divide(session, object, object2);
            }
            case 36: {
                if (!session.database.sqlConcatNulls && this.nodes[0].dataType.isCharacterType()) {
                    if (object == null && object2 != null) {
                        object = "";
                    } else if (object != null && object2 == null) {
                        object2 = "";
                    }
                }
                return this.dataType.concat(session, object, object2);
            }
        }
        throw Error.runtimeError(201, "Expression");
    }
}

