/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.windows.WindowsBorders;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;
import javax.swing.plaf.metal.MetalToolBarUI;

public final class WindowsToolBarUI
extends MetalToolBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsToolBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("jgoodies.headerStyle") || string.equals("jgoodies.windows.borderStyle")) {
                    WindowsToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    private void installSpecialBorder() {
        String string;
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "jgoodies.windows.borderStyle");
        if (borderStyle == BorderStyle.EMPTY) {
            string = "emptyBorder";
        } else if (borderStyle == BorderStyle.SEPARATOR) {
            string = "separatorBorder";
        } else if (borderStyle == BorderStyle.ETCHED) {
            string = "etchedBorder";
        } else if (HeaderStyle.from(this.toolBar) == HeaderStyle.BOTH) {
            string = "headerBorder";
        } else {
            return;
        }
        LookAndFeel.installBorder(this.toolBar, "ToolBar." + string);
    }

    protected MouseInputListener createDockingListener() {
        return new BasicToolBarUI.DockingListener(this, this.toolBar);
    }

    protected Border createRolloverBorder() {
        return WindowsBorders.getRolloverButtonBorder();
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            super.setBorderToRollover(component);
        } else if (component instanceof Container) {
            Container container = (Container)component;
            for (int i = 0; i < container.getComponentCount(); ++i) {
                super.setBorderToRollover(container.getComponent(i));
            }
        }
    }
}

