/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.common;

import com.jgoodies.looks.Options;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;

public class MinimumSizedIcon
implements Icon {
    private final Icon icon;
    private final int width;
    private final int height;
    private final int xOffset;
    private final int yOffset;

    public MinimumSizedIcon() {
        this(null);
    }

    public MinimumSizedIcon(Icon icon) {
        Dimension dimension = Options.getDefaultIconSize();
        this.icon = icon;
        int n = icon == null ? 0 : icon.getIconWidth();
        int n2 = icon == null ? 0 : icon.getIconHeight();
        this.width = Math.max(n, Math.max(20, dimension.width));
        this.height = Math.max(n2, Math.max(20, dimension.height));
        this.xOffset = Math.max(0, (this.width - n) / 2);
        this.yOffset = Math.max(0, (this.height - n2) / 2);
    }

    public int getIconHeight() {
        return this.height;
    }

    public int getIconWidth() {
        return this.width;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.icon != null) {
            this.icon.paintIcon(component, graphics, n + this.xOffset, n2 + this.yOffset);
        }
    }
}

