/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.repository;

import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.repository.MetadataException;
import com.ibm.db2.cmx.runtime.internal.repository.api.ManagerFactory;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositorySetupManager;
import com.ibm.db2.cmx.runtime.internal.repository.api.RepositoryVersion;
import com.ibm.db2.cmx.runtime.internal.repository.manager.RepositoryVersionImpl;
import com.ibm.db2.cmx.runtime.internal.repository.metadata.loader.RepositorySetupException;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import com.ibm.db2.cmx.tools.internal.repository.DefaultActionProcessor;
import com.ibm.db2.cmx.tools.internal.repository.ManageRepositoryUtility;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class UpgradeActionProcessor
extends DefaultActionProcessor {
    @Override
    public PureQueryUtility.UtilityResult processAction(PossibleArgs possibleArgs, ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, RepositoryVersion repositoryVersion, PrintWriter printWriter) throws MetadataException, IOException, RepositorySetupException, SQLException {
        PureQueryUtility.UtilityResult utilityResult = null;
        PossibleArgs.PredefinedOptionValues predefinedOptionValues = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.UPGRADE);
        if (predefinedOptionValues != null && PossibleArgs.PredefinedOptionValues.REPOSITORY.compareTo(predefinedOptionValues) == 0) {
            utilityResult = this.upgradeRepository(artifactOptionsSet, connection, string, printWriter);
        }
        return utilityResult;
    }

    private PureQueryUtility.UtilityResult upgradeRepository(ArtifactOptionsSet artifactOptionsSet, Connection connection, String string, PrintWriter printWriter) throws MetadataException, IOException, RepositorySetupException, SQLException {
        PureQueryUtility.UtilityResult utilityResult = null;
        ManagerFactory.prepareConnection(connection, false, string);
        RepositorySetupManager repositorySetupManager = ManagerFactory.getRepositorySetupManager(connection);
        RepositoryVersion repositoryVersion = repositorySetupManager.getRepositoryVersion(string);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        boolean bl2 = false;
        String string2 = null;
        try {
            string2 = databaseMetaData.getDatabaseProductName().toUpperCase();
            bl2 = string2.startsWith("INFORMIX") || string2.startsWith("IDS");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (repositoryVersion == null) {
            String string3 = databaseMetaData.getURL();
            string3 = StaticProfileConstants.maskJdbcURLPasswords(string3);
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.MR_SKIP);
            utilityResult.reason = Messages.getText("ERR_REPOSITORY_DOES_NOT_EXIST", new Object[]{string3.substring(string3.lastIndexOf("/") + 1, string3.length()), string3, string, PossibleArgs.REPOSITORY_SCHEMA});
            return utilityResult;
        }
        RepositoryVersionImpl repositoryVersionImpl = new RepositoryVersionImpl("com.ibm.pureQuery", repositoryVersion.getVersion(), repositoryVersion.getRelease(), repositoryVersion.getMod());
        int n2 = RepositoryVersion.currentVersion.compareTo(repositoryVersionImpl);
        if (n2 == 0) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_MANAGEREPOSITORY_CURRENT_VERSION", "" + repositoryVersion.getVersion() + "." + repositoryVersion.getRelease() + "." + repositoryVersion.getMod());
            return utilityResult;
        }
        if (n2 < 0) {
            utilityResult = new PureQueryUtility.UtilityResult(PureQueryUtility.UtilityResultType.SKIP);
            utilityResult.reason = Messages.getText("MSG_MANAGEREPOSITORY_NEWER_VERSION", "" + repositoryVersion.getVersion() + "." + repositoryVersion.getRelease() + "." + repositoryVersion.getMod(), "" + RepositoryVersion.currentVersion.getVersion() + "." + RepositoryVersion.currentVersion.getRelease() + "." + RepositoryVersion.currentVersion.getMod());
            return utilityResult;
        }
        FileWriter fileWriter = null;
        ArrayList<String> arrayList = null;
        boolean bl3 = true;
        String string4 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GENERATE_SCRIPT_ONLY);
        if (string4 != null) {
            fileWriter = new FileWriter(string4);
            arrayList = new ArrayList<String>();
            bl3 = false;
        }
        utilityResult = repositorySetupManager.getScriptOrExecuteRepositoryUpgrade(string, repositoryVersion, databaseMetaData, bl2, bl3, arrayList, printWriter);
        if (!bl3) {
            ManageRepositoryUtility.writeCommandScript(repositorySetupManager.addStmtTerminator(arrayList), fileWriter, databaseMetaData);
        }
        return utilityResult;
    }
}

