/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder.parser;

import com.ibm.db.parsers.sql.db2.luw.modelgen.DB2LUWModelgenDML;
import com.ibm.db.parsers.sql.db2.luw.parser.DB2LUWParseControllerFactory;
import com.ibm.db.parsers.sql.db2.modelgen.DB2CommentHandler;
import com.ibm.db.parsers.sql.db2.zos.modelgen.DB2ZOSModelgenDML;
import com.ibm.db.parsers.sql.db2.zos.parser.DB2ZOSParseControllerFactory;
import com.ibm.db.parsers.sql.parser.ISQLCommentHandler;
import com.ibm.db.parsers.sql.parser.ISQLParseActionHandler;
import com.ibm.db.parsers.sql.parser.ISQLParseController;
import com.ibm.db.parsers.sql.parser.ISQLParseController2;
import com.ibm.db.parsers.sql.parser.ISQLParseMessageHandler;
import com.ibm.db.parsers.sql.parser.SQLParseMessage;
import com.ibm.db.parsers.sql.parser.SQLParseMessageHandlerDefault;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.parser.ISQLParser;
import com.ibm.db2.jcc.DB2Connection;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.PredicateComparisonOperator;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionBody;
import org.eclipse.datatools.modelbase.sql.query.QueryExpressionRoot;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombined;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionCombinedOperator;
import org.eclipse.datatools.modelbase.sql.query.SearchConditionNested;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.TableReference;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionCast;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionNested;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionRow;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionSimple;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;

public class SQLParser
implements ISQLParser {
    private ISQLParseController parseController_ = null;
    private SQLParseMessageHandlerDefault msgHandler_ = null;
    private Connection con_ = null;
    private DatabaseMetaData dbMD_ = null;
    static Logger logger__ = ToolsLogger.getLogger();

    @Override
    public boolean isSqlParserInitialized() {
        return this.parseController_ != null;
    }

    @Override
    public void resetParser() {
        this.parseController_ = null;
    }

    @Override
    public void initDatabase(DB2Connection dB2Connection) throws SQLException {
        if (this.con_ != dB2Connection) {
            this.con_ = dB2Connection;
            this.dbMD_ = this.con_.getMetaData();
        }
    }

    @Override
    public void initParser(StaticProfileConstants.DBInfo dBInfo) {
        boolean bl2;
        String string = ";";
        boolean bl3 = bl2 = StaticProfileConstants.DatabaseType.DB2forZOS == dBInfo.databaseType_;
        if (bl2) {
            this.parseController_ = DB2ZOSParseControllerFactory.createParseControllerLatestVersion();
            SQLParseMessageHandlerDefault sQLParseMessageHandlerDefault = new SQLParseMessageHandlerDefault();
            this.parseController_.setParseMessageHandler((ISQLParseMessageHandler)sQLParseMessageHandlerDefault);
            this.parseController_.setStatementTerminator(string);
            DB2ZOSModelgenDML dB2ZOSModelgenDML = new DB2ZOSModelgenDML();
            this.parseController_.setParseActionHandler((ISQLParseActionHandler)dB2ZOSModelgenDML);
            DB2CommentHandler dB2CommentHandler = null;
            if (this.parseController_ instanceof ISQLParseController2) {
                dB2CommentHandler = new DB2CommentHandler();
                ((ISQLParseController2)this.parseController_).setCommentHandler((ISQLCommentHandler)dB2CommentHandler);
            }
        } else {
            this.parseController_ = DB2LUWParseControllerFactory.createParseControllerLatestVersion();
            SQLParseMessageHandlerDefault sQLParseMessageHandlerDefault = new SQLParseMessageHandlerDefault();
            this.parseController_.setParseMessageHandler((ISQLParseMessageHandler)sQLParseMessageHandlerDefault);
            this.parseController_.setStatementTerminator(string);
            DB2LUWModelgenDML dB2LUWModelgenDML = new DB2LUWModelgenDML();
            this.parseController_.setParseActionHandler((ISQLParseActionHandler)dB2LUWModelgenDML);
            DB2CommentHandler dB2CommentHandler = null;
            if (this.parseController_ instanceof ISQLParseController2) {
                dB2CommentHandler = new DB2CommentHandler();
                ((ISQLParseController2)this.parseController_).setCommentHandler((ISQLCommentHandler)dB2CommentHandler);
            }
        }
        this.msgHandler_ = (SQLParseMessageHandlerDefault)this.parseController_.getParseMessageHandler();
    }

    @Override
    public boolean isSingletonSelect(String string, String string2) {
        block31: {
            if (logger__.isLoggable(Level.FINE)) {
                logger__.log(Level.FINE, "Enter: Parameters ( " + string + " , " + string2 + ")");
            }
            BaseTable baseTable = null;
            Schema schema = null;
            String string3 = null;
            Object object = null;
            QueryStatement queryStatement = null;
            ResultSet resultSet = null;
            try {
                object = SQLParser.parseSQL(string, this.parseController_);
                if (object != null) {
                    queryStatement = SQLParser.processParseResult(object);
                    if (queryStatement != null && !(queryStatement instanceof QuerySelectStatement)) {
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "Skipping single row optimization of statement that is not a SELECT query: " + string);
                        }
                        return false;
                    }
                    if (queryStatement == null) {
                        return false;
                    }
                    QuerySelectStatement querySelectStatement = (QuerySelectStatement)queryStatement;
                    QueryExpressionRoot queryExpressionRoot = querySelectStatement.getQueryExpr();
                    QueryExpressionBody queryExpressionBody = queryExpressionRoot.getQuery();
                    if (queryExpressionBody instanceof QuerySelect) {
                        TableInDatabase tableInDatabase;
                        Table table;
                        QuerySelect querySelect = (QuerySelect)queryExpressionBody;
                        EList eList = querySelect.getFromClause();
                        if (eList.size() != 1) {
                            if (logger__.isLoggable(Level.FINE)) {
                                logger__.log(Level.FINE, "Analysis: Cannot be optimized; the FROM clause either has no TableReferences, or it has more than one.");
                            }
                            return false;
                        }
                        TableReference tableReference = (TableReference)eList.get(0);
                        if (tableReference instanceof TableInDatabase && (table = (tableInDatabase = (TableInDatabase)tableReference).getDatabaseTable()) != null && table instanceof BaseTable) {
                            baseTable = (BaseTable)table;
                            schema = baseTable.getSchema();
                            string3 = schema == null || schema.getName() == null ? string2 : schema.getName();
                            QuerySearchCondition querySearchCondition = querySelect.getWhereClause();
                            ArrayList<String> arrayList = this.analyzePredicate(querySearchCondition, null);
                            if (logger__.isLoggable(Level.FINE)) {
                                if (arrayList == null || arrayList != null && arrayList.size() == 0) {
                                    logger__.log(Level.FINE, "Analysis: single-table query, on " + string3 + "." + baseTable.getName() + " With no usable <column> = <constant> predicates");
                                } else {
                                    String string4 = arrayList.get(0);
                                    for (int i10 = 1; i10 < arrayList.size(); ++i10) {
                                        string4 = string4 + ", " + arrayList.get(i10);
                                    }
                                    logger__.log(Level.FINE, "Analysis: single-table query, on " + string3 + "." + baseTable.getName() + " With <column> = <constant> predicates for [" + string4 + "]");
                                }
                            }
                            if (arrayList != null && arrayList.size() > 0) {
                                resultSet = this.dbMD_.getIndexInfo(null, string3, baseTable.getName(), true, false);
                                int n2 = 0;
                                String string5 = null;
                                String string6 = null;
                                boolean bl2 = true;
                                while (resultSet.next()) {
                                    ++n2;
                                    string5 = resultSet.getString("INDEX_NAME");
                                    if (string5 == null) continue;
                                    if (string6 == null) {
                                        string6 = string5;
                                    }
                                    if (!string5.equals(string6)) {
                                        if (bl2) {
                                            logger__.log(Level.FINE, "INDEX NAME " + string6 + " is fully specified");
                                            resultSet.close();
                                            return true;
                                        }
                                        bl2 = true;
                                    }
                                    string6 = string5;
                                    if (arrayList.contains(resultSet.getString("COLUMN_NAME"))) continue;
                                    bl2 = false;
                                }
                                resultSet.close();
                                resultSet = null;
                                if (n2 < 1) {
                                    logger__.log(Level.FINE, "No metadata found for UNIQUE indices on Table " + string3 + "." + baseTable.getName());
                                    return false;
                                }
                                if (string5 != null) {
                                    if (bl2) {
                                        logger__.log(Level.FINE, "INDEX NAME " + string5 + " is fully specified");
                                        return true;
                                    }
                                } else if (string6 != null && bl2) {
                                    logger__.log(Level.FINE, "INDEX NAME " + string6 + " is fully specified");
                                    return true;
                                }
                                if (logger__.isLoggable(Level.FINEST)) {
                                    logger__.log(Level.FINEST, "Analysis: no usable index found for given <column> names");
                                }
                            }
                        }
                    } else if (logger__.isLoggable(Level.FINE)) {
                        logger__.log(Level.FINE, "Analysis: " + queryExpressionBody.getClass().getSimpleName() + " Cannot be optimized; only Objects of type QuerySelect are supported.");
                    }
                }
            }
            catch (Exception exception) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                if (!logger__.isLoggable(Level.FINE)) break block31;
                logger__.log(Level.FINE, "Exception encountered: " + exception.getMessage());
            }
        }
        return false;
    }

    private static Object parseSQL(String string, ISQLParseController iSQLParseController) {
        Object object;
        block5: {
            object = null;
            try {
                object = iSQLParseController.parse(string);
            }
            catch (Exception exception) {
                if (!logger__.isLoggable(Level.FINE)) break block5;
                logger__.log(Level.FINE, "Exception encountered: " + exception.getMessage());
            }
        }
        SQLParseMessageHandlerDefault sQLParseMessageHandlerDefault = (SQLParseMessageHandlerDefault)iSQLParseController.getParseMessageHandler();
        if (object == null || sQLParseMessageHandlerDefault.getParseMessageList() != null && sQLParseMessageHandlerDefault.getParseMessageList().size() > 0) {
            List list;
            String string2 = "Parse Error";
            if (sQLParseMessageHandlerDefault != null && (list = sQLParseMessageHandlerDefault.getParseMessageList()) != null && list.size() > 0) {
                string2 = ((SQLParseMessage)list.get(0)).getMessageText();
            }
            if (logger__.isLoggable(Level.FINE)) {
                logger__.log(Level.FINE, "SQL parsing indicates error: " + string2);
            }
        }
        return object;
    }

    private static QueryStatement processParseResult(Object object) {
        List list;
        QueryStatement queryStatement = null;
        if (object instanceof List && (list = (List)object) != null && list.size() > 0 && list.get(0) instanceof QueryStatement) {
            queryStatement = (QueryStatement)list.get(0);
        }
        if (queryStatement == null && logger__.isLoggable(Level.FINE)) {
            logger__.log(Level.FINE, "SQL parsing failed, with no model returned");
        }
        return queryStatement;
    }

    private ArrayList<String> analyzePredicate(QuerySearchCondition querySearchCondition, ArrayList<String> arrayList) {
        if (querySearchCondition == null) {
            return arrayList;
        }
        if (querySearchCondition instanceof PredicateBasic) {
            arrayList = SQLParser.processPredicateBasic((PredicateBasic)querySearchCondition, arrayList);
            return arrayList;
        }
        if (querySearchCondition instanceof SearchConditionCombined) {
            SearchConditionCombined searchConditionCombined = (SearchConditionCombined)querySearchCondition;
            SearchConditionCombinedOperator searchConditionCombinedOperator = searchConditionCombined.getCombinedOperator();
            if ("AND".equals(searchConditionCombinedOperator.getName())) {
                QuerySearchCondition querySearchCondition2 = searchConditionCombined.getLeftCondition();
                QuerySearchCondition querySearchCondition3 = searchConditionCombined.getRightCondition();
                arrayList = this.analyzePredicate(querySearchCondition2, arrayList);
                arrayList = this.analyzePredicate(querySearchCondition3, arrayList);
            }
            return arrayList;
        }
        if (querySearchCondition instanceof SearchConditionNested) {
            SearchConditionNested searchConditionNested = (SearchConditionNested)querySearchCondition;
            if (!searchConditionNested.isNegatedCondition()) {
                QuerySearchCondition querySearchCondition4 = searchConditionNested.getNestedCondition();
                arrayList = this.analyzePredicate(querySearchCondition4, arrayList);
            }
            return arrayList;
        }
        if (logger__.isLoggable(Level.FINE)) {
            logger__.log(Level.FINE, " Predicate Analysis: " + querySearchCondition.getClass().getSimpleName() + " halts analysis; only SearchConditionCombined, SearchConditionNested (non-negated), and PredicateBasic are examined.");
        }
        return arrayList;
    }

    private static ArrayList<String> processPredicateBasic(PredicateBasic predicateBasic, ArrayList<String> arrayList) {
        QueryValueExpression queryValueExpression;
        PredicateComparisonOperator predicateComparisonOperator = predicateBasic.getComparisonOperator();
        if (predicateComparisonOperator != null && !"EQUAL".equals(predicateComparisonOperator.getName())) {
            if (logger__.isLoggable(Level.ALL)) {
                logger__.log(Level.ALL, "Not an EQUALs predicate: " + predicateComparisonOperator.getLiteral());
            }
            return arrayList;
        }
        QueryValueExpression queryValueExpression2 = predicateBasic.getLeftValueExpr();
        if (queryValueExpression2 instanceof ValueExpressionNested) {
            queryValueExpression2 = ((ValueExpressionNested)queryValueExpression2).getNestedValueExpr();
        }
        if ((queryValueExpression = predicateBasic.getRightValueExpr()) instanceof ValueExpressionNested) {
            queryValueExpression = ((ValueExpressionNested)queryValueExpression).getNestedValueExpr();
        }
        if (queryValueExpression2 instanceof ValueExpressionRow && queryValueExpression instanceof ValueExpressionRow) {
            EList eList = ((ValueExpressionRow)queryValueExpression2).getValueExprList();
            EList eList2 = ((ValueExpressionRow)queryValueExpression).getValueExprList();
            for (int i10 = 0; i10 < eList.size(); ++i10) {
                arrayList = SQLParser.processLeftRightPair(arrayList, (QueryValueExpression)eList.get(i10), (QueryValueExpression)eList2.get(i10));
            }
        } else {
            arrayList = SQLParser.processLeftRightPair(arrayList, queryValueExpression2, queryValueExpression);
        }
        return arrayList;
    }

    private static ArrayList<String> processLeftRightPair(ArrayList<String> arrayList, QueryValueExpression queryValueExpression, QueryValueExpression queryValueExpression2) {
        ValueExpressionColumn valueExpressionColumn = null;
        ValueExpressionColumn valueExpressionColumn2 = null;
        if (queryValueExpression instanceof ValueExpressionNested) {
            queryValueExpression = ((ValueExpressionNested)queryValueExpression).getNestedValueExpr();
        }
        if (queryValueExpression2 instanceof ValueExpressionNested) {
            queryValueExpression2 = ((ValueExpressionNested)queryValueExpression2).getNestedValueExpr();
        }
        if (queryValueExpression instanceof ValueExpressionColumn) {
            valueExpressionColumn = (ValueExpressionColumn)queryValueExpression;
        }
        if (queryValueExpression2 instanceof ValueExpressionColumn) {
            valueExpressionColumn2 = (ValueExpressionColumn)queryValueExpression2;
        }
        if (valueExpressionColumn == null && valueExpressionColumn2 == null || valueExpressionColumn != null && valueExpressionColumn2 != null) {
            return arrayList;
        }
        if (valueExpressionColumn != null) {
            arrayList = SQLParser.processColumnExpressionPair(arrayList, valueExpressionColumn, queryValueExpression2);
        } else if (valueExpressionColumn2 != null) {
            arrayList = SQLParser.processColumnExpressionPair(arrayList, valueExpressionColumn2, queryValueExpression);
        }
        return arrayList;
    }

    private static ArrayList<String> processColumnExpressionPair(ArrayList<String> arrayList, ValueExpressionColumn valueExpressionColumn, QueryValueExpression queryValueExpression) {
        QueryValueExpression queryValueExpression2;
        ValueExpressionSimple valueExpressionSimple = null;
        if (queryValueExpression instanceof ValueExpressionSimple) {
            valueExpressionSimple = (ValueExpressionSimple)queryValueExpression;
        } else if (queryValueExpression instanceof ValueExpressionCast && (queryValueExpression2 = ((ValueExpressionCast)queryValueExpression).getValueExpr()) instanceof ValueExpressionSimple) {
            valueExpressionSimple = (ValueExpressionSimple)queryValueExpression2;
        }
        if (valueExpressionSimple != null) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(valueExpressionColumn.getName());
            } else if (!arrayList.contains(valueExpressionColumn.getName())) {
                arrayList.add(valueExpressionColumn.getName());
            }
        }
        return arrayList;
    }
}

