/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.db.ConnectionInfoHelper;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlCaptureTimeProperties;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PDQXmlConnection
implements XmlExporter {
    private String connectionURL_;
    private String connectionUserName_;
    private String connectionSchema_;
    private PDQXmlCaptureTimeProperties captureTimeProperties_;

    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("connection");
        xmlBuf.addElement("urlString", this.connectionURL_);
        xmlBuf.startElement("url");
        xmlBuf.addElement("ipName", this.getIpName());
        xmlBuf.addElement("port", this.getPort());
        xmlBuf.addElement("databaseName", this.getDbName());
        xmlBuf.addElement("properties", this.getProperties());
        xmlBuf.endElement();
        xmlBuf.addElement("connectionUserName", this.connectionUserName_);
        xmlBuf.addElement("connectionSchema", this.connectionSchema_);
        if (null == this.captureTimeProperties_) {
            this.captureTimeProperties_ = new PDQXmlCaptureTimeProperties();
        }
        xmlBuf.addBranch(this.captureTimeProperties_);
        xmlBuf.endElement();
        return xmlBuf.toString();
    }

    private String getIpName() {
        if (this.connectionURL_ == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("jdbc:db2://(.*?):.*?/.*");
        Matcher matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile("jdbc:db2://(.*?)/.*");
        matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getPort() {
        if (this.connectionURL_ == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("jdbc:db2://.*?:(.*?)/.*");
        Matcher matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getDbName() {
        if (this.connectionURL_ == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("jdbc:db2://.*?/(.*?):.*");
        Matcher matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        pattern = Pattern.compile("jdbc:db2://.*?/(.*?)");
        matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getProperties() {
        if (this.connectionURL_ == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("jdbc:db2://.*?/.*?:(.*?)");
        Matcher matcher = pattern.matcher(this.connectionURL_);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    @Deprecated
    public void init(DatabaseMetaData databaseMetaData) throws SQLException {
        this.init(databaseMetaData, (short)21);
    }

    public void init(DatabaseMetaData databaseMetaData, short s2) throws SQLException {
        this.connectionUserName_ = databaseMetaData.getUserName();
        this.connectionSchema_ = ConnectionInfoHelper.getConnectionSchema(databaseMetaData.getConnection(), null);
        this.connectionURL_ = databaseMetaData.getURL();
        this.captureTimeProperties_ = new PDQXmlCaptureTimeProperties(s2);
    }

    public String getConnectionURL() {
        return this.connectionURL_;
    }

    public void setConnectionURL(String string) {
        this.connectionURL_ = string;
    }

    public String getConnectionUserName() {
        return this.connectionUserName_;
    }

    public void setConnectionUserName(String string) {
        this.connectionUserName_ = string;
    }

    public String getConnectionSchema() {
        return this.connectionSchema_;
    }

    public void setConnectionSchema(String string) {
        this.connectionSchema_ = string;
    }
}

