/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.client.ConnectionProxy;
import com.ibm.db2.cmx.internal.metadata.DataBeanStatementExecution;
import com.ibm.db2.cmx.internal.metadata.DataBeanTransactionExecution;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.internal.monitor.MonitorAgentImpl;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.proxy.PDQProxy;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcDataSource;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxiedJdbcStatementInvocationHandler;
import com.ibm.db2.cmx.runtime.internal.proxy.ProxyCache;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.ExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.wrappers.JDBCDynamicExecutionHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ProxiedJdbcConnectionInvocationHandler
implements ConnectionProxy,
InvocationHandler,
PDQProxy {
    protected ExecutionHandler connectionExecutionHandler_;
    protected Connection wrappedConnection_;
    protected boolean isMonitoringEnabled_;
    protected MonitorAgent monitorAgent_;
    protected int commitRollbackCount_ = 0;
    protected String userName_;
    public DataBeanTransactionExecution transactionBean_;
    protected ProxiedJdbcDataSource proxiedDataSource_;
    protected boolean autoCommit_ = true;
    private Object connectionProxy_;
    public Set<ProxiedJdbcStatementInvocationHandler> commitAndRollbackListeners_ = Collections.synchronizedSet(new HashSet());
    protected static Logger logger__ = Log.getCMXClientLogger();
    protected boolean isOCMEnabled_;
    protected boolean isInUOW_ = false;
    protected long lastDatabaseVersion_ = -1L;
    protected long lastPhysicalLocationChangeVersion_ = -1L;
    protected long lastDataSrcProfileVersion_ = -1L;
    protected static final int ZOS_MAX_LENGTH = 900000;
    protected static final int IDS_MAX_LENGTH = 17000;
    protected static final int OTHER_MAX_LENGTH = Integer.MAX_VALUE;
    protected int maxBytesUsedforHash_ = 0;

    public ProxiedJdbcConnectionInvocationHandler(Connection connection, ExecutionHandler executionHandler, MonitorAgent monitorAgent, String string, ProxiedJdbcDataSource proxiedJdbcDataSource, String string2, String string3) {
        this.wrappedConnection_ = connection;
        this.monitorAgent_ = monitorAgent;
        this.userName_ = string;
        this.proxiedDataSource_ = proxiedJdbcDataSource;
        this.isMonitoringEnabled_ = proxiedJdbcDataSource.isMonitoring();
        this.isOCMEnabled_ = proxiedJdbcDataSource.isOCMEnabled();
        this.lastDatabaseVersion_ = proxiedJdbcDataSource.getOcmDatabaseVersion();
        this.lastPhysicalLocationChangeVersion_ = proxiedJdbcDataSource.getOcmLastPhysicalLocationChangeVersion();
        this.lastDataSrcProfileVersion_ = proxiedJdbcDataSource.getOcmLastDataSrcProfileVersion();
        this.transactionBean_ = new DataBeanTransactionExecution();
        this.extractAutoCommitValue();
        this.connectionExecutionHandler_ = executionHandler;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "<init>", "connection proxy created for: " + connection);
        }
        this.maxBytesUsedforHash_ = string3.startsWith("DSN") ? 900000 : (string3.startsWith("IDS") ? 17000 : Integer.MAX_VALUE);
    }

    public void extractAutoCommitValue() {
        try {
            this.autoCommit_ = this.wrappedConnection_.getAutoCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        Object object2 = null;
        String string = method.getName();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "invoke: " + string, "ENTRY " + Arrays.deepToString(objectArray));
        }
        char c10 = string.charAt(0);
        try {
            switch (c10) {
                case 'c': 
                case 'p': {
                    if (ProxiedJdbcConnectionInvocationHandler.isStatementExecutionHandlerWrapperRequired(string)) {
                        if (c10 != 'c') {
                            this.applyDynamicPushDownProperties();
                        }
                        this.startTransactionIfNotStartedAndMonitoringIsEnabled();
                        object2 = this.createStatementProxy(string, method, false, objectArray);
                        break;
                    }
                    if (string.equals("pushData")) {
                        this.pushData((Integer)objectArray[0], (Object[])objectArray[1], true);
                        break;
                    }
                    if (string.equals("commit")) {
                        this.invokeMethodAndDoTransactionBoundryLogic(method, objectArray, string, false);
                        break;
                    }
                    if (string.equals("close")) {
                        WeakHashMap<Object, Object> weakHashMap;
                        WeakHashMap<Object, Object> weakHashMap2;
                        try {
                            this.invokeMethodAndDoTransactionBoundryLogic(method, objectArray, string, true);
                            if (this.proxiedDataSource_ != null) {
                                this.proxiedDataSource_.refCount(false);
                            }
                            weakHashMap = weakHashMap2 = this.proxiedDataSource_.getActiveConnectionInvocationHandlers();
                        }
                        catch (Throwable throwable) {
                            WeakHashMap<Object, Object> weakHashMap3;
                            WeakHashMap<Object, Object> weakHashMap4 = weakHashMap3 = this.proxiedDataSource_.getActiveConnectionInvocationHandlers();
                            synchronized (weakHashMap4) {
                                weakHashMap3.remove(this);
                            }
                            throw throwable;
                        }
                        synchronized (weakHashMap) {
                            weakHashMap2.remove(this);
                            break;
                        }
                    }
                    object2 = this.invokeMethod(method, objectArray, string);
                    break;
                }
                case 'e': {
                    if (string.equals("equals")) {
                        return this.equals(objectArray[0]);
                    }
                    object2 = this.invokeMethod(method, objectArray, string);
                    break;
                }
                case 'r': {
                    if (string.equals("rollback")) {
                        this.invokeMethodAndDoTransactionBoundryLogic(method, objectArray, string, true);
                        break;
                    }
                    object2 = this.invokeMethod(method, objectArray, string);
                    break;
                }
                case 's': {
                    if (string.equals("setAutoCommit")) {
                        this.invokeMethod(method, objectArray, string);
                        this.extractAutoCommitValue();
                        break;
                    }
                    object2 = this.invokeMethod(method, objectArray, string);
                    break;
                }
                default: {
                    object2 = this.invokeMethod(method, objectArray, string);
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                if (this.transactionBean_ != null) {
                    this.transactionBean_.setFirstErrorCode(((SQLException)throwable).getErrorCode());
                }
                this.proxiedDataSource_.checkAndReportApplnException((SQLException)throwable);
            }
            DataLogger.logThrowable(logger__, throwable);
            throw throwable;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 10609);
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "invoke: " + string, object2);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeMethodAndDoTransactionBoundryLogic(Method method, Object[] objectArray, String string, boolean bl2) throws Throwable {
        try {
            this.invokeMethod(method, objectArray, string);
        }
        finally {
            this.doTransactionBoundaryLogic(bl2);
            this.markEndTransaction();
        }
    }

    private Object invokeMethod(Method method, Object[] objectArray, String string) throws Throwable {
        if (this.connectionExecutionHandler_ != null) {
            return this.connectionExecutionHandler_.invoke(string, method, objectArray);
        }
        return method.invoke((Object)this.wrappedConnection_, objectArray);
    }

    public void startTransactionIfNotStartedAndMonitoringIsEnabled() {
        if (this.isMonitoringEnabled_ && !this.transactionBean_.transactionStarted()) {
            this.transactionBean_.beginTransaction();
            this.initializeTransactionBeanIdentifierFields_();
        }
    }

    synchronized void doTransactionBoundaryLogic(boolean bl2) {
        if (this.isMonitoringEnabled_) {
            Iterator<ProxiedJdbcStatementInvocationHandler> iterator = this.commitAndRollbackListeners_.iterator();
            while (iterator.hasNext()) {
                ProxiedJdbcStatementInvocationHandler proxiedJdbcStatementInvocationHandler = iterator.next();
                if (proxiedJdbcStatementInvocationHandler.resultSetHoldability_ != 2 && (!bl2 || proxiedJdbcStatementInvocationHandler.resultSetHoldability_ != 1)) continue;
                if (proxiedJdbcStatementInvocationHandler.statementBean_.statementTimerStarted()) {
                    proxiedJdbcStatementInvocationHandler.statementBean_.stopTimer(true);
                }
                proxiedJdbcStatementInvocationHandler.getDriverData_();
                proxiedJdbcStatementInvocationHandler.getPureQueryData();
                this.transactionBean_.addStatementExecution(proxiedJdbcStatementInvocationHandler.statementBean_);
                proxiedJdbcStatementInvocationHandler.statementBean_ = new DataBeanStatementExecution(proxiedJdbcStatementInvocationHandler.statementBean_);
                iterator.remove();
            }
            if (this.transactionBean_.statementExecutions_.size() > 0) {
                this.reportTransaction_();
            }
        }
        this.updateMonitorSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMonitorSettings() {
        ProxiedJdbcConnectionInvocationHandler proxiedJdbcConnectionInvocationHandler = this;
        synchronized (proxiedJdbcConnectionInvocationHandler) {
            this.monitorAgent_ = this.proxiedDataSource_.getUpdatedMonitorAgent();
            this.isMonitoringEnabled_ = this.proxiedDataSource_.isMonitoring();
            this.updateMonitorSettingsOnDriver_();
        }
    }

    protected abstract ClientInfo getClientInfo();

    protected abstract void updateMonitorSettingsOnDriver_();

    @Override
    public void pushData(int n2, Object[] objectArray, boolean bl2) {
        if (n2 == 110 && this.transactionBean_ != null) {
            this.transactionBean_.wasGetConnectionData_ = objectArray;
        }
    }

    protected abstract void reportTransaction_();

    protected abstract void resetTransaction_();

    protected abstract void initializeTransactionBeanIdentifierFields_();

    private Object createStatementProxy(String string, Method method, boolean bl2, Object[] objectArray) throws IllegalAccessException, InvocationTargetException, Throwable {
        ExecutionHandler executionHandler = null;
        Object object = null;
        executionHandler = (ExecutionHandler)this.connectionExecutionHandler_.invoke(string, method, objectArray);
        object = executionHandler.getUnderlyingObject();
        ProxiedJdbcStatementInvocationHandler proxiedJdbcStatementInvocationHandler = this.createProxiedJdbcStatementInvocationHandler_(executionHandler, bl2);
        Object object2 = ProxyCache.createInstance(object, proxiedJdbcStatementInvocationHandler);
        proxiedJdbcStatementInvocationHandler.setStatementProxy(object2);
        return object2;
    }

    protected abstract ProxiedJdbcStatementInvocationHandler createProxiedJdbcStatementInvocationHandler_(ExecutionHandler var1, boolean var2);

    protected ExecutionHandler createStatementExecutionHandler_(Object object) {
        return new JDBCDynamicExecutionHandler(object);
    }

    public void reportStatementExecution(DataBeanStatementExecution dataBeanStatementExecution) {
        this.transactionBean_.addStatementExecution(dataBeanStatementExecution);
        if (this.autoCommit_) {
            this.doTransactionBoundaryLogic(false);
        }
    }

    public void getMonitorInfo(StringBuilder stringBuilder) {
        if (this.monitorAgent_ != null && !this.monitorAgent_.isConnectionActive()) {
            try {
                this.monitorAgent_.getConnection();
            }
            catch (Exception exception) {
                stringBuilder.append(" monitorAgent.getConnection - " + exception.toString());
            }
        }
        if (!this.isMonitoringEnabled_) {
            stringBuilder.append("  Client monitoring is not enabled.\n");
        }
        if (this.monitorAgent_ == null || !this.monitorAgent_.isConnectionActive()) {
            stringBuilder.append("  No monitor connection.\n");
        } else {
            stringBuilder.append(((MonitorAgentImpl)this.monitorAgent_).getMonitorInfo());
        }
    }

    public void getMonitorProperties(StringBuilder stringBuilder) {
        this.proxiedDataSource_.getResolvedMonitorInfo(stringBuilder);
    }

    public void getControllerInfo(StringBuilder stringBuilder) {
        this.proxiedDataSource_.getControllerInfo(stringBuilder);
    }

    public Connection getWrappedConnection() {
        return this.wrappedConnection_;
    }

    public Object getConnectionProxy() {
        return this.connectionProxy_;
    }

    public void setConnectionProxy(Object object) {
        this.connectionProxy_ = object;
    }

    public boolean equals(Object object) {
        return this == object || this.connectionProxy_ == object;
    }

    public int getMaxBytesUsedforHash_() {
        return this.maxBytesUsedforHash_;
    }

    public Properties getConnectionSpecificPropertiesWithRedirect() {
        if (this.connectionExecutionHandler_ != null && ConnectionExecutionHandler.class.isAssignableFrom(this.connectionExecutionHandler_.getClass())) {
            return ((ConnectionExecutionHandler)this.connectionExecutionHandler_).getConnectionSpecificPropertiesWithRedirect();
        }
        return null;
    }

    public void writeCentralStoreInformation(StringBuilder stringBuilder) {
        if (this.connectionExecutionHandler_ != null && ConnectionExecutionHandler.class.isAssignableFrom(this.connectionExecutionHandler_.getClass())) {
            ((ConnectionExecutionHandler)this.connectionExecutionHandler_).writeCentralStoreInformation(stringBuilder);
        }
    }

    @Override
    public String maskClientUser(String string) {
        if (this.monitorAgent_ != null) {
            return this.monitorAgent_.maskClientUser(string);
        }
        return string;
    }

    @Override
    public String maskClientWorkstation(String string) {
        if (this.monitorAgent_ != null) {
            return this.monitorAgent_.maskClientWorkstation(string);
        }
        return string;
    }

    @Override
    public String maskClientApplicationInformation(String string) {
        if (this.monitorAgent_ != null) {
            return this.monitorAgent_.maskClientApplicationInformation(string);
        }
        return string;
    }

    @Override
    public String maskClientAccountingInformation(String string) {
        if (this.monitorAgent_ != null) {
            return this.monitorAgent_.maskClientAccountingInformation(string);
        }
        return string;
    }

    public static boolean isStatementExecutionHandlerWrapperRequired(String string) {
        char c10 = string.charAt(0);
        if (c10 == 'p' && (string.equals("prepareStatement") || string.equals("prepareCall") || string.equals("preparePDQStaticStatement") || string.equals("preparePDQStaticCallStatement") || string.equals("preparePDQStatement") || string.equals("prepareSQLJCall") || string.equals("prepareSQLJStatement"))) {
            return true;
        }
        return string.equals("createStatement") || string.equals("createPDQStatement");
    }

    public void markBeginTransaction() {
        this.isInUOW_ = true;
    }

    public void markEndTransaction() {
        this.isInUOW_ = false;
    }

    protected boolean isInsideTransaction() {
        return this.isInUOW_;
    }

    protected void applyDynamicPushDownProperties() {
        if (!this.isInsideTransaction()) {
            this.markBeginTransaction();
        }
    }
}

