/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.monitor;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.core.ServerImpl;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.monitor.MonitorProcessorAS;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.server.CMXServerException;
import com.ibm.db2.cmx.server.EventHandler;
import com.ibm.db2.cmx.server.Monitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

public class MonitorServerImpl
extends ServerImpl
implements Monitor {
    public final String CLASS_NAME = "MonitorServer";
    public MonitorProcessorAS monitorProcessor_ = null;
    boolean monitorIdRequired_;
    private int[] supportedKeyTypes_ = null;
    private List<String[]> registeredKeys_ = new ArrayList<String[]>();
    private String[] monitorServerIPs_ = null;
    private String controllerURL_ = null;
    private ControllerAgent registrationInstance_ = null;
    private ControllerAgent httpRegistrationInstance_ = null;

    private void monitorServerInitialize(int n2, int n3) {
        this.checkExtendedInsightLicense();
        this.monitorProcessor_ = new MonitorProcessorAS(n2, n3);
        this.setProcessors(new Processor[]{this.monitorProcessor_});
        if (logger__.isLoggable(Level.FINE)) {
            JSONArray jSONArray = new JSONArray();
            if (this.supportedKeyTypes_ != null) {
                for (int i10 = 0; i10 < this.supportedKeyTypes_.length; ++i10) {
                    jSONArray.add((Object)this.supportedKeyTypes_[i10]);
                }
            }
            DataLogger.logConnectedComponents(logger__, this, "init", "Monitor state: monitorIdRequired: " + this.monitorIdRequired_ + ", supportedKeyTypes: " + jSONArray + " minClientLevel: " + this.monitorProcessor_.minClientLevel_ + " maxClientLevel: " + this.monitorProcessor_.maxClientLevel_);
        }
    }

    public MonitorServerImpl(String string, String string2, String[] stringArray, int n2, boolean bl2, int n3, int n4) {
        super(n2, bl2, "MonitorServer");
        this.controllerURL_ = string;
        this.monitorServerIPs_ = stringArray;
        if (string != null) {
            this.registrationInstance_ = Service.getControllerAgentForRegistration(string);
        }
        if (string2 != null) {
            this.httpRegistrationInstance_ = Service.getControllerAgentForRegistration(string2);
        }
        this.monitorServerInitialize(n3, n4);
    }

    private void checkExtendedInsightLicense() {
        if (!Configuration.isExtendedInsightLicensed__) {
            throw ExceptionFactory.createLicenseExceptionForRuntimeOrTools(Messages.getText("ERR_EI_NOT_LICENSED", new Object[0]), null, 10643);
        }
    }

    @Override
    public void registerEventHandler(EventHandler eventHandler) {
        this.monitorProcessor_.register(eventHandler);
    }

    @Override
    public void start() throws CMXServerException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "start");
        }
        super.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        block11: {
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.enter(logger__, this, "shutdown");
            }
            super.shutdown();
            List<String[]> list = this.registeredKeys_;
            synchronized (list) {
                for (int i10 = 0; i10 < this.registeredKeys_.size(); ++i10) {
                    String[] stringArray = this.registeredKeys_.get(i10);
                    try {
                        if (this.registrationInstance_ != null) {
                            this.registrationInstance_.deregisterMonitorDataSource(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), stringArray[3], stringArray[4], 0);
                        }
                        if (this.httpRegistrationInstance_ == null) continue;
                        this.httpRegistrationInstance_.deregisterMonitorDataSource(stringArray[0], stringArray[1], Integer.parseInt(stringArray[2]), stringArray[3], stringArray[4], 0);
                        continue;
                    }
                    catch (Exception exception) {
                        if (!logger__.isLoggable(Level.FINEST)) continue;
                        DataLogger.logTrappedMonitoringException(logger__, this, "shutdown", exception, exception.getMessage());
                    }
                }
            }
            try {
                if (this.registrationInstance_ != null) {
                    this.registrationInstance_.close();
                }
            }
            catch (Exception exception) {
                if (!logger__.isLoggable(Level.FINEST)) break block11;
                DataLogger.logTrappedMonitoringException(logger__, this, "shutdown", exception, exception.getMessage());
            }
        }
    }

    @Override
    public void registerMonitoredDataSource(String string, boolean bl2, int n2, int n3, int[] nArray, String[] stringArray, int n4) throws CMXException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, bl2, n2, n3, nArray, stringArray, n4}));
        }
        this.registerMonitoredDataSource(string, null, null, 0, null, bl2, n2, n3, this.monitorIdRequired_, nArray, stringArray, null, n4);
    }

    @Override
    public void registerMonitoredDataSource(String string, int n2, String string2, boolean bl2, int n3, int n4, int[] nArray, String[] stringArray, int n5) throws CMXException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, n2, string2, bl2, n3, n4, nArray, stringArray, n5}));
        }
        this.registerMonitoredDataSource(null, string, null, n2, string2, bl2, n3, n4, this.monitorIdRequired_, nArray, stringArray, null, n5);
    }

    @Override
    public void registerMonitoredDatabase(String string, String string2, Object[] objectArray, boolean bl2, int n2, int n3, int[] nArray, String[] stringArray, int n4) throws CMXException {
        throw new CMXException(100);
    }

    @Override
    public void registerMonitoredDataSource(String[] stringArray, int n2, String string, boolean bl2, int n3, int n4, int[] nArray, String[] stringArray2, int n5) throws CMXException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{stringArray, n2, string, bl2, n3, n4, nArray, stringArray2, n5}));
        }
        String string2 = null;
        if (stringArray != null && stringArray.length > 0) {
            string2 = stringArray[0];
        }
        this.registerMonitoredDataSource(null, string2, stringArray, n2, string, bl2, n3, n4, this.monitorIdRequired_, nArray, stringArray2, null, n5);
    }

    @Override
    public void registerMonitoredLocation(String string, boolean bl2, int n2, int n3, int[] nArray, String[] stringArray, int n4) throws CMXException {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitoredLocation", "ENTRY " + Arrays.deepToString(new Object[]{string, bl2, n2, n3, nArray, stringArray, n4}));
        }
        this.registerMonitoredDataSource(null, null, null, 0, null, bl2, n2, n3, this.monitorIdRequired_, nArray, stringArray, string, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMonitoredDataSource(String string, String string2, String[] stringArray, int n2, String string3, boolean bl2, int n3, int n4, boolean bl3, int[] nArray, String[] stringArray2, String string4, int n5) throws CMXException {
        if (this.controllerURL_ == null) {
            throw new CMXException(3);
        }
        try {
            this.registrationInstance_.registerMonitorDataSource(string, string2, stringArray, n2, string3, this.monitorServerIPs_ != null ? this.monitorServerIPs_ : this.adjustMonitorIPs(), this.port_, bl2 ? 1 : 2, n3, n4, bl3, nArray, stringArray2, string4, n5, 0);
            if (this.httpRegistrationInstance_ != null) {
                this.httpRegistrationInstance_.registerMonitorDataSource(string, string2, stringArray, n2, string3, this.monitorServerIPs_ != null ? this.monitorServerIPs_ : this.adjustMonitorIPs(), this.port_, bl2 ? 1 : 2, n3, n4, bl3, nArray, stringArray2, string4, n5, 0);
            }
            List<String[]> list = this.registeredKeys_;
            synchronized (list) {
                this.registeredKeys_.add(new String[]{string, string2, Integer.toString(n2), string3, string4});
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage(), exception);
        }
    }

    private String[] adjustMonitorIPs() {
        int n2 = -1;
        String[] stringArray = null;
        String string = null;
        int n3 = 0;
        if (this.controllerURL_ != null) {
            String string2 = this.controllerURL_;
            if (string2.startsWith("http://") && string2.length() > 7) {
                string2 = string2.substring(7);
            } else if (string2.startsWith("https://") && string2.length() > 8) {
                string2 = string2.substring(8);
            }
            int n4 = string2.lastIndexOf(58);
            if (n4 > 0) {
                string2 = string2.substring(0, n4);
            }
            string = Configuration.resolveToIPAddress(string2);
            for (int i10 = 0; i10 < Configuration.myHostAddresses__.length; ++i10) {
                if (!string.equals(Configuration.myHostAddresses__[i10])) continue;
                n2 = i10;
                break;
            }
        }
        if (n2 > -1) {
            stringArray = new String[Configuration.myHostAddresses__.length];
            stringArray[n3++] = string;
            for (int i11 = 0; i11 < Configuration.myHostAddresses__.length; ++i11) {
                if (i11 == n2) continue;
                stringArray[n3++] = Configuration.myHostAddresses__[i11];
            }
            Configuration.traceMonitorIPs(logger__, "adjustMonitorIPs", stringArray);
            return stringArray;
        }
        Configuration.traceMonitorIPs(logger__, "adjustMonitorIPs", Configuration.myHostAddresses__);
        return Configuration.myHostAddresses__;
    }

    @Override
    public String[] getRegisteredIPs() {
        int n2 = Configuration.myHostAddresses__.length;
        String[] stringArray = null;
        if (this.monitorServerIPs_ != null) {
            stringArray = new String[n2];
            System.arraycopy(this.adjustMonitorIPs(), 0, stringArray, 0, n2);
        } else {
            stringArray = new String[this.monitorServerIPs_.length];
            System.arraycopy(this.monitorServerIPs_, 0, stringArray, 0, this.monitorServerIPs_.length);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterMonitoredDataSource(String string, String string2, int n2, String string3, String string4) {
        List<String[]> list = this.registeredKeys_;
        synchronized (list) {
            block8: {
                Object[] objectArray = null;
                Object[] objectArray2 = null;
                Object[] objectArray3 = null;
                int n3 = -1;
                objectArray = new String[]{string, string2, Integer.toString(n2), string3, string4};
                objectArray3 = this.registeredKeys_.toArray();
                for (int i10 = 0; i10 < this.registeredKeys_.size(); ++i10) {
                    objectArray2 = (String[])objectArray3[i10];
                    if (!Arrays.equals(objectArray, objectArray2)) continue;
                    n3 = i10;
                    break;
                }
                if (n3 != -1) {
                    try {
                        this.registrationInstance_.deregisterMonitorDataSource((String)objectArray2[0], (String)objectArray2[1], Integer.parseInt((String)objectArray2[2]), (String)objectArray2[3], (String)objectArray2[4], 1);
                        if (this.httpRegistrationInstance_ != null) {
                            this.httpRegistrationInstance_.deregisterMonitorDataSource((String)objectArray2[0], (String)objectArray2[1], Integer.parseInt((String)objectArray2[2]), (String)objectArray2[3], (String)objectArray2[4], 1);
                        }
                    }
                    catch (Exception exception) {
                        if (!logger__.isLoggable(Level.FINEST)) break block8;
                        DataLogger.logTrappedMonitoringException(logger__, this, "deregisterMonitoredDataSource", exception, exception.getMessage());
                    }
                }
            }
        }
    }

    @Override
    public void deregisterMonitoredDataSource(String string, int n2, String string2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterMonitoredDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, n2, string2}));
        }
        this.deregisterMonitoredDataSource(null, string, n2, string2, null);
    }

    @Override
    public void deregisterMonitoredDataSource(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterMonitoredDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        this.deregisterMonitoredDataSource(string, null, 0, null, null);
    }

    @Override
    public void deregisterMonitoredLocation(String string) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterMonitoredDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        this.deregisterMonitoredDataSource(null, null, 0, null, string);
    }
}

