/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.json4j;

import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONArtifact;
import com.ibm.db2.cmx.internal.json4j.Parser;
import com.ibm.db2.cmx.internal.json4j.Serializer;
import com.ibm.db2.cmx.internal.json4j.SerializerVerbose;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;

public class JSONObject
extends HashMap
implements JSONArtifact {
    private static final long serialVersionUID = -3269263069889337298L;

    public static boolean isValidObject(Object object) {
        if (null == object) {
            return true;
        }
        return JSONObject.isValidType(object.getClass());
    }

    public static boolean isValidType(Class clazz) {
        if (null == clazz) {
            throw new IllegalArgumentException();
        }
        if (String.class == clazz) {
            return true;
        }
        if (Boolean.class == clazz) {
            return true;
        }
        if (JSONObject.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (JSONArray.class == clazz) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz);
    }

    public static JSONObject parse(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse();
    }

    public static JSONObject parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return JSONObject.parse(stringReader);
    }

    public static JSONObject parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return JSONObject.parse(inputStreamReader);
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        this.serialize(outputStream, false);
    }

    @Override
    public void serialize(OutputStream outputStream, boolean bl2) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            IOException iOException = new IOException(unsupportedEncodingException.toString());
            iOException.initCause(unsupportedEncodingException);
            throw iOException;
        }
        this.serialize(bufferedWriter, bl2);
    }

    @Override
    public void serialize(Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        this.serialize(writer, false);
    }

    @Override
    public void serialize(Writer writer, boolean bl2) throws IOException {
        Serializer serializer = bl2 ? new SerializerVerbose(writer) : new Serializer(writer);
        serializer.writeObject(this).flush();
    }

    @Override
    public String serialize(boolean bl2) throws IOException {
        StringWriter stringWriter = new StringWriter();
        Serializer serializer = bl2 ? new SerializerVerbose(stringWriter) : new Serializer(stringWriter);
        serializer.writeObject(this).flush();
        return stringWriter.toString();
    }

    @Override
    public String serialize() throws IOException {
        return this.serialize(false);
    }

    @Override
    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!JSONObject.isValidObject(object2)) {
            if (object2 != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + object2.getClass().getName() + "] with value: [" + object2.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        return super.put(object, object2);
    }

    @Override
    public String toString() {
        String string = null;
        try {
            string = this.serialize(false);
        }
        catch (IOException iOException) {
            string = "JSON Generation Error: [" + iOException.toString() + "]";
        }
        return string;
    }
}

