/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.CMXBuildInterface;
import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.ProductInformation;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransactionRule;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.impl.CMXImplMessageHelper;
import com.ibm.db2.cmx.impl.Utils;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.controller.NPXControllerAgentImpl;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.metadata.ClientProfileUtil;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.jcc.am.GlobalProperties;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ControlDriver {
    private static Logger logger__ = Log.getCMXClientLogger();
    private static ControlDriver instance__ = new ControlDriver();
    private ControllerAgent controllerAgent_;
    private Map<String, Object> driverDescriptorMap_ = new HashMap<String, Object>();
    private Profile.Driver driverProfile_ = null;
    private RegisterDriverLookup registerDriverTimerTask_;
    private LogStatisticsLookup logStatisticsTimerTask_;
    private int registerDriverInterval_ = 120;
    private int logStatisticsInterval_ = 900;
    private Map<String, Database> databasesMap_ = null;
    private int lookupReplyFlag_ = 0;
    private ProductInformation.Server serverProductInformation_ = null;
    private boolean staticDriverLevelPropertiesApplied_ = false;
    private Thread shutdownHook_ = null;
    private boolean isShutdownProcessing_ = false;
    private long lastAppliedDriverProfileVersion_ = -1L;
    public static final int ROLLBACK_VERSION = -1;
    private boolean bSendPushDownApp_ = false;
    private Map<Integer, Connection> connectionMap = null;

    private ControlDriver() {
        this.driverDescriptorMap_.put("driverDescriptorUUID", DataProperties.getProperty("pdq.cmx.uuid"));
        this.driverDescriptorMap_.put("driverDescriptorClientIP", Configuration.myHostAddresses__);
        ProductInformation.Basic.BuildCertification buildCertification = null;
        switch (Configuration.JCCReleaseCertification__) {
            case 1: {
                buildCertification = ProductInformation.Basic.BuildCertification.testBuild;
                break;
            }
            case 2: {
                buildCertification = ProductInformation.Basic.BuildCertification.betaBuild;
                break;
            }
            default: {
                buildCertification = ProductInformation.Basic.BuildCertification.releaseBuild;
            }
        }
        this.driverDescriptorMap_.put("driverKind", ProductInformation.Driver.DriverKind.JCC.toString());
        this.driverDescriptorMap_.put("driverName", Configuration.JCCDriverName__);
        this.driverDescriptorMap_.put("driverMajorVersion", Configuration.JCCMajorVersion__);
        this.driverDescriptorMap_.put("driverMinorVersion", Configuration.JCCMinorVersion__);
        this.driverDescriptorMap_.put("driverMicroVersion", Configuration.JCCBuildNumber__);
        this.driverDescriptorMap_.put("driverBuildQualifier", "0");
        this.driverDescriptorMap_.put("driverBuildCertification", buildCertification.toString());
        this.driverDescriptorMap_.put("cmxComponentName", "CMX");
        this.driverDescriptorMap_.put("cmxMajorVersion", 11);
        this.driverDescriptorMap_.put("cmxMinorVersion", 0);
        this.driverDescriptorMap_.put("cmxMicroVersion", 0);
        this.driverDescriptorMap_.put("cmxBuildQualifier", CMXBuildInterface.cmxBuildQualifier__);
        this.driverDescriptorMap_.put("cmxBuildCertification", CMXBuildInterface.cmxBuildCertification__.toString());
        this.driverDescriptorMap_.put("cmxSpecVersion", 100);
        this.driverDescriptorMap_.put("wasServerName", null);
        this.driverDescriptorMap_.put("wasServerVersion", null);
        this.driverDescriptorMap_.put("driverDescriptorClientPropertySettings", this.getDriverProperties());
        this.driverProfile_ = this.getEmptyDriverProfile();
        this.databasesMap_ = new HashMap<String, Database>();
        this.connectionMap = new HashMap<Integer, Connection>();
    }

    private HashMap getDriverProperties() {
        HashMap hashMap = null;
        HashMap hashMap2 = new HashMap();
        Map.Entry entry2 = null;
        if (Configuration.isJCCAtCMX5ProtocolLevel__) {
            hashMap = (HashMap)GlobalProperties.pullData(5000)[0];
        }
        for (Map.Entry entry2 : hashMap.entrySet()) {
            String string = (String)entry2.getKey();
            if (!string.startsWith(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX)) {
                String string2 = ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX + string;
                String string3 = ClientProfileUtil.JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX + string;
                String string4 = ClientProfileUtil.JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX + string;
                if (hashMap.containsKey(string2) || hashMap.containsKey(string3) || hashMap.containsKey(string4)) continue;
                hashMap2.put(string2, entry2.getValue());
                continue;
            }
            hashMap2.put(string, entry2.getValue());
        }
        return hashMap2;
    }

    Profile.Driver getEmptyDriverProfile() {
        return new Profile.Driver(null, -1L, null, null, null, null, null, null, 120, 900, 1000);
    }

    public synchronized boolean staticDriverPropertiesApplied() {
        boolean bl2 = this.staticDriverLevelPropertiesApplied_;
        if (!this.staticDriverLevelPropertiesApplied_) {
            this.staticDriverLevelPropertiesApplied_ = true;
        }
        return bl2;
    }

    public synchronized boolean getStaticDriverProfileApplied() {
        return this.staticDriverLevelPropertiesApplied_;
    }

    public synchronized void setStaticDriverProfileApplied() {
        this.staticDriverLevelPropertiesApplied_ = true;
    }

    public static ControlDriver getInstance() {
        return instance__;
    }

    void setServerProductInformation(ProductInformation.Server server) {
        this.serverProductInformation_ = server;
    }

    public ProductInformation.Server getServerProductInformation() {
        return this.serverProductInformation_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDriverDescriptorMapWithWASData(String string, String string2) {
        Map<String, Object> map = this.driverDescriptorMap_;
        synchronized (map) {
            this.driverDescriptorMap_.put("wasServerName", string);
            this.driverDescriptorMap_.put("wasServerVersion", string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getDriverDescriptorMap() {
        Map<String, Object> map = this.driverDescriptorMap_;
        synchronized (map) {
            return this.driverDescriptorMap_;
        }
    }

    Map<String, Database> getDatabasesMap() {
        return this.databasesMap_;
    }

    void setLookupReplyFlag(int n2) {
        this.lookupReplyFlag_ = n2;
    }

    int getLookupReplyFlag() {
        return this.lookupReplyFlag_;
    }

    private void initializeControllerAgent() throws Exception {
        if (this.controllerAgent_ == null) {
            Object object;
            String string = DataProperties.getProperty("pdq.cmx.http.controllerURL");
            if (Service.getControllerType(string) != Service.ControllerType.OCM && Service.getControllerType(string) != Service.ControllerType.NPX) {
                Exception exception = new Exception(Messages.getText("ERR_OCM_INVALID_HTTP_CONTROLLER_URL", "pdq.cmx.http.controllerURL", string));
                DataLogger.lowImpactLogger(logger__, this, "initializeControllerAgent", "initializeControllerAgent failed ", exception);
                throw exception;
            }
            this.controllerAgent_ = Service.getControllerAgent(string, false);
            if (Service.getControllerType(string) == Service.ControllerType.NPX) {
                object = (NPXControllerAgentImpl)this.controllerAgent_;
                ((NPXControllerAgentImpl)object).setConnectionMap(this.connectionMap);
            }
            if (!this.controllerAgent_.isConnected()) {
                object = new Exception(Messages.getText("ERR_OCM_UNABLE_TO_CONNECT_TO_HTTP_CONTROLLER", "pdq.cmx.http.controllerURL", string));
                DataLogger.lowImpactLogger(logger__, this, "initializeControllerAgent", "Unable to connect using controllerAgent  ", (Throwable)object);
                throw object;
            }
        }
    }

    synchronized void initializeRegisterDriverTask() {
        if (this.registerDriverTimerTask_ == null) {
            this.registerDriverTimerTask_ = new RegisterDriverLookup();
            ControlDataSourcePool.getInstance().scheduleLookupTask(this.registerDriverTimerTask_, this.registerDriverInterval_ * 1000, this.registerDriverInterval_ * 1000);
        }
    }

    synchronized void initializeLogStatisticsTask() {
        if (this.logStatisticsTimerTask_ == null) {
            this.logStatisticsTimerTask_ = new LogStatisticsLookup();
            ControlDataSourcePool.getInstance().scheduleLookupTask(this.logStatisticsTimerTask_, 0L, this.logStatisticsInterval_ * 1000);
        }
    }

    synchronized void setRegisterDriverInterval(int n2) {
        if (n2 > 0 && n2 != this.registerDriverInterval_) {
            if (this.registerDriverInterval_ > 0 && this.registerDriverTimerTask_ != null) {
                this.registerDriverTimerTask_.cancel();
                this.registerDriverTimerTask_ = null;
            }
            this.registerDriverInterval_ = n2;
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "setRegisterDriverInterval", "Setting new lookup interval: " + n2);
            }
            this.initializeRegisterDriverTask();
        }
    }

    synchronized void setLogStatisticsInterval(int n2) {
        if (n2 > 0 && n2 != this.logStatisticsInterval_) {
            if (this.logStatisticsInterval_ > 0 && this.logStatisticsTimerTask_ != null) {
                this.logStatisticsTimerTask_.cancel();
                this.logStatisticsTimerTask_ = null;
            }
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "setLogStatisticsInterval", "Setting new lookup interval: " + n2);
            }
            this.logStatisticsInterval_ = n2;
            this.initializeLogStatisticsTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo createRegisterDriverRequest() {
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.driverDescriptorMap_.get("driverId") == null || this.lookupReplyFlag_ == 2) {
            return new RequestInfo(controllerMessageHelper.createRegisterDriverRequest(this.driverDescriptorMap_, null, null, -1L, 12), "4", null, null);
        }
        String string = null;
        long l10 = -1L;
        Profile.Driver driver = this.driverProfile_;
        synchronized (driver) {
            string = this.driverProfile_.getName();
            l10 = this.driverProfile_.getVersion();
        }
        return new RequestInfo(controllerMessageHelper.createRegisterDriverRequest(null, (String)this.driverDescriptorMap_.get("driverId"), string, l10, 12), "4", null, null);
    }

    private RequestInfo createLookupDatabaseRequest(String string, long l10) {
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        return new RequestInfo(controllerMessageHelper.createLookupDatabaseRequest(string, l10, 12), "5", string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo createRegisterDataSourceRequest(ControlDataSourceImpl controlDataSourceImpl) {
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (controlDataSourceImpl.getDataSourceDescriptorMap().get("dataSourceId") == null || controlDataSourceImpl.getLookupReplyFlag() == 2) {
            return new RequestInfo(controllerMessageHelper.createRegisterDataSourceRequest(controlDataSourceImpl.getDataSourceDescriptorMap(), null, null, -1L, (String)controlDataSourceImpl.getDataSourceDescriptorMap().get("dsDescriptorDBServer"), (Integer)controlDataSourceImpl.getDataSourceDescriptorMap().get("dsDescriptorDBPort"), (String)controlDataSourceImpl.getDataSourceDescriptorMap().get("dsDescriptorDBName"), 12), "6", null, controlDataSourceImpl);
        }
        String string = null;
        long l10 = -1L;
        Profile.DataSource dataSource = controlDataSourceImpl.getDataSourceProfile();
        synchronized (dataSource) {
            string = controlDataSourceImpl.getDataSourceProfile().getName();
            l10 = controlDataSourceImpl.getDataSourceProfile().getVersion();
        }
        return new RequestInfo(controllerMessageHelper.createRegisterDataSourceRequest(null, controlDataSourceImpl.getDataSourceId(), string, l10, null, -1, null, 12), "6", null, controlDataSourceImpl);
    }

    private RequestInfo createLookupRequest(ControlDataSourceImpl controlDataSourceImpl) {
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        return new RequestInfo(controllerMessageHelper.createLookupRequest(controlDataSourceImpl.getLogicalName(), controlDataSourceImpl.getMonitoredServerName(), controlDataSourceImpl.getMonitoredServerHostname(), controlDataSourceImpl.getMonitoredPortNumber(), controlDataSourceImpl.getMonitoredDatabaseName(), controlDataSourceImpl.getMonitoredLocationName(), 12), "1", null, controlDataSourceImpl);
    }

    public void sendPushDownErrors(ArrayList<PushDownError> arrayList, String string) {
        if (arrayList.size() <= 0) {
            return;
        }
        try {
            if (this.controllerAgent_ != null) {
                this.controllerAgent_.logPushDownErrors((String)this.driverDescriptorMap_.get("driverDescriptorUUID"), (String)this.driverDescriptorMap_.get("driverId"), string, MonitorInterface.ClientRuntime.JCC, arrayList);
            }
        }
        catch (Exception exception) {
            DataLogger.lowImpactLogger(logger__, this, "sendPushDownErrors", "sendPushDownErrors failed ", exception);
        }
    }

    public void sendApplicationException(String string, SQLException sQLException) {
        try {
            if (this.controllerAgent_ != null) {
                this.controllerAgent_.logApplicationException((String)this.driverDescriptorMap_.get("driverDescriptorUUID"), (String)this.driverDescriptorMap_.get("driverId"), string, MonitorInterface.ClientRuntime.JCC, sQLException);
            }
        }
        catch (Exception exception) {
            DataLogger.lowImpactLogger(logger__, this, "sendApplicationException", "sendApplicationException failed ", exception);
        }
    }

    public String getUUID() {
        return (String)this.driverDescriptorMap_.get("driverDescriptorUUID");
    }

    public String getDriverID() {
        return (String)this.driverDescriptorMap_.get("driverId");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogStatisticsLookup() {
        Set<String> set = null;
        ControlDataSourceImpl controlDataSourceImpl = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<HashSet<ClientInfo>> arrayList4 = new ArrayList<HashSet<ClientInfo>>();
        ArrayList<PushDownError> arrayList5 = null;
        Map<String, ControlDataSourceImpl> map = ControlDataSourcePool.getInstance().getPool();
        Iterator<Map.Entry<String, Database>> iterator = null;
        HashMap<String, TransportPoolStatistics> hashMap = new HashMap<String, TransportPoolStatistics>();
        ArrayList arrayList6 = new ArrayList();
        ArrayList<TransportPoolStatistics> arrayList7 = new ArrayList<TransportPoolStatistics>();
        ArrayList<Object[]> arrayList8 = new ArrayList<Object[]>();
        ArrayList<Long> arrayList9 = new ArrayList<Long>();
        ArrayList<Profile.DataSource> arrayList10 = new ArrayList<Profile.DataSource>();
        ArrayList<String> arrayList11 = new ArrayList<String>();
        ArrayList<Object[]> arrayList12 = new ArrayList<Object[]>();
        ArrayList<String> arrayList13 = new ArrayList<String>();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "doLogStatisticsLookup");
        }
        Map<String, ControlDataSourceImpl> map2 = map;
        synchronized (map2) {
            block30: {
                try {
                    Object[] objectArray;
                    Object object;
                    TransactionRule.PenaltyBox[] penaltyBoxArray;
                    Object object2;
                    set = map.keySet();
                    for (String object3 : set) {
                        controlDataSourceImpl = map.get(object3);
                        if (controlDataSourceImpl.getControllerType() != Service.ControllerType.OCM && controlDataSourceImpl.getControllerType() != Service.ControllerType.NPX) continue;
                        arrayList.add(controlDataSourceImpl.getDataSourceId());
                        arrayList4.add(controlDataSourceImpl.getClientInfo());
                        object2 = controlDataSourceImpl.getDataSourceProfile();
                        synchronized (object2) {
                            penaltyBoxArray = controlDataSourceImpl.getDataSourceProfile().getTransactionPenaltyBoxRules();
                            object = null;
                            arrayList2.add(controlDataSourceImpl.getDataSourceProfile().getName());
                            arrayList3.add(String.valueOf(controlDataSourceImpl.getDataSourceProfile().getVersion()));
                            if (penaltyBoxArray != null) {
                                object = new long[penaltyBoxArray.length];
                                for (int i10 = 0; i10 < penaltyBoxArray.length; ++i10) {
                                    if (penaltyBoxArray[i10] == null) continue;
                                    object[i10] = penaltyBoxArray[i10].getNumberOfTransactionsThatMatchPenaltyBoxCriteria();
                                    penaltyBoxArray[i10].resetNumberOfTimesApplied();
                                }
                            }
                            arrayList7.add((TransportPoolStatistics)object);
                            arrayList9.add(controlDataSourceImpl.getDataSourceProfile().getNumberOfTransactions());
                            controlDataSourceImpl.getDataSourceProfile().resetNumberOfTimesApplied();
                            objectArray = controlDataSourceImpl.getWASPoolStatistics();
                            arrayList8.add(objectArray);
                        }
                        arrayList5 = controlDataSourceImpl.getDynamicPushDownErrors();
                        this.sendPushDownErrors(arrayList5, controlDataSourceImpl.getDataSourceId());
                        controlDataSourceImpl.clearDynamicPushDownErrors(arrayList5);
                        controlDataSourceImpl.clearApplicationExceptionSet();
                    }
                    Object object4 = this.databasesMap_;
                    synchronized (object4) {
                        Object l11 = null;
                        iterator = this.databasesMap_.entrySet().iterator();
                        while (iterator.hasNext()) {
                            object2 = null;
                            penaltyBoxArray = iterator.next();
                            object = CMXImplMessageHelper.getInstance().createTransportPoolStatistics(penaltyBoxArray.getValue());
                            objectArray = null;
                            long l10 = -1L;
                            if (object != null) {
                                hashMap.put((String)penaltyBoxArray.getKey(), (TransportPoolStatistics)object);
                            }
                            arrayList6.add(penaltyBoxArray.getKey());
                            Profile.Database hashSet = ((Database)penaltyBoxArray.getValue()).getDatabaseProfile();
                            if (hashSet != null) {
                                Profile.Database database = hashSet;
                                synchronized (database) {
                                    TransactionRule.PenaltyBox[] penaltyBoxArray2 = hashSet.getTransactionPenaltyBoxRules();
                                    if (penaltyBoxArray2 != null) {
                                        object2 = new long[penaltyBoxArray2.length];
                                        for (int i11 = 0; i11 < penaltyBoxArray2.length; ++i11) {
                                            object2[i11] = penaltyBoxArray2[i11].getNumberOfTransactionsThatMatchPenaltyBoxCriteria();
                                            penaltyBoxArray2[i11].resetNumberOfTimesApplied();
                                        }
                                    }
                                    objectArray = hashSet.getName();
                                    l10 = hashSet.getVersion();
                                }
                            }
                            arrayList10.add((Profile.DataSource)object2);
                            arrayList11.add(Long.toString(((Database)penaltyBoxArray.getValue()).getVersion()));
                            arrayList12.add(objectArray);
                            arrayList13.add(Long.toString(l10));
                        }
                    }
                    if (this.controllerAgent_ == null) break block30;
                    object4 = null;
                    long l11 = -1L;
                    penaltyBoxArray = this.driverProfile_;
                    synchronized (penaltyBoxArray) {
                        object4 = this.driverProfile_.getName();
                        l11 = this.driverProfile_.getVersion();
                    }
                    this.controllerAgent_.logStatistics((String)this.driverDescriptorMap_.get("driverDescriptorUUID"), (String)this.driverDescriptorMap_.get("driverId"), (String)object4, String.valueOf(l11), arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]), ControllerMessageHelper.getInstance().clientInfoSetsListToArray(arrayList4), hashMap, (long[][])arrayList7.toArray((T[])new long[arrayList7.size()][]), arrayList9.toArray(new Long[arrayList9.size()]), (Object[][])arrayList8.toArray((T[])new Object[arrayList8.size()][]), arrayList6.toArray(new String[arrayList6.size()]), arrayList11.toArray(new String[arrayList11.size()]), arrayList12.toArray(new String[arrayList12.size()]), arrayList13.toArray(new String[arrayList13.size()]), (long[][])arrayList10.toArray((T[])new long[arrayList10.size()][]));
                }
                catch (Exception exception) {
                    DataLogger.lowImpactLogger(logger__, this, "doLogStatisticsLookup", "log statistics failed ", exception);
                }
                finally {
                    for (HashSet hashSet : arrayList4) {
                        if (hashSet == null || hashSet.size() <= 0) continue;
                        hashSet.clear();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRegisterDriverLookup(boolean bl2, boolean bl3) throws Exception {
        Set<String> set = null;
        boolean bl4 = true;
        ControlDataSourceImpl controlDataSourceImpl = null;
        ArrayList<RequestInfo> arrayList = new ArrayList<RequestInfo>();
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        ArrayList<Map<String, Object>> arrayList7 = new ArrayList<Map<String, Object>>();
        ArrayList<HashMap<String, String>> arrayList8 = new ArrayList<HashMap<String, String>>();
        HashMap<String, String> hashMap = null;
        Map<String, ControlDataSourceImpl> map = ControlDataSourcePool.getInstance().getPool();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "doRegisterDriverLookup");
        }
        Object object = this.driverProfile_;
        synchronized (object) {
            string = this.driverProfile_.getName();
            string2 = String.valueOf(this.driverProfile_.getVersion());
        }
        try {
            object = map;
            synchronized (object) {
                this.initializeControllerAgent();
                do {
                    Serializable serializable;
                    Iterator<Map.Entry<String, Database>> iterator = null;
                    bl5 = false;
                    arrayList.clear();
                    arrayList2.clear();
                    arrayList5.clear();
                    arrayList6.clear();
                    arrayList7.clear();
                    arrayList8.clear();
                    if (!bl2) {
                        arrayList.add(this.createRegisterDriverRequest());
                    }
                    if (!bl2) {
                        Iterator<String> iterator2 = this.databasesMap_;
                        synchronized (iterator2) {
                            for (Map.Entry<String, Database> entry : this.databasesMap_.entrySet()) {
                                serializable = entry.getValue();
                                arrayList.add(this.createLookupDatabaseRequest(serializable.getLogicalName(), serializable.getVersion()));
                            }
                        }
                    }
                    set = map.keySet();
                    for (String string3 : set) {
                        controlDataSourceImpl = map.get(string3);
                        if (controlDataSourceImpl.getControllerType() != Service.ControllerType.OCM && controlDataSourceImpl.getControllerType() != Service.ControllerType.NPX) continue;
                        if (bl4) {
                            serializable = controlDataSourceImpl.getDataSourceProfile();
                            synchronized (serializable) {
                                arrayList3.add(controlDataSourceImpl.getDataSourceProfile().getName());
                                arrayList4.add(String.valueOf(controlDataSourceImpl.getDataSourceProfile().getVersion()));
                            }
                        }
                        if (!bl2) {
                            arrayList.add(this.createRegisterDataSourceRequest(controlDataSourceImpl));
                        }
                        arrayList.add(this.createLookupRequest(controlDataSourceImpl));
                    }
                    if (this.controllerAgent_ != null && arrayList.size() > 0) {
                        this.controllerAgent_.sendAndReceiveChainedMessages(arrayList);
                        this.applyGlobalDynamicProperties();
                        if (this.lookupReplyFlag_ == 2) {
                            bl5 = true;
                            this.setDriverProfileVersion(-1L);
                            bl6 = true;
                        } else if (this.lookupReplyFlag_ == 1) {
                            bl6 = true;
                        }
                    }
                    set = map.keySet();
                    for (String string4 : set) {
                        controlDataSourceImpl = map.get(string4);
                        if (controlDataSourceImpl.getControllerType() != Service.ControllerType.OCM && controlDataSourceImpl.getControllerType() != Service.ControllerType.NPX) continue;
                        if (!bl3) {
                            controlDataSourceImpl.applyDynamicProperties();
                        }
                        if (controlDataSourceImpl.getLookupReplyFlag() == 2) {
                            bl5 = true;
                            controlDataSourceImpl.resetDataSourceProfileVersion();
                            bl6 = true;
                        } else if (controlDataSourceImpl.getLookupReplyFlag() == 1) {
                            bl6 = true;
                            if (bl3 && (hashMap = controlDataSourceImpl.getDataSourceProfile().getWasDirectives()) != null) {
                                bl7 = true;
                            }
                        }
                        arrayList2.add(controlDataSourceImpl.getDataSourceId());
                        serializable = controlDataSourceImpl.getDataSourceProfile();
                        synchronized (serializable) {
                            arrayList5.add(controlDataSourceImpl.getDataSourceProfile().getName());
                            arrayList6.add(String.valueOf(controlDataSourceImpl.getDataSourceProfile().getVersion()));
                            HashMap<String, String> hashMap2 = controlDataSourceImpl.getAppliedStatusFromWAS();
                            arrayList8.add(hashMap2);
                        }
                        arrayList7.add(controlDataSourceImpl.getNewDataSourceDescriptorMap());
                    }
                    bl4 = false;
                } while (bl5);
            }
        }
        catch (Exception exception) {
            DataLogger.lowImpactLogger(logger__, this, "doRegisterDriverLookup", "unable to retrieve updated properties from controller ", exception);
            throw exception;
        }
        this.doLogLookup(bl2, string, string2, arrayList2, arrayList3, arrayList4, arrayList5, arrayList6);
        this.doLogPushDownApplication(bl6 || this.bSendPushDownApp_, string, string2, arrayList2, arrayList7, arrayList3, arrayList4, arrayList5, arrayList6, arrayList8);
        if (bl6) {
            Utils.writeClientProfilesToFile(false);
        }
        ControlDriver.getInstance().initializeLogStatisticsTask();
        if (bl3 && bl6 && bl7) {
            this.bSendPushDownApp_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogLookup(boolean bl2, String string, String string2, ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, ArrayList<String> arrayList5) throws Exception {
        if (this.controllerAgent_ != null && !bl2) {
            String string3 = null;
            long l10 = -1L;
            Profile.Driver driver = this.driverProfile_;
            synchronized (driver) {
                string3 = this.driverProfile_.getName();
                l10 = this.driverProfile_.getVersion();
            }
            this.controllerAgent_.logLookup((String)this.driverDescriptorMap_.get("driverDescriptorUUID"), (String)this.driverDescriptorMap_.get("driverId"), string, string2, string3, String.valueOf(l10), arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new String[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]), arrayList4.toArray(new String[arrayList4.size()]), arrayList5.toArray(new String[arrayList5.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getNewDriverDescriptorMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.driverDescriptorMap_);
        HashMap<String, String> hashMap2 = new HashMap<String, String>((HashMap)this.driverDescriptorMap_.get("driverDescriptorClientPropertySettings"));
        hashMap.put("driverDescriptorClientPropertySettings", hashMap2);
        Profile.Driver driver = this.driverProfile_;
        synchronized (driver) {
            HashMap<String, String> hashMap3 = this.driverProfile_.getJccDirectives();
            if (hashMap3 != null) {
                Iterator<String> iterator = hashMap3.keySet().iterator();
                while (iterator.hasNext()) {
                    String string;
                    boolean bl2 = false;
                    String string2 = string = iterator.next();
                    if (string == null) continue;
                    if (string.startsWith(ClientProfileUtil.JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX)) {
                        string = string.substring(ClientProfileUtil.JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX.length());
                    } else if (string.startsWith(ClientProfileUtil.JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX)) {
                        string = string.substring(ClientProfileUtil.JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX.length());
                    } else if (string.startsWith(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX)) {
                        string = string.substring(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX.length());
                    }
                    if (hashMap2.containsKey(ClientProfileUtil.JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX + string)) {
                        hashMap2.remove(ClientProfileUtil.JCC_GLOBAL_PROPERTY_OVERRIDE_PREFIX + string);
                        bl2 = true;
                    }
                    if (hashMap2.containsKey(ClientProfileUtil.JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX + string)) {
                        hashMap2.remove(ClientProfileUtil.JCC_GLOBAL_PROPERTY_DEFAULT_PREFIX + string);
                        bl2 = true;
                    }
                    if (hashMap2.containsKey(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX + string)) {
                        hashMap2.remove(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX + string);
                        bl2 = true;
                    }
                    if (hashMap2.containsKey(string)) {
                        hashMap2.remove(string);
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    hashMap2.put(string2, hashMap3.get(string2));
                }
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLogPushDownApplication(boolean bl2, String string, String string2, ArrayList<String> arrayList, ArrayList<Map<String, Object>> arrayList2, ArrayList<String> arrayList3, ArrayList<String> arrayList4, ArrayList<String> arrayList5, ArrayList<String> arrayList6, ArrayList<HashMap<String, String>> arrayList7) throws Exception {
        if (this.controllerAgent_ != null && bl2) {
            String string3 = null;
            long l10 = -1L;
            Profile.Driver driver = this.driverProfile_;
            synchronized (driver) {
                string3 = this.driverProfile_.getName();
                l10 = this.driverProfile_.getVersion();
            }
            this.controllerAgent_.logPushDownApplication((String)this.driverDescriptorMap_.get("driverDescriptorUUID"), (String)this.driverDescriptorMap_.get("driverId"), this.getNewDriverDescriptorMap(), string, string2, string3, String.valueOf(l10), arrayList.toArray(new String[arrayList.size()]), arrayList2.toArray(new Map[arrayList2.size()]), arrayList3.toArray(new String[arrayList3.size()]), arrayList4.toArray(new String[arrayList4.size()]), arrayList5.toArray(new String[arrayList5.size()]), arrayList6.toArray(new String[arrayList6.size()]), arrayList7.toArray(new HashMap[arrayList7.size()]));
        }
        if (this.bSendPushDownApp_) {
            this.bSendPushDownApp_ = false;
        }
    }

    public Profile.Driver getDriverProfile() {
        return this.driverProfile_;
    }

    protected void finalize() throws Throwable {
        if (this.controllerAgent_ != null) {
            this.doLogStatisticsLookup();
            if (this.driverDescriptorMap_ != null && this.driverDescriptorMap_.get("driverId") != null) {
                try {
                    this.controllerAgent_.sendDeregisterDriver((String)this.driverDescriptorMap_.get("driverId"));
                }
                catch (Exception exception) {
                    DataLogger.lowImpactLogger(logger__, this, "sendDeregisterDriver", "unable to send deregister driver to controller ", exception);
                }
            }
        }
        super.finalize();
    }

    public void setDriverProfileVersion(long l10) {
        this.lastAppliedDriverProfileVersion_ = l10;
    }

    private void applyGlobalDynamicProperties() {
        long l10;
        ArrayList<PushDownError> arrayList;
        ArrayList arrayList2;
        block14: {
            arrayList2 = new ArrayList();
            arrayList = new ArrayList<PushDownError>();
            HashMap hashMap = null;
            HashMap hashMap2 = null;
            if (this.driverProfile_ == null) {
                return;
            }
            if (!Configuration.isJCCAtCMX5ProtocolLevel__) {
                return;
            }
            boolean bl2 = this.getStaticDriverProfileApplied();
            l10 = this.driverProfile_.getVersion();
            if (bl2) {
                if (l10 > this.lastAppliedDriverProfileVersion_ || l10 == -1L && this.lastAppliedDriverProfileVersion_ != -1L) {
                    hashMap = this.getRollbackGlobalDynamicProperties();
                    if (logger__.isLoggable(Level.FINEST)) {
                        logger__.log(Level.FINEST, "applyGlobalDynamicProperties - properties from driver descriptor: " + (hashMap == null ? "null" : hashMap));
                    }
                    hashMap2 = ClientProfileUtil.getGlobalDynamicProperties(this.driverProfile_);
                    if (logger__.isLoggable(Level.FINEST)) {
                        logger__.log(Level.FINEST, "applyGlobalDynamicProperties - properties from profile: " + (hashMap2 == null ? "null" : hashMap2));
                    }
                    if (hashMap2 != null) {
                        hashMap.putAll(hashMap2);
                    }
                }
            } else {
                return;
            }
            if (hashMap == null || hashMap.size() == 0) {
                this.lastAppliedDriverProfileVersion_ = l10;
                return;
            }
            try {
                if (logger__.isLoggable(Level.FINEST)) {
                    logger__.log(Level.FINEST, "Applying global dynamic properties : " + hashMap);
                }
                GlobalProperties.pushDown(false, hashMap, arrayList2);
            }
            catch (SQLException sQLException) {
                if (!logger__.isLoggable(Level.FINEST)) break block14;
                DataLogger.logTrappedException(logger__, this, "applyGlobalDynamicProperties", sQLException, null);
            }
        }
        this.lastAppliedDriverProfileVersion_ = l10;
        for (int i10 = 0; i10 < arrayList2.size(); ++i10) {
            Object[] objectArray = (Object[])arrayList2.get(i10);
            arrayList.add(ClientProfileUtil.getPushDownError(objectArray, PushDownError.PushDownLevel.driver));
        }
        if (arrayList.size() > 0) {
            ControlDriver.getInstance().sendPushDownErrors(arrayList, null);
        }
    }

    public HashMap getRollbackGlobalDynamicProperties() {
        Object object = null;
        String string = null;
        String string2 = null;
        HashMap<String, String> hashMap = null;
        hashMap = new HashMap<String, String>();
        HashMap hashMap2 = (HashMap)this.driverDescriptorMap_.get("driverDescriptorClientPropertySettings");
        for (int i10 = 0; i10 < ClientProfileUtil.supportedGlobalDynamicProperties.length; ++i10) {
            string2 = ClientProfileUtil.supportedGlobalDynamicProperties[i10];
            object = hashMap2.get(string2);
            if (object == null) {
                string2 = ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX + string2;
                object = hashMap2.get(string2);
            }
            if (object == null) continue;
            string = object.toString();
            hashMap.put(ClientProfileUtil.JCC_GLOBAL_PROPERTY_PREFIX + ClientProfileUtil.supportedGlobalDynamicProperties[i10], string);
        }
        if (logger__.isLoggable(Level.FINEST)) {
            logger__.log(Level.FINEST, "Global rollback properties : " + hashMap);
        }
        return hashMap;
    }

    public void setMonConnection(int n2, Connection connection) {
        this.connectionMap.put(n2, connection);
    }

    public boolean isMonConnectionset(int n2) {
        return this.connectionMap.get(n2) != null;
    }

    class RequestInfo {
        private Message message_;
        private String messageType_;
        private String logicalDatabaseName_;
        private ControlDataSourceImpl cds_;

        RequestInfo(Message message, String string, String string2, ControlDataSourceImpl controlDataSourceImpl) {
            this.message_ = message;
            this.messageType_ = string;
            this.logicalDatabaseName_ = string2;
            this.cds_ = controlDataSourceImpl;
        }

        Message getMessage() {
            return this.message_;
        }

        String getMessageType() {
            return this.messageType_;
        }

        String getLogicalDatabaseName() {
            return this.logicalDatabaseName_;
        }

        ControlDataSourceImpl getCDS() {
            return this.cds_;
        }
    }

    private class ShutdownHookRunnable
    implements Runnable {
        TimerTask timerTask_;

        public ShutdownHookRunnable(TimerTask timerTask) {
            this.timerTask_ = timerTask;
        }

        @Override
        public void run() {
            DataLogger.logMonitorMessage(logger__, this, "run", "Running shutdown hook");
            ControlDriver.this.isShutdownProcessing_ = true;
            this.timerTask_.cancel();
            this.timerTask_.run();
        }
    }

    private class ShutdownHookAction
    implements PrivilegedAction<Thread> {
        private TimerTask timerTask_ = null;
        private String threadName_ = null;

        public ShutdownHookAction(TimerTask timerTask, String string) {
            this.timerTask_ = timerTask;
            this.threadName_ = string;
        }

        @Override
        public Thread run() {
            Thread thread = new Thread((Runnable)new ShutdownHookRunnable(this.timerTask_), this.threadName_);
            try {
                Runtime.getRuntime().addShutdownHook(thread);
            }
            catch (IllegalStateException illegalStateException) {
                DataLogger.logThrowable(null, illegalStateException);
            }
            return thread;
        }
    }

    private class LogStatisticsLookup
    extends TimerTask
    implements Runnable {
        private LogStatisticsLookup() {
        }

        @Override
        public void run() {
            if (!ControlDriver.this.isShutdownProcessing_ && ControlDriver.this.shutdownHook_ == null) {
                ControlDriver.this.shutdownHook_ = AccessController.doPrivileged(new ShutdownHookAction(this, "shutdownhook"));
            }
            try {
                ControlDriver.this.doLogStatisticsLookup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean cancel() {
            if (ControlDriver.this.shutdownHook_ != null && !ControlDriver.this.isShutdownProcessing_) {
                Runtime.getRuntime().removeShutdownHook(ControlDriver.this.shutdownHook_);
            }
            ControlDriver.this.shutdownHook_ = null;
            return super.cancel();
        }
    }

    private class RegisterDriverLookup
    extends TimerTask
    implements Runnable {
        private RegisterDriverLookup() {
        }

        @Override
        public void run() {
            try {
                ControlDriver.this.doRegisterDriverLookup(false, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

