/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.impl;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Database;
import com.ibm.db2.cmx.Environment;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.MonitorSettings;
import com.ibm.db2.cmx.MonitoredData;
import com.ibm.db2.cmx.MonitoredDataSourceAttributes;
import com.ibm.db2.cmx.MonitoredStatementExecutionData;
import com.ibm.db2.cmx.MonitoredTransactionExecutionData;
import com.ibm.db2.cmx.MonitoredWebsphereData;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.QueryServiceInterface;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.impl.CMXImplMessageHelper;
import com.ibm.db2.cmx.impl.DataSourceDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import com.ibm.db2.cmx.impl.MonitoredDataSourceAttributesImpl;
import com.ibm.db2.cmx.impl.MonitoredStatementExecutionDataImpl;
import com.ibm.db2.cmx.impl.MonitoredTransactionExecutionDataImpl;
import com.ibm.db2.cmx.impl.MonitoredWebsphereDataImpl;
import com.ibm.db2.cmx.impl.Registry;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.core.CMXConnection;
import com.ibm.db2.cmx.internal.core.JSONHelper;
import com.ibm.db2.cmx.internal.core.LogLookupInfo;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.internal.json4j.JSONArray;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpControllerProcessorAS
implements Processor {
    static final String DEFAULT = "<default>";
    static final String UNSPECIFIED = "<unspecified>";
    private static JSONObject monitorAllSettings__;
    private static Logger logger__;
    private QueryServiceInterface queryService_ = Environment.getQueryService();
    private Registry queryServiceRegistry_ = Environment.getRegistry();
    private MonitorInterface queryServiceMonitor_ = Environment.getMonitor();

    public HttpControllerProcessorAS() {
    }

    public HttpControllerProcessorAS(Logger logger) {
        logger__ = logger;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "<init>", "ENTRY " + Arrays.deepToString(new Object[]{this.queryService_, this.queryServiceRegistry_, this.queryServiceMonitor_}));
        }
    }

    public void registerOverrideMonitor(String string, int n2, boolean bl2, int n3, int n4, int[] nArray, boolean bl3) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("monitorServerName", string);
        jSONObject.put("monitorPort", (Object)n2);
        jSONObject.put("monitorEnabled", (Object)(bl2 ? 1 : 2));
        jSONObject.put("monitorLevel", (Object)n3);
        jSONObject.put("monitorCollectionInterval", (Object)n4);
        jSONObject.put("disableOCMDynamicControl", (Object)(bl3 ? 1 : 0));
        if (nArray != null && nArray.length > 0) {
            JSONArray jSONArray = new JSONArray();
            for (int i10 = 0; i10 < nArray.length; ++i10) {
                jSONArray.add((Object)nArray[i10]);
            }
            jSONObject.put("supportedKeyTypes", jSONArray);
        }
        monitorAllSettings__ = jSONObject;
    }

    @Override
    public Message processRequest(Message message, CMXConnection cMXConnection) throws CMXException {
        return null;
    }

    private void refreshServicePointers() {
        if (this.queryService_ == null) {
            this.queryService_ = Environment.getQueryService();
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "refreshServicePointers", "Query Service: " + this.queryService_);
            }
        }
        if (this.queryServiceRegistry_ == null) {
            this.queryServiceRegistry_ = Environment.getRegistry();
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "refreshServicePointers", "Query Service Registry: " + this.queryServiceRegistry_);
            }
        }
        if (this.queryServiceMonitor_ == null) {
            this.queryServiceMonitor_ = Environment.getMonitor();
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "refreshServicePointers", "Query Service Monitor: " + this.queryServiceMonitor_);
            }
        }
    }

    private String[] parseIPAddressesString(String string, boolean bl2) {
        String[] stringArray = null;
        if (string != null && (stringArray = string.split(";")) != null) {
            for (int i10 = 0; i10 < stringArray.length; ++i10) {
                if (stringArray[i10] == null || !bl2) continue;
                stringArray[i10] = Configuration.resolveToIPAddress(stringArray[i10]);
            }
        }
        return stringArray;
    }

    private Message processRequest(Message message, int n2, String string, int n3, LogLookupInfo logLookupInfo) throws CMXException {
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        String string2 = jSONArray.get(0).toString();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "processRequest", "ENTRY " + Arrays.deepToString(new Object[]{string2}));
        }
        if (string2.equals("1")) {
            String string3 = jSONArray.get(1) != null ? jSONArray.get(1).toString() : null;
            String string4 = jSONArray.get(2) != null ? jSONArray.get(2).toString() : null;
            String string5 = jSONArray.get(3) != null ? jSONArray.get(3).toString() : null;
            String string6 = jSONArray.get(4) != null ? jSONArray.get(4).toString() : null;
            String string7 = null;
            String string8 = null;
            if (n2 > 2) {
                String string9 = string7 = jSONArray.get(5) != null ? jSONArray.get(5).toString() : null;
            }
            if (n2 >= 8) {
                string8 = jSONArray.get(6) != null ? jSONArray.get(6).toString() : null;
            }
            return this.lookupRequest(string3, string4, string8, string5, string6, string7, n2);
        }
        if (string2.equals("2")) {
            String string10 = jSONArray.get(1) != null ? jSONArray.get(1).toString() : null;
            JSONObject jSONObject = (JSONObject)jSONArray.get(2);
            JSONObject jSONObject2 = (JSONObject)jSONArray.get(3);
            String string11 = jSONArray.get(4) != null ? jSONArray.get(4).toString() : null;
            String string12 = jSONArray.get(5) != null ? jSONArray.get(5).toString() : null;
            String string13 = jSONArray.get(6) != null ? jSONArray.get(6).toString() : null;
            String string14 = null;
            String string15 = null;
            String[] stringArray = null;
            JSONArray jSONArray2 = null;
            if (n2 > 2) {
                String string16 = string14 = jSONArray.get(7) != null ? jSONArray.get(7).toString() : null;
            }
            if (n2 >= 8) {
                String string17 = string15 = jSONArray.get(8) != null ? jSONArray.get(8).toString() : null;
            }
            if (n2 >= 9) {
                jSONArray2 = jSONArray.get(9) != null ? jSONArray.get(9) : null;
                stringArray = JSONHelper.createStringArrayFromJSONArray(jSONArray2);
            }
            this.registerRequest(string10, string11, string15, stringArray, string12, string13, string14, jSONObject, jSONObject2, n2);
            if (n2 >= 9 && this.queryService_ != null) {
                String[] stringArray2 = null;
                String string18 = (String)jSONObject2.get("monitorServerName");
                stringArray2 = this.parseIPAddressesString(string18, true);
                MonitorSettings monitorSettings = new MonitorSettings(stringArray2, ((Number)jSONObject2.get("monitorPort")).intValue(), ((Number)jSONObject2.get("monitorEnabled")).intValue() == 1, ((Number)jSONObject2.get("monitorLevel")).intValue(), ((Number)jSONObject2.get("monitorCollectionInterval")).intValue(), JSONHelper.createIntArrayFromJSONArray((JSONArray)jSONObject2.get("supportedKeyTypes")), new String[]{(String)jSONObject2.get("clientUserMask"), (String)jSONObject2.get("clientHostnameMask"), (String)jSONObject2.get("applicationNameMask"), (String)jSONObject2.get("clientAccountingInformationMask")}, ((Number)jSONObject2.get("dispatchToken")).intValue(), ((Number)jSONObject2.get("disableOCMDynamicControl")).intValue() == 1);
                if (string10 != null) {
                    Database database = this.queryService_.registerMonitoredLogicalDataSource(string10, monitorSettings);
                    if (database != null) {
                        this.queryServiceRegistry_.updateDatabase(database.getLogicalName(), database);
                    }
                } else if (string14 != null) {
                    Set<Database> set = this.queryService_.registerMonitoredLocation(string14, monitorSettings);
                    for (Database database : set) {
                        if (database == null) continue;
                        this.queryServiceRegistry_.updateDatabase(database.getLogicalName(), database);
                    }
                } else if (stringArray != null && stringArray.length > 0) {
                    for (int i10 = 0; i10 < stringArray.length; ++i10) {
                        this.queryService_.registerMonitoredDatabaseURL(stringArray[i10], Integer.parseInt(string12), string13, monitorSettings);
                    }
                } else {
                    this.queryService_.registerMonitoredDatabaseURL(string11, Integer.parseInt(string12), string13, monitorSettings);
                }
            }
        } else if (string2.equals("3")) {
            int n4 = 0;
            String string19 = jSONArray.get(1) != null ? jSONArray.get(1).toString() : null;
            String string20 = jSONArray.get(2) != null ? jSONArray.get(2).toString() : null;
            String string21 = jSONArray.get(3) != null ? jSONArray.get(3).toString() : null;
            String string22 = jSONArray.get(4) != null ? jSONArray.get(4).toString() : null;
            String string23 = null;
            String string24 = null;
            if (n2 > 2) {
                String string25 = string23 = jSONArray.get(5) != null ? jSONArray.get(5).toString() : null;
            }
            if (n2 > 3) {
                n4 = ((Number)jSONArray.get(6)).intValue();
            }
            if (n2 >= 8) {
                string24 = jSONArray.get(7) != null ? jSONArray.get(7).toString() : null;
            }
            this.deregisterRequest(string19, string20, string24, string21, string22, string23, n4, string, n3, n2);
        } else {
            if (string2.equals("4")) {
                Profile.Driver driver = null;
                DriverDescriptor driverDescriptor = null;
                long l10 = -1L;
                int n5 = 0;
                JSONObject jSONObject = (JSONObject)jSONArray.get(1);
                this.refreshServicePointers();
                if (this.queryServiceRegistry_ != null && jSONObject != null) {
                    if (jSONObject.containsKey("driverDescriptorUUID")) {
                        driverDescriptor = CMXImplMessageHelper.getInstance().parseDriverDescriptor(jSONObject);
                        if (driverDescriptor != null) {
                            driver = this.registerDriver(driverDescriptor);
                            logLookupInfo.driverId_ = driverDescriptor.getDriverId();
                            logLookupInfo.clientUUID_ = driverDescriptor.getClientInstallationUUID();
                            if (driver != null) {
                                logLookupInfo.newDriverProfileName_ = driver.getName();
                                logLookupInfo.newDriverProfileVersion_ = Long.toString(driver.getVersion());
                                n5 = 1;
                            }
                        }
                    } else if (jSONObject.containsKey("driverId")) {
                        logLookupInfo.driverId_ = (String)jSONObject.get("driverId");
                        logLookupInfo.originalDriverProfileName_ = (String)jSONObject.get("driverProfileName");
                        l10 = ((Number)jSONObject.get("driverProfileVersion")).longValue();
                        logLookupInfo.originalDriverProfileVersion_ = Long.toString(l10);
                        if (logLookupInfo.driverId_ != null) {
                            DriverDescriptor driverDescriptor2 = this.queryServiceRegistry_.getDriverDescriptor(logLookupInfo.driverId_);
                            Profile.Driver driver2 = this.getDriverProfile(logLookupInfo.driverId_);
                            if (driverDescriptor2 != null) {
                                logLookupInfo.clientUUID_ = driverDescriptor2.getClientInstallationUUID();
                            }
                            if (driver2 != null) {
                                logLookupInfo.newDriverProfileName_ = driver2.getName();
                                logLookupInfo.newDriverProfileVersion_ = Long.toString(driver2.getVersion());
                                if (!driver2.getName().equals(logLookupInfo.originalDriverProfileName_) || driver2.getVersion() != l10) {
                                    driver = driver2;
                                    n5 = 1;
                                    driverDescriptor = driverDescriptor2;
                                }
                            } else if (logLookupInfo.originalDriverProfileName_ != null || driverDescriptor2 == null) {
                                logLookupInfo.bResendDescriptor_ = true;
                                n5 = 2;
                            }
                        }
                    }
                }
                return this.registerDriverRequest(n5, logLookupInfo.driverId_, driver, driverDescriptor, n2);
            }
            if (string2.equals("5")) {
                int n6 = 0;
                Database database = null;
                String string26 = null;
                long l11 = -1L;
                DriverDescriptor driverDescriptor = null;
                if (this.queryServiceRegistry_ != null) {
                    string26 = (String)jSONArray.get(1);
                    l11 = ((Number)jSONArray.get(2)).longValue();
                    Database database2 = this.getDatabase(string26);
                    if (database2 != null) {
                        if (l11 != database2.getVersion()) {
                            database = database2;
                            n6 = 1;
                            if (logLookupInfo.driverId_ != null) {
                                driverDescriptor = this.queryServiceRegistry_.getDriverDescriptor(logLookupInfo.driverId_);
                            }
                        }
                    } else {
                        n6 = 1;
                    }
                }
                return this.lookupDatabaseRequest(n6, database, driverDescriptor, n2);
            }
            if (string2.equals("6")) {
                Profile.DataSource dataSource = null;
                DataSourceDescriptor dataSourceDescriptor = null;
                String string27 = null;
                String string28 = null;
                String string29 = null;
                long l12 = -1L;
                long l13 = -1L;
                int n7 = 0;
                JSONObject jSONObject = (JSONObject)jSONArray.get(1);
                if (this.queryServiceRegistry_ != null && jSONObject != null) {
                    if (jSONObject.containsKey("dsDescriptorProfileName")) {
                        DriverDescriptor driverDescriptor;
                        String string30 = logLookupInfo.driverId_;
                        if (string30 == null) {
                            string30 = (String)jSONObject.get("driverId");
                        }
                        if ((driverDescriptor = this.queryServiceRegistry_.getDriverDescriptor(string30)) != null) {
                            dataSourceDescriptor = CMXImplMessageHelper.getInstance().parseDataSourceDescriptor(driverDescriptor, jSONObject);
                            string27 = dataSourceDescriptor.getDataSourceId();
                            dataSource = this.registerDataSource(dataSourceDescriptor);
                            if (dataSource != null) {
                                string29 = dataSource.getName();
                                l13 = dataSource.getVersion();
                                n7 = 1;
                            }
                        }
                    } else if (jSONObject.containsKey("dataSourceId")) {
                        string27 = (String)jSONObject.get("dataSourceId");
                        string28 = (String)jSONObject.get("dataSourceProfileName");
                        l12 = ((Number)jSONObject.get("dataSourceProfileVersion")).longValue();
                        if (string27 != null) {
                            DataSourceDescriptor dataSourceDescriptor2 = this.queryServiceRegistry_.getDataSourceDescriptor(string27);
                            Profile.DataSource dataSource2 = this.getDataSourceProfile(string27);
                            if (dataSource2 != null) {
                                string29 = dataSource2.getName();
                                l13 = dataSource2.getVersion();
                                if (!dataSource2.getName().equals(string28) || dataSource2.getVersion() != l12) {
                                    dataSource = dataSource2;
                                    n7 = 1;
                                    dataSourceDescriptor = dataSourceDescriptor2;
                                }
                            } else if (string28 != null || dataSourceDescriptor2 == null) {
                                logLookupInfo.bResendDescriptor_ = true;
                                n7 = 2;
                            }
                        }
                    }
                }
                logLookupInfo.datasourceIds_.add(string27);
                logLookupInfo.originalDataSourceProfileNames_.add(string28);
                logLookupInfo.originalDataSourceProfileVersions_.add(Long.toString(l12));
                logLookupInfo.newDataSourceProfileNames_.add(string29);
                logLookupInfo.newDataSourceProfileVersions_.add(Long.toString(l13));
                return this.registerDataSourceRequest(n7, string27, dataSource, dataSourceDescriptor, n2);
            }
            if (string2.equals("7")) {
                this.deregisterDriver((String)jSONArray.get(1), null);
            } else if (string2.equals("8")) {
                this.deregisterDataSource((String)jSONArray.get(1), null);
            }
        }
        return null;
    }

    @Override
    public void invokeLogLookup(LogLookupInfo logLookupInfo) {
        if (this.queryServiceMonitor_ != null && !logLookupInfo.bResendDescriptor_ && logLookupInfo.driverId_ != null && this.queryServiceMonitor_.isLookupLoggingEnabled()) {
            this.queryServiceMonitor_.logLookup(logLookupInfo.clientUUID_, logLookupInfo.driverId_, logLookupInfo.originalDriverProfileName_, logLookupInfo.originalDriverProfileVersion_, logLookupInfo.newDriverProfileName_, logLookupInfo.newDriverProfileVersion_, logLookupInfo.datasourceIds_.toArray(new String[logLookupInfo.datasourceIds_.size()]), logLookupInfo.originalDataSourceProfileNames_.toArray(new String[logLookupInfo.originalDataSourceProfileNames_.size()]), logLookupInfo.originalDataSourceProfileVersions_.toArray(new String[logLookupInfo.originalDataSourceProfileVersions_.size()]), logLookupInfo.newDataSourceProfileNames_.toArray(new String[logLookupInfo.newDataSourceProfileNames_.size()]), logLookupInfo.newDataSourceProfileVersions_.toArray(new String[logLookupInfo.newDataSourceProfileVersions_.size()]));
        }
    }

    private Message registerDataSourceRequest(int n2, String string, Profile.DataSource dataSource, ClientDescriptor.DataSource dataSource2, int n3) {
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerDataSourceRequest", "Processed register datasource lookup request.  dataSourceId: " + string + ", lookupReplyFlag: " + n2);
        }
        if (string != null) {
            this.registerNewTimeRefForDataSourceId(string, System.currentTimeMillis());
        }
        return ControllerMessageHelper.getInstance().createRegisterDataSourceReply(n2, string, dataSource, dataSource2, n3);
    }

    private Message lookupDatabaseRequest(int n2, Database database, ClientDescriptor.Driver driver, int n3) {
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "lookupDatabaseRequest", "Processed lookup database request.  lookupReplyFlag: " + n2);
        }
        return ControllerMessageHelper.getInstance().createLookupDatabaseReply(n2, database, driver, n3);
    }

    private Message registerDriverRequest(int n2, String string, Profile.Driver driver, ClientDescriptor.Driver driver2, int n3) {
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerDriverRequest", "Processed register driver request.  driverId: " + string + ", lookupReplyFlag: " + n2);
        }
        if (string != null) {
            this.registerNewTimeRefForDriverId(string, System.currentTimeMillis());
        }
        return ControllerMessageHelper.getInstance().createRegisterDriverReply(n2, string, driver, driver2, n3);
    }

    private Message lookupRequest(String string, String string2, String string3, String string4, String string5, String string6, int n2) {
        JSONArray jSONArray = null;
        JSONObject jSONObject = null;
        JSONObject jSONObject2 = null;
        String string7 = null;
        int n3 = 0;
        MonitorSettings monitorSettings = null;
        if (monitorAllSettings__ != null) {
            jSONObject2 = monitorAllSettings__;
            n3 = 2;
        } else {
            if (string != null) {
                string7 = ControlDataSourcePool.createKey(string);
                n3 = 1;
                jSONArray = this.queryServiceRegistry_.lookupInMemoryForEI(string7, n2);
            }
            if (jSONArray == null) {
                n3 = 2;
                string7 = ControlDataSourcePool.createKey(string2, string4, string5, null, true);
                jSONArray = this.queryServiceRegistry_.lookupInMemoryForEI(string7, n2);
                if (jSONArray == null && n2 >= 8 && string3 != null) {
                    string7 = ControlDataSourcePool.createKey(string3, string4, string5, null, false);
                    jSONArray = this.queryServiceRegistry_.lookupInMemoryForEI(string7, n2);
                }
            }
            if (jSONArray == null && string6 != null) {
                string7 = ControlDataSourcePool.createKey(null, null, null, string6, false);
                n3 = 3;
                jSONArray = this.queryServiceRegistry_.lookupInMemoryForEI(string7, n2);
            }
            if (jSONArray == null) {
                if (string != null) {
                    string7 = ControlDataSourcePool.createKey(string);
                    n3 = 1;
                    try {
                        monitorSettings = this.queryService_.getMonitorSettingsForLogicalDataSourceName(string);
                        if (monitorSettings != null) {
                            jSONArray = this.queryServiceRegistry_.cacheMonitorSettings(string7, monitorSettings);
                        }
                    }
                    catch (CMXException cMXException) {
                        DataLogger.logThrowable(logger__, cMXException);
                    }
                }
                if (jSONArray == null) {
                    n3 = 2;
                    string7 = ControlDataSourcePool.createKey(string2, string4, string5, null, true);
                    try {
                        monitorSettings = this.queryService_.getMonitorSettingsForDatabaseURL(string3, string2, Integer.parseInt(string4), string5);
                        if (monitorSettings != null) {
                            jSONArray = this.queryServiceRegistry_.cacheMonitorSettings(string7, monitorSettings);
                        }
                    }
                    catch (CMXException cMXException) {
                        DataLogger.logThrowable(logger__, cMXException);
                    }
                    if (jSONArray == null && n2 >= 8 && string3 != null) {
                        string7 = ControlDataSourcePool.createKey(string3, string4, string5, null, false);
                        try {
                            monitorSettings = this.queryService_.getMonitorSettingsForDatabaseURL(string3, string2, Integer.parseInt(string4), string5);
                            if (monitorSettings != null) {
                                jSONArray = this.queryServiceRegistry_.cacheMonitorSettings(string7, monitorSettings);
                            }
                        }
                        catch (CMXException cMXException) {
                            DataLogger.logThrowable(logger__, cMXException);
                        }
                    }
                }
                if (jSONArray == null && string6 != null) {
                    string7 = ControlDataSourcePool.createKey(null, null, null, string6, false);
                    n3 = 3;
                    try {
                        monitorSettings = this.queryService_.getMonitorSettingsForDatabaseLocation(string6);
                        if (monitorSettings != null) {
                            jSONArray = this.queryServiceRegistry_.cacheMonitorSettings(string7, monitorSettings);
                        }
                    }
                    catch (CMXException cMXException) {
                        DataLogger.logThrowable(logger__, cMXException);
                    }
                }
            }
            if (jSONArray != null) {
                jSONObject = (JSONObject)jSONArray.get(0);
                jSONObject2 = (JSONObject)jSONArray.get(1);
                if (n2 < 4) {
                    jSONObject = this.generatePreVersion4Properties(jSONObject);
                    jSONObject2 = this.generatePreVersion4Properties(jSONObject2);
                }
            } else {
                n3 = 0;
            }
        }
        if (jSONObject == null) {
            jSONObject = new JSONObject();
        }
        if (jSONObject2 == null) {
            jSONObject2 = new JSONObject();
        }
        if (n2 < 3) {
            jSONObject = this.generatePreVersion3Properties(jSONObject);
            jSONObject2 = this.generatePreVersion3Properties(jSONObject2);
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "processRequest", "Processed datasource lookup request for KEY: " + string7 + ", matched KEYSET: " + n3);
        }
        return ControllerMessageHelper.getInstance().createLookupReply("ClientPropertyProcessor", string, string2, string4, string5, jSONObject, jSONObject2, string6, n3, n2);
    }

    private JSONObject generatePreVersion4Properties(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = new JSONObject();
        for (String string : jSONObject.keySet()) {
            if (string.equals("monitorServerName")) {
                String string2 = (String)jSONObject.get("monitorServerName");
                if (string2 != null) {
                    int n2 = string2.indexOf(";");
                    if (n2 != -1) {
                        String string3 = string2.substring(0, n2);
                        jSONObject2.put(string, string3);
                        continue;
                    }
                    jSONObject2.put(string, string2);
                    continue;
                }
                jSONObject2.put(string, string2);
                continue;
            }
            jSONObject2.put(string, jSONObject.get(string));
        }
        return jSONObject2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRequest(String string, String string2, String string3, String[] stringArray, String string4, String string5, String string6, JSONObject jSONObject, JSONObject jSONObject2, int n2) {
        String string7 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        JSONArray jSONArray = new JSONArray();
        jSONArray.add(jSONObject);
        jSONArray.add(jSONObject2);
        string7 = this.createKey(string, string2, string4, string5, string6, true);
        arrayList.add(string7);
        HashMap<String, JSONArray> hashMap = this.queryServiceRegistry_.registryForEI_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.registryForEI_.put(string7, jSONArray);
        }
        if (n2 >= 8 && string3 != null) {
            string7 = this.createKey(string, string3, string4, string5, string6, false);
            arrayList.add(string7);
            hashMap = this.queryServiceRegistry_.registryForEI_;
            synchronized (hashMap) {
                this.queryServiceRegistry_.registryForEI_.put(string7, jSONArray);
            }
        }
        if (n2 >= 9 && stringArray != null) {
            for (int i10 = 0; i10 < stringArray.length; ++i10) {
                String string8 = Configuration.resolveToIPAddress(stringArray[i10]);
                string7 = this.createKey(string, stringArray[i10], string4, string5, string6, false);
                arrayList.add(string7);
                HashMap<String, JSONArray> hashMap2 = this.queryServiceRegistry_.registryForEI_;
                synchronized (hashMap2) {
                    this.queryServiceRegistry_.registryForEI_.put(string7, jSONArray);
                }
                if (string != null || string6 != null || string8 == null || stringArray[i10] == null || string8.equals(stringArray[i10])) continue;
                string7 = this.createKey(string, stringArray[i10], string4, string5, string6, true);
                arrayList.add(string7);
                hashMap2 = this.queryServiceRegistry_.registryForEI_;
                synchronized (hashMap2) {
                    this.queryServiceRegistry_.registryForEI_.put(string7, jSONArray);
                    continue;
                }
            }
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerRequest", "Processed register datasource request for KEY(s): " + Arrays.toString(arrayList.toArray()) + " PROPERTIES: " + jSONArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterRequest(String string, String string2, String string3, String string4, String string5, String string6, int n2, String string7, int n3, int n4) {
        JSONArray jSONArray;
        JSONObject jSONObject;
        String string8 = null;
        Object[] objectArray = new String[2];
        objectArray[0] = string8 = this.createKey(string, string2, string4, string5, string6, true);
        HashMap<String, JSONArray> hashMap = this.queryServiceRegistry_.registryForEI_;
        synchronized (hashMap) {
            switch (n2) {
                case 1: {
                    if (!this.queryServiceRegistry_.registryForEI_.containsKey(string8) || string7 == null || (jSONObject = (JSONObject)(jSONArray = this.queryServiceRegistry_.registryForEI_.get(string8)).get(1)) == null) break;
                    jSONObject.put("monitorPort", (Object)n3);
                    jSONObject.put("monitorServerName", string7);
                    jSONObject.put("deregisterAction", (Object)n2);
                    break;
                }
                default: {
                    this.queryServiceRegistry_.registryForEI_.remove(string8);
                }
            }
        }
        if (n4 >= 8 && string3 != null) {
            string8 = this.createKey(string, string3, string4, string5, string6, false);
            objectArray[1] = string8;
            hashMap = this.queryServiceRegistry_.registryForEI_;
            synchronized (hashMap) {
                switch (n2) {
                    case 1: {
                        if (!this.queryServiceRegistry_.registryForEI_.containsKey(string8) || string7 == null || (jSONObject = (JSONObject)(jSONArray = this.queryServiceRegistry_.registryForEI_.get(string8)).get(1)) == null) break;
                        jSONObject.put("monitorPort", (Object)n3);
                        jSONObject.put("monitorServerName", string7);
                        jSONObject.put("deregisterAction", (Object)n2);
                        break;
                    }
                    default: {
                        this.queryServiceRegistry_.registryForEI_.remove(string8);
                    }
                }
            }
        }
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "deregisterRequest", "Processed deregister datasource request for KEY(s): " + Arrays.deepToString(objectArray));
        }
    }

    private String createKey(String string, String string2, String string3, String string4, String string5, boolean bl2) {
        String string6 = string != null ? ControlDataSourcePool.createKey(string) : (string5 != null ? ControlDataSourcePool.createKey(null, null, null, string5, false) : ControlDataSourcePool.createKey(string2, string3, string4, null, bl2));
        return string6;
    }

    @Override
    public void processAsynchronousMessage(Message message, CMXConnection cMXConnection) throws Exception {
    }

    @Override
    public int getVersion() {
        return 12;
    }

    @Override
    public String getProcessorName() {
        return "ClientPropertyProcessor";
    }

    @Override
    public int getNegotiatedVersion(int n2) {
        return Math.min(n2, this.getVersion());
    }

    private JSONObject generatePreVersion3Properties(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = new JSONObject();
        for (String string : jSONObject.keySet()) {
            if (!string.equals("monitorServerName") && !string.equals("monitorPort") && !string.equals("monitorEnabled") && !string.equals("monitorLevel") && !string.equals("monitorCollectionInterval") && !string.equals("monitorIdRequired")) continue;
            jSONObject2.put(string, jSONObject.get(string));
        }
        return jSONObject2;
    }

    @Override
    public Message processRequest(Message message, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, LogLookupInfo logLookupInfo) throws Exception {
        int n2 = httpServletRequest.getIntHeader("CMX-Client-Processor-Version");
        int n3 = this.getNegotiatedVersion(n2);
        httpServletResponse.setHeader("CMX-Client-Processor-Version", Integer.toString(n3));
        return this.processRequest(message, n3, Configuration.localHostAddress__, httpServletRequest.getServerPort(), logLookupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile.Driver registerDriver(DriverDescriptor driverDescriptor) throws CMXException {
        Profile.Driver driver = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerDriver", "ENTRY " + Arrays.deepToString(new Object[]{driverDescriptor, this.queryService_}));
        }
        if (this.queryService_ != null) {
            driver = this.queryService_.registerDriver(driverDescriptor);
            Registry registry = this.queryServiceRegistry_;
            synchronized (registry) {
                this.registerNewDescriptorForDriverId(driverDescriptor.getDriverId(), driverDescriptor);
                this.registerNewTimeRefForDriverId(driverDescriptor.getDriverId(), System.currentTimeMillis());
                if (driver != null) {
                    this.queryServiceRegistry_.registerNewProfileForDriverId(driverDescriptor.getDriverId(), driver);
                    this.registerNewProfileForProfileName(driver.getName(), driver);
                }
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "registerDriver", driver);
        }
        return driver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterDriver(String string, Iterator iterator) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterDriver", "ENTRY " + Arrays.deepToString(new Object[]{string, this.queryService_}));
        }
        if (this.queryService_ != null) {
            this.queryService_.deregisterDriver(string);
            Registry registry = this.queryServiceRegistry_;
            synchronized (registry) {
                this.queryServiceRegistry_.removeDriverIdFromProfileDriverIds(string);
                this.deregisterProfileForDriverId(string);
                if (iterator != null) {
                    iterator.remove();
                } else {
                    this.deregisterTimeRefForDriverId(string);
                }
                this.deregisterDescriptorForDriverId(string);
            }
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "deregisterDriver", "Processed deregister driver for driverId: " + string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile.DataSource registerDataSource(DataSourceDescriptor dataSourceDescriptor) throws CMXException {
        Profile.DataSource dataSource = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerDataSource", "ENTRY " + Arrays.deepToString(new Object[]{dataSourceDescriptor, this.queryService_}));
        }
        if (this.queryService_ != null) {
            dataSource = this.queryService_.registerDataSource(dataSourceDescriptor);
            Registry registry = this.queryServiceRegistry_;
            synchronized (registry) {
                long l10 = System.currentTimeMillis();
                if (dataSource != null) {
                    Database database = dataSource.getTargetDatabase();
                    if (database != null) {
                        String string = database.getLogicalName();
                        this.registerNewDatabaseForLogicalDatabaseName(string, database);
                    }
                    this.queryServiceRegistry_.registerNewProfileForDataSourceId(dataSourceDescriptor.getDataSourceId(), dataSource);
                    this.registerNewDataSourceProfileForProfileName(dataSource.getName(), dataSource);
                }
                this.registerNewTimeRefForDataSourceId(dataSourceDescriptor.getDataSourceId(), l10);
                this.registerNewDescriptorForDataSourceId(dataSourceDescriptor.getDataSourceId(), dataSourceDescriptor);
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "registerDataSource", dataSource);
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deregisterDataSource(String string, Iterator iterator) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, this.queryService_}));
        }
        if (this.queryService_ != null) {
            this.queryService_.deregisterDataSource(string);
            Registry registry = this.queryServiceRegistry_;
            synchronized (registry) {
                this.queryServiceRegistry_.removeDataSourceIdFromProfileDataSourceIds(string);
                this.queryServiceRegistry_.removeDataSourceIdFromLogicalDatabaseDataSourceIds(string);
                this.deregisterProfileForDataSourceId(string);
                if (iterator != null) {
                    iterator.remove();
                } else {
                    this.deregisterTimeRefForDataSourceId(string);
                }
                this.deregisterDescriptorForDataSourceId(string);
            }
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "deregisterDataSource", "Processed deregister datasource for datasourceId: " + string);
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void processMessage(Message message, HttpServletRequest httpServletRequest) throws Exception {
        int n2 = httpServletRequest.getIntHeader("CMX-Client-Processor-Version");
        int n3 = this.getNegotiatedVersion(n2);
        JSONArray jSONArray = JSONHelper.convertJSONByteBuffer(message);
        String string = jSONArray.get(0).toString();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "processMessage", "ENTRY " + Arrays.deepToString(new Object[]{string}));
        }
        if (!string.equals("9")) {
            if (string.equals("10")) {
                if (this.queryServiceMonitor_ != null) {
                    String string2 = (String)jSONArray.get(1);
                    String string3 = (String)jSONArray.get(2);
                    String string4 = (String)jSONArray.get(3);
                    String string5 = (String)jSONArray.get(4);
                    SQLException sQLException = CMXImplMessageHelper.getInstance().parseSQLException((JSONArray)jSONArray.get(5));
                    this.queryServiceMonitor_.logApplicationException(string2, string3, string4, MonitorInterface.ClientRuntime.valueOf(string5), sQLException);
                }
            } else if (string.equals("11")) {
                if (this.queryServiceMonitor_ != null) {
                    String string6 = (String)jSONArray.get(1);
                    String string7 = (String)jSONArray.get(2);
                    String string8 = (String)jSONArray.get(3);
                    String string9 = (String)jSONArray.get(4);
                    ArrayList<PushDownError> arrayList = CMXImplMessageHelper.getInstance().parsePushDownErrors((JSONArray)jSONArray.get(5));
                    String string10 = null;
                    long l10 = -1L;
                    if (jSONArray.size() > 6) {
                        string10 = (String)jSONArray.get(6);
                        l10 = ((Number)jSONArray.get(7)).longValue();
                    }
                    if (n3 >= 6) {
                        if (string10 != null) {
                            this.queryServiceMonitor_.logPushDownErrors(string6, string7, string10, l10, MonitorInterface.ClientRuntime.valueOf(string9), arrayList);
                        } else if (string8 == null) {
                            this.queryServiceMonitor_.logPushDownErrors(string6, string7, MonitorInterface.ClientRuntime.valueOf(string9), arrayList);
                        } else {
                            this.queryServiceMonitor_.logPushDownErrors(string6, string7, string8, MonitorInterface.ClientRuntime.valueOf(string9), arrayList);
                        }
                    } else {
                        this.queryServiceMonitor_.logPushDownErrors(string6, string7, string8, MonitorInterface.ClientRuntime.valueOf(string9), arrayList);
                    }
                }
            } else if (string.equals("14")) {
                if (this.queryServiceMonitor_ != null) {
                    String string11 = (String)jSONArray.get(1);
                    String string12 = (String)jSONArray.get(2);
                    int n4 = ((Number)jSONArray.get(3)).intValue();
                    JSONArray jSONArray2 = (JSONArray)jSONArray.get(4);
                    int n5 = ((Number)jSONArray2.get(0)).intValue();
                    String string13 = (String)jSONArray2.get(1);
                    long l11 = ((Number)jSONArray2.get(2)).longValue();
                    int n6 = ((Number)jSONArray2.get(3)).intValue();
                    int n7 = ((Number)jSONArray2.get(4)).intValue();
                    JSONArray jSONArray3 = (JSONArray)jSONArray2.get(5);
                    MonitoredDataSourceAttributes monitoredDataSourceAttributes = MonitoredDataSourceAttributesImpl.parseMonitoredDataSourceAttributes((JSONArray)jSONArray2.get(6));
                    ArrayList<MonitoredStatementExecutionData> arrayList = MonitoredStatementExecutionDataImpl.parseMonitoredStatementExecutionDatas((JSONArray)jSONArray2.get(7), jSONArray3);
                    ArrayList<MonitoredTransactionExecutionData> arrayList2 = MonitoredTransactionExecutionDataImpl.parseMonitoredTransactionExecutionDatas((JSONArray)jSONArray2.get(8), jSONArray3);
                    MonitoredWebsphereData monitoredWebsphereData = MonitoredWebsphereDataImpl.parseMonitoredWebsphereData((JSONArray)jSONArray2.get(9));
                    MonitoredData monitoredData = new MonitoredData(n4, string11, string12, string13, l11, n6, n7, monitoredDataSourceAttributes, arrayList, arrayList2, monitoredWebsphereData);
                    this.queryServiceRegistry_.cacheMonitoredData(monitoredData);
                    this.queryServiceMonitor_.logPeriodicMonitoredData(monitoredData);
                }
            } else if (string.equals("12")) {
                if (this.queryServiceMonitor_ != null) {
                    String string14 = (String)jSONArray.get(1);
                    String string15 = (String)jSONArray.get(2);
                    String[] stringArray = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(3));
                    Set<ClientInfo>[] setArray = CMXImplMessageHelper.getInstance().parseClientInfoSets((JSONArray)jSONArray.get(4), n3);
                    HashMap<String, TransportPoolStatistics> hashMap = CMXImplMessageHelper.getInstance().parseTransportPoolStatisticsObject((JSONObject)jSONArray.get(5));
                    String string16 = null;
                    String string17 = null;
                    String[] stringArray2 = null;
                    String[] stringArray3 = null;
                    long[][] lArray = null;
                    long[] lArray2 = null;
                    Object[][] objectArray = null;
                    String[] stringArray4 = null;
                    String[] stringArray5 = null;
                    String[] stringArray6 = null;
                    String[] stringArray7 = null;
                    long[][] lArray3 = null;
                    if (n3 >= 6) {
                        string16 = (String)jSONArray.get(6);
                        string17 = (String)jSONArray.get(7);
                        stringArray2 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(8));
                        stringArray3 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(9));
                        lArray = CMXImplMessageHelper.getInstance().parseNumberOfTransactionsPenaltyBoxed((JSONArray)jSONArray.get(10));
                        lArray2 = CMXImplMessageHelper.getInstance().parseNumberOfTransactionsPenaltyBoxedForDataSource((JSONArray)jSONArray.get(11));
                        stringArray4 = CMXImplMessageHelper.getInstance().parseDatabaseLogicalNames((JSONArray)jSONArray.get(12));
                        stringArray5 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(13));
                        stringArray6 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(14));
                        stringArray7 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(15));
                        lArray3 = CMXImplMessageHelper.getInstance().parseNumberOfTransactionsPenaltyBoxed((JSONArray)jSONArray.get(16));
                        if (n3 >= 8) {
                            objectArray = CMXImplMessageHelper.getInstance().parseWASPoolStatistics((JSONArray)jSONArray.get(17));
                        }
                    }
                    if (this.queryServiceMonitor_.isStatisticsLoggingEnabled()) {
                        if (n3 >= 6) {
                            this.queryServiceMonitor_.logStatistics(string14, string15, string16, string17, stringArray, stringArray2, stringArray3, setArray, hashMap, lArray, lArray2, objectArray, stringArray4, stringArray5, stringArray6, stringArray7, lArray3);
                        } else {
                            this.queryServiceMonitor_.logStatistics(string14, string15, stringArray, setArray, hashMap);
                        }
                    }
                }
            } else if (string.equals("13") && this.queryServiceMonitor_ != null) {
                String string18 = (String)jSONArray.get(1);
                String string19 = (String)jSONArray.get(2);
                DriverDescriptor driverDescriptor = CMXImplMessageHelper.getInstance().parseDriverDescriptor((JSONObject)jSONArray.get(3));
                String string20 = (String)jSONArray.get(4);
                String string21 = (String)jSONArray.get(5);
                String string22 = (String)jSONArray.get(6);
                String string23 = (String)jSONArray.get(7);
                String[] stringArray = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(8));
                ClientDescriptor.DataSource[] dataSourceArray = CMXImplMessageHelper.getInstance().parseDataSourceDescriptors(driverDescriptor, (JSONArray)jSONArray.get(9));
                String[] stringArray8 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(10));
                String[] stringArray9 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(11));
                String[] stringArray10 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(12));
                String[] stringArray11 = JSONHelper.createStringArrayFromJSONArray((JSONArray)jSONArray.get(13));
                HashMap<String, String>[] hashMapArray = null;
                if (n3 >= 8) {
                    hashMapArray = CMXImplMessageHelper.getInstance().parseWASPoolConfigStatus((JSONArray)jSONArray.get(14));
                }
                this.queryServiceMonitor_.logPushDownApplication(string18, string19, driverDescriptor, string20, string21, string22, string23, stringArray, dataSourceArray, stringArray8, stringArray9, stringArray10, stringArray11, hashMapArray);
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "processMessage", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Database getDatabase(String string) {
        HashMap<String, Database> hashMap = this.queryServiceRegistry_.databaseMap_;
        synchronized (hashMap) {
            return this.queryServiceRegistry_.databaseMap_.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile.Driver getDriverProfile(String string) {
        HashMap<String, Profile.Driver> hashMap = this.queryServiceRegistry_.driverIdToProfileMap_;
        synchronized (hashMap) {
            return this.queryServiceRegistry_.driverIdToProfileMap_.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Profile.DataSource getDataSourceProfile(String string) {
        HashMap<String, Profile.DataSource> hashMap = this.queryServiceRegistry_.datasourceIdToProfileMap_;
        synchronized (hashMap) {
            return this.queryServiceRegistry_.datasourceIdToProfileMap_.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewProfileForProfileName(String string, Profile.Driver driver) {
        HashMap<String, Profile.Driver> hashMap = this.queryServiceRegistry_.driverProfileNameToProfileMap_;
        synchronized (hashMap) {
            Profile.Driver driver2 = this.queryServiceRegistry_.driverProfileNameToProfileMap_.get(string);
            if (driver2 != null) {
                driver2.updateToNewVersion(driver);
            } else {
                this.queryServiceRegistry_.driverProfileNameToProfileMap_.put(string, driver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewDataSourceProfileForProfileName(String string, Profile.DataSource dataSource) {
        HashMap<String, Profile.DataSource> hashMap = this.queryServiceRegistry_.datasourceProfileNameToProfileMap_;
        synchronized (hashMap) {
            Profile.DataSource dataSource2 = this.queryServiceRegistry_.datasourceProfileNameToProfileMap_.get(string);
            if (dataSource2 != null) {
                dataSource2.updateToNewVersion(dataSource);
            } else {
                this.queryServiceRegistry_.datasourceProfileNameToProfileMap_.put(string, dataSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewDatabaseForLogicalDatabaseName(String string, Database database) {
        HashMap<String, Database> hashMap = this.queryServiceRegistry_.databaseMap_;
        synchronized (hashMap) {
            Database database2 = this.queryServiceRegistry_.databaseMap_.get(string);
            if (database2 != null) {
                database2.updateToNewVersion(database);
            } else {
                this.queryServiceRegistry_.databaseMap_.put(string, database);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewTimeRefForDataSourceId(String string, long l10) {
        HashMap<String, Long> hashMap = this.queryServiceRegistry_.timeOfDataSourceIdReferenceMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.timeOfDataSourceIdReferenceMap_.put(string, l10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewDescriptorForDataSourceId(String string, DataSourceDescriptor dataSourceDescriptor) {
        HashMap<String, DataSourceDescriptor> hashMap = this.queryServiceRegistry_.datasourceIdToDescriptorMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.datasourceIdToDescriptorMap_.put(string, dataSourceDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterProfileForDataSourceId(String string) {
        HashMap<String, Profile.DataSource> hashMap = this.queryServiceRegistry_.datasourceIdToProfileMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.datasourceIdToProfileMap_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterTimeRefForDataSourceId(String string) {
        HashMap<String, Long> hashMap = this.queryServiceRegistry_.timeOfDataSourceIdReferenceMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.timeOfDataSourceIdReferenceMap_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDescriptorForDataSourceId(String string) {
        HashMap<String, DataSourceDescriptor> hashMap = this.queryServiceRegistry_.datasourceIdToDescriptorMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.datasourceIdToDescriptorMap_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewTimeRefForDriverId(String string, long l10) {
        HashMap<String, Long> hashMap = this.queryServiceRegistry_.timeOfDriverIdReferenceMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.timeOfDriverIdReferenceMap_.put(string, l10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerNewDescriptorForDriverId(String string, DriverDescriptor driverDescriptor) {
        HashMap<String, DriverDescriptor> hashMap = this.queryServiceRegistry_.driverIdToDescriptorMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.driverIdToDescriptorMap_.put(string, driverDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterProfileForDriverId(String string) {
        HashMap<String, Profile.Driver> hashMap = this.queryServiceRegistry_.driverIdToProfileMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.driverIdToProfileMap_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterTimeRefForDriverId(String string) {
        HashMap<String, Long> hashMap = this.queryServiceRegistry_.timeOfDriverIdReferenceMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.timeOfDriverIdReferenceMap_.remove(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterDescriptorForDriverId(String string) {
        HashMap<String, DriverDescriptor> hashMap = this.queryServiceRegistry_.driverIdToDescriptorMap_;
        synchronized (hashMap) {
            this.queryServiceRegistry_.driverIdToDescriptorMap_.remove(string);
        }
    }

    static {
        logger__ = Log.getCMXServerLogger();
    }
}

