/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.client;

import com.ibm.db2.cmx.CMXException;
import com.ibm.db2.cmx.ClientDescriptor;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.runtime.internal.PrivilegedActionHelper;
import java.io.File;
import java.io.Serializable;
import java.security.AccessController;
import java.util.HashMap;

public abstract class ClientCacheFile
implements Serializable {
    protected String filePathAndName_;
    protected int cmxOnDiskFormatLevel_;
    protected HashMap<ClientDescriptor.Driver, Profile.Driver> driverProfileCache_;
    protected HashMap<ClientDescriptor.DataSource, Profile.DataSource> datasourceProfileCache_;

    public ClientCacheFile(String string, int n2) throws CMXException {
        this.checkPermissions(string);
        this.filePathAndName_ = string;
        this.cmxOnDiskFormatLevel_ = n2;
        this.driverProfileCache_ = new HashMap();
        this.datasourceProfileCache_ = new HashMap();
    }

    private void checkPermissions(String string) throws CMXException {
        File file = new File(string);
        if (!(!AccessController.doPrivileged(PrivilegedActionHelper.doesFileExist(file)).booleanValue() || AccessController.doPrivileged(PrivilegedActionHelper.canReadFile(file)).booleanValue() && AccessController.doPrivileged(PrivilegedActionHelper.canWriteFile(file)).booleanValue())) {
            throw new CMXException(5);
        }
    }

    public abstract File getFile();

    public abstract Profile.DataSource readDataSource(ClientDescriptor.DataSource var1);

    public abstract Profile.Driver readDriver(ClientDescriptor.Driver var1);

    public abstract void writeDataSource(ClientDescriptor.DataSource var1, Profile.DataSource var2);

    public abstract void writeDriver(ClientDescriptor.Driver var1, Profile.Driver var2);
}

