/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.support;

import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.support.exceptions.ErrorException;
import java.util.Iterator;

public class LogUtilities {
    public static void logDebug(ErrorException errorException, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logDebug");
        String string = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string2 = clazz.getSimpleName();
            String string3 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string3 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string2;
            }
            iLogger.logDebug(string3, string2, string, errorException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logDebug("<error>", stackTraceElement.getClassName(), string, errorException);
        }
    }

    public static void logDebug(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.DEBUG, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logDebug");
        String string2 = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string2.equals("<init>")) {
                string2 = string3;
            }
            iLogger.logDebug(string4, string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logDebug("<error>", stackTraceElement.getClassName(), string2, string);
        }
    }

    public static void logError(ErrorException errorException, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logError");
        String string = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string2 = clazz.getSimpleName();
            String string3 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string3 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string2;
            }
            iLogger.logError(string3, string2, string, errorException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logError("<error>", stackTraceElement.getClassName(), string, errorException);
        }
    }

    public static void logError(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        String string = stackTraceElement.getMethodName();
        String string2 = exception.getLocalizedMessage();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string3;
            }
            iLogger.logError(string4, string3, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logError("<error>", stackTraceElement.getClassName(), string, string2);
        }
    }

    public static void logError(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.ERROR, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logError");
        String string2 = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string2.equals("<init>")) {
                string2 = string3;
            }
            iLogger.logError(string4, string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logError("<error>", stackTraceElement.getClassName(), string2, string);
        }
    }

    public static void logFunctionEntrance(ILogger iLogger, Object ... objectArray) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logFunctionEntrance");
        String string = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string2 = clazz.getSimpleName();
            String string3 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string3 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string2;
            }
            string = string + LogUtilities.formatArguments(objectArray);
            iLogger.logFunctionEntrance(string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logFunctionEntrance("<error>", stackTraceElement.getClassName(), string);
        }
    }

    public static void logInfo(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        String string = stackTraceElement.getMethodName();
        String string2 = exception.getLocalizedMessage();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string3;
            }
            iLogger.logInfo(string4, string3, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logInfo("<error>", stackTraceElement.getClassName(), string, string2);
        }
    }

    public static void logInfo(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.INFO, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logInfo");
        String string2 = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string2.equals("<init>")) {
                string2 = string3;
            }
            iLogger.logInfo(string4, string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logInfo("<error>", stackTraceElement.getClassName(), string2, string);
        }
    }

    public static void logTrace(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.TRACE, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logTrace");
        String string2 = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string2.equals("<init>")) {
                string2 = string3;
            }
            iLogger.logTrace(string4, string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logTrace("<error>", stackTraceElement.getClassName(), string2, string);
        }
    }

    public static void logWarning(Exception exception, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = exception.getStackTrace()[0];
        String string = stackTraceElement.getMethodName();
        String string2 = exception.getLocalizedMessage();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string.equals("<init>")) {
                string = string3;
            }
            iLogger.logWarning(string4, string3, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logWarning("<error>", stackTraceElement.getClassName(), string, string2);
        }
    }

    public static void logWarning(String string, ILogger iLogger) {
        if (!LogUtilities.shouldLogLevel(LogLevel.WARNING, iLogger)) {
            return;
        }
        StackTraceElement stackTraceElement = LogUtilities.getStackElementAbove("logWarning");
        String string2 = stackTraceElement.getMethodName();
        try {
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string3 = clazz.getSimpleName();
            String string4 = "";
            Package package_ = clazz.getPackage();
            if (null != package_) {
                string4 = package_.getName();
            }
            if (string2.equals("<init>")) {
                string2 = string3;
            }
            iLogger.logWarning(string4, string3, string2, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iLogger.logWarning("<warning>", stackTraceElement.getClassName(), string2, string);
        }
    }

    public static boolean shouldLogLevel(LogLevel logLevel, ILogger iLogger) {
        return iLogger.isEnabled() && logLevel.ordinal() <= iLogger.getLogLevel().ordinal();
    }

    private static String formatArguments(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder("(");
        if (null == objectArray) {
            stringBuilder.append("null");
        } else {
            boolean bl = true;
            for (Object object : objectArray) {
                if (!bl) {
                    stringBuilder.append(", ");
                }
                bl = false;
                if (null == object) {
                    stringBuilder.append("null");
                    continue;
                }
                if (object instanceof String) {
                    stringBuilder.append("\"").append(object.toString()).append("\"");
                    continue;
                }
                if (object instanceof Iterable) {
                    stringBuilder.append("<");
                    bl = true;
                    Iterator iterator = ((Iterable)object).iterator();
                    while (iterator.hasNext()) {
                        if (!bl) {
                            stringBuilder.append(", ");
                        }
                        bl = false;
                        Object t = iterator.next();
                        if (null == t) {
                            stringBuilder.append("null");
                            continue;
                        }
                        stringBuilder.append(t.toString());
                    }
                    bl = false;
                    stringBuilder.append(">");
                    continue;
                }
                stringBuilder.append(object.toString());
            }
        }
        return stringBuilder.append(")").toString();
    }

    private static StackTraceElement getStackElementAbove(String string) {
        boolean bl = false;
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            if (bl) {
                return stackTraceElement;
            }
            if (!stackTraceElement.getMethodName().equals(string)) continue;
            bl = true;
        }
        return Thread.currentThread().getStackTrace()[3];
    }
}

