/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultsetinput.AbstractDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterDataStream
extends AbstractDataStream {
    private Reader m_reader = null;

    public CharacterDataStream(Reader reader, int n, int n2, IWarningListener iWarningListener) {
        super(null, n, n2, iWarningListener);
        this.m_reader = reader;
    }

    @Override
    public void close() {
        super.close();
        if (!this.isClosed()) {
            try {
                this.m_reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_reader = null;
        }
    }

    @Override
    public Pair<DataWrapper, Long> getNextValue() throws SQLException {
        if (this.isClosed()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, new Object[0]);
        }
        if (!this.hasMoreData()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_EMPTY, this.m_warningListener, new Object[0]);
        }
        int n = this.getNumToFetch();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        try {
            while (n2 + this.m_numRead < n) {
                int n3 = this.m_reader.read();
                if (-1 == n3) {
                    throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_UNEXPECTED_END, this.m_warningListener, new Object[0]);
                }
                stringBuffer.append((char)n3);
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw ExceptionConverter.toSQLException(iOException, this.m_warningListener);
        }
        this.m_numRead += n2;
        DataWrapper dataWrapper = new DataWrapper();
        try {
            if (12 == this.m_type) {
                dataWrapper.setVarChar(stringBuffer.toString());
            } else {
                dataWrapper.setLongVarChar(stringBuffer.toString());
            }
        }
        catch (Exception exception) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_CORRUPT_UTF, this.m_warningListener, new Object[0]);
        }
        return new Pair<DataWrapper, Long>(dataWrapper, Long.valueOf(n2 * 2));
    }

    @Override
    protected boolean isClosed() {
        return null == this.m_reader;
    }
}

