/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultsetinput;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageBuilder;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultsetinput.AbstractDataStream;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryDataStream
extends AbstractDataStream {
    public BinaryDataStream(InputStream inputStream, int n, int n2, IWarningListener iWarningListener) {
        super(inputStream, n, n2, iWarningListener);
    }

    @Override
    public Pair<DataWrapper, Long> getNextValue() throws SQLException {
        if (this.isClosed()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_CLOSED, this.m_warningListener, new Object[0]);
        }
        if (!this.hasMoreData()) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_EMPTY, this.m_warningListener, new Object[0]);
        }
        int n = this.getNumToFetch();
        byte[] byArray = new byte[n];
        int n2 = 0;
        try {
            n2 = this.m_stream.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw ExceptionConverter.toSQLException(iOException, this.m_warningListener);
        }
        if (-1 == n2) {
            throw JDBCMessageBuilder.createSQLException(JDBCMessageKey.STREAM_UNEXPECTED_END, this.m_warningListener, new Object[0]);
        }
        this.m_numRead += n2;
        DataWrapper dataWrapper = new DataWrapper();
        if (-3 == this.m_type) {
            dataWrapper.setVarBinary(byArray);
        } else {
            dataWrapper.setLongVarBinary(byArray);
        }
        return new Pair<DataWrapper, Long>(dataWrapper, Long.valueOf(n2));
    }
}

