/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultset;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultset.IStream;
import java.io.IOException;
import java.io.Reader;

public class CharacterStream
extends Reader
implements IStream {
    private IResultSet m_result = null;
    private int m_column = 0;
    private int m_resultSetOffset = 0;
    private boolean m_hasMoreData = true;
    private int m_stringOffset = 0;
    private String m_stringBuffer = "";
    private DataWrapper m_data = new DataWrapper();

    public CharacterStream(IResultSet iResultSet, int n) {
        this.m_result = iResultSet;
        this.m_column = n;
    }

    public void close() throws IOException {
        this.m_result = null;
        this.m_stringBuffer = null;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (null == cArray) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_BUFFER.name());
        }
        if (0 > n || cArray.length < n) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_INVALID_OFFSET.name(), new String[]{String.valueOf(n), String.valueOf(cArray.length)});
        }
        int n3 = 0;
        int n4 = cArray.length - n;
        for (n3 = 0; n3 < n4 && n3 < n2; ++n3) {
            if (this.m_stringOffset >= this.m_stringBuffer.length() && !this.fetchMoreData()) {
                return -1;
            }
            cArray[n3 + n] = this.m_stringBuffer.charAt(this.m_stringOffset++);
        }
        return n3;
    }

    private boolean fetchMoreData() throws InputOutputException {
        if (!this.m_hasMoreData) {
            return false;
        }
        try {
            this.m_hasMoreData = this.m_result.getData(this.m_column, this.m_resultSetOffset, 4000L, this.m_data);
            this.m_stringOffset = 0;
            this.m_resultSetOffset += 4000;
            this.m_stringBuffer = (String)this.m_data.getObject();
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
        return 0 != this.m_stringBuffer.length();
    }
}

