/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.resultset;

import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.resultset.AbstractInputStream;
import java.io.IOException;

public abstract class AbstractCharacterStream
extends AbstractInputStream {
    private final String m_charSet;

    protected AbstractCharacterStream(IResultSet iResultSet, int n, String string) {
        super(iResultSet, n);
        this.m_charSet = string;
    }

    public int available() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        return 0;
    }

    public int read() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (this.m_buffer.length <= this.m_bufferOffset) {
            if (!this.m_moreData) {
                return -1;
            }
            this.fetchNewData();
            if (0 == this.m_buffer.length) {
                return -1;
            }
        }
        return this.m_buffer[this.m_bufferOffset++];
    }

    private void fetchNewData() throws IOException {
        try {
            DataWrapper dataWrapper = new DataWrapper();
            this.m_moreData = this.m_result.getData(this.m_column, this.m_readOffset, 4000L, dataWrapper);
            this.m_bufferOffset = 0;
            this.m_readOffset += 4000;
            this.m_buffer = ((String)dataWrapper.getObject()).getBytes(this.m_charSet);
            if (1 < this.m_buffer.length && this.m_charSet.startsWith("UTF-16") && (-1 == this.m_buffer[0] && -2 == this.m_buffer[1] || -2 == this.m_buffer[0] && -1 == this.m_buffer[1])) {
                this.m_bufferOffset = 2;
            }
        }
        catch (Exception exception) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_READ_ERROR.name());
        }
    }
}

