/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.security;

import com.vertica.dsi.security.IIntegratedSecurityManager;
import com.vertica.dsi.security.ISecurityContext;
import com.vertica.security.LocalSecurityContext;
import com.vertica.support.ILogger;
import com.vertica.support.LogUtilities;
import java.security.AccessController;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public class LocalIntegratedSecurityManager
implements IIntegratedSecurityManager {
    private static Oid s_kerberos5Oid;
    private ILogger m_log;

    public LocalIntegratedSecurityManager(ILogger iLogger) throws GSSException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        if (null != s_kerberos5Oid) {
            s_kerberos5Oid = new Oid("1.2.840.113554.1.2.2");
        }
        this.m_log = iLogger;
    }

    public void enableThreadImpersonation(boolean bl) throws OperationNotSupportedException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
    }

    public ILogger getLogger() {
        return this.m_log;
    }

    public ISecurityContext getNewSecurityContext(String string) throws GSSException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return new LocalSecurityContext(string, s_kerberos5Oid, this.m_log);
    }

    public Object getSubject() {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return Subject.getSubject(AccessController.getContext());
    }

    public void setLogger(ILogger iLogger) {
        this.m_log = iLogger;
    }
}

