/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VDriver;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.localization.VMessageKey;
import java.util.Locale;

public class VerticaYearMonthInterval
extends DSIMonthSpan
implements Cloneable {
    public static final int INTERVAL_YEAR = 101;
    public static final int INTERVAL_YEAR_TO_MONTH = 107;
    public static final int INTERVAL_MONTH = 102;
    private static final int MONTHS_PER_YEAR = 12;
    private static Locale s_locale;

    public VerticaYearMonthInterval(int n, int n2, boolean bl) {
        this(107, n, n2, bl);
    }

    public VerticaYearMonthInterval(int n, int n2, int n3, boolean bl) {
        super(VerticaYearMonthInterval.checkType(n), 0, 0, bl);
        s_locale = Locale.getDefault();
        this.convertAndSet(n2, n3);
    }

    public void setYear(int n) {
        this.convertAndSet(n, this.getMonth());
    }

    public void setMonth(int n) {
        this.convertAndSet(this.getYear(), n);
    }

    public int hashCode() {
        return (this.isNegative() ? -1 : 1) * (this.getYear() * 12 + this.getMonth());
    }

    public boolean equals(Object object) {
        if (object instanceof VerticaYearMonthInterval) {
            VerticaYearMonthInterval verticaYearMonthInterval = (VerticaYearMonthInterval)object;
            VerticaYearMonthInterval verticaYearMonthInterval2 = new VerticaYearMonthInterval(107, verticaYearMonthInterval.getYear(), verticaYearMonthInterval.getMonth(), verticaYearMonthInterval.isNegative());
            VerticaYearMonthInterval verticaYearMonthInterval3 = this.getIntervalType() == 107 ? this : new VerticaYearMonthInterval(107, this.getYear(), this.getMonth(), this.isNegative());
            return verticaYearMonthInterval3.isNegative() == verticaYearMonthInterval2.isNegative() && verticaYearMonthInterval3.getYear() == verticaYearMonthInterval2.getYear() && verticaYearMonthInterval3.getMonth() == verticaYearMonthInterval2.getMonth();
        }
        return false;
    }

    public VerticaYearMonthInterval clone() throws CloneNotSupportedException {
        return new VerticaYearMonthInterval(this.getIntervalType(), this.getYear(), this.getMonth(), this.isNegative());
    }

    public String toString() {
        int n = this.getIntervalType();
        int n2 = this.getYear();
        int n3 = this.getMonth();
        String string = this.isNegative() ? "-" : "";
        switch (n) {
            case 101: {
                return String.format((n2 == 0 ? "" : string) + "%d", n2);
            }
            case 107: {
                if (n2 != 0) {
                    return String.format(string + "%d-%02d", n2, n3);
                }
                if (n3 != 0) {
                    return String.format(string + "%02d", n3);
                }
                return "0";
            }
            case 102: {
                return String.format((n3 == 0 ? "" : string) + "%d", n3);
            }
        }
        assert (false);
        return String.format(string + "%d-%02d", n2, n3);
    }

    public int getIntervalType() {
        return super.getIntervalType();
    }

    private void convertAndSet(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_NEGATIVE_INTERVAL_FIELD.toString()));
        }
        int n3 = this.getIntervalType();
        switch (n3) {
            case 101: {
                n += n2 / 12;
                n2 = 0;
                break;
            }
            case 107: {
                n += n2 / 12;
                n2 %= 12;
                break;
            }
            case 102: {
                n2 += n * 12;
                n = 0;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        if (n < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "years"));
        }
        if (n2 < 0) {
            throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INTERVAL_FIELD_OVERFLOW.toString(), "months"));
        }
        super.setYear(n);
        super.setMonth(n2);
    }

    private static int checkType(int n) {
        switch (n) {
            case 101: 
            case 102: 
            case 107: {
                return n;
            }
        }
        throw new IllegalArgumentException(VDriver.s_msgSrc.loadMessage(s_locale, 101, VMessageKey.ERROR_INVALID_INTERVAL_TYPE.toString(), n + ""));
    }

    public static boolean isYearMonthInterval(int n) {
        switch (n) {
            case 101: 
            case 102: 
            case 107: {
                return true;
            }
        }
        return false;
    }
}

